/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weibo4j.RetweetDetails;
import weibo4j.User;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Comment
extends WeiboResponse
implements Serializable {
    private Date createdAt;
    private long id;
    private String text;
    private String source;
    private boolean isTruncated;
    private long inReplyToStatusId;
    private int inReplyToUserId;
    private boolean isFavorited;
    private String inReplyToScreenName;
    private double latitude = -1.0;
    private double longitude = -1.0;
    private RetweetDetails retweetDetails;
    private static final long serialVersionUID = 1608000492860584608L;
    private User user = null;

    Comment(Response response, Weibo weibo) throws WeiboException {
        super(response);
        Element element = response.asDocument().getDocumentElement();
        this.init(response, element, weibo);
    }

    Comment(Response response) throws WeiboException {
        super(response);
        JSONObject jSONObject = response.asJSONObject();
        try {
            this.id = jSONObject.getLong("id");
            this.text = jSONObject.getString("text");
            this.source = jSONObject.getString("source");
            this.createdAt = Comment.parseDate(jSONObject.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            if (!jSONObject.isNull("user")) {
                this.user = new User(jSONObject.getJSONObject("user"));
            }
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    public Comment(JSONObject jSONObject) throws WeiboException, JSONException {
        this.id = jSONObject.getLong("id");
        this.text = jSONObject.getString("text");
        this.source = jSONObject.getString("source");
        this.createdAt = Comment.parseDate(jSONObject.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        if (!jSONObject.isNull("user")) {
            this.user = new User(jSONObject.getJSONObject("user"));
        }
    }

    Comment(Response response, Element element, Weibo weibo) throws WeiboException {
        super(response);
        this.init(response, element, weibo);
    }

    public Comment(String string) throws WeiboException, JSONException {
        JSONObject jSONObject = new JSONObject(string);
        this.id = jSONObject.getLong("id");
        this.text = jSONObject.getString("text");
        this.source = jSONObject.getString("source");
        this.createdAt = Comment.parseDate(jSONObject.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        this.user = new User(jSONObject.getJSONObject("user"));
    }

    private void init(Response response, Element element, Weibo weibo) throws WeiboException {
        Comment.ensureRootNodeNameIs("comment", element);
        this.user = new User(response, (Element)element.getElementsByTagName("user").item(0), weibo);
        this.id = Comment.getChildLong("id", element);
        this.text = Comment.getChildText("text", element);
        this.source = Comment.getChildText("source", element);
        this.createdAt = Comment.getChildDate("created_at", element);
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public long getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public int getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean isFavorited() {
        return this.isFavorited;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isRetweet() {
        return null != this.retweetDetails;
    }

    public RetweetDetails getRetweetDetails() {
        return this.retweetDetails;
    }

    static List<Comment> constructStatuses(Response response, Weibo weibo) throws WeiboException {
        Document document = response.asDocument();
        if (Comment.isRootNodeNilClasses(document)) {
            return new ArrayList<Comment>(0);
        }
        try {
            Comment.ensureRootNodeNameIs("statuses", document);
            NodeList nodeList = document.getDocumentElement().getElementsByTagName("status");
            int n = nodeList.getLength();
            ArrayList<Comment> arrayList = new ArrayList<Comment>(n);
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                arrayList.add(new Comment(response, element, weibo));
            }
            return arrayList;
        }
        catch (WeiboException weiboException) {
            Comment.ensureRootNodeNameIs("nil-classes", document);
            return new ArrayList<Comment>(0);
        }
    }

    static List<Comment> constructComments(Response response) throws WeiboException {
        try {
            JSONArray jSONArray = response.asJSONArray();
            int n = jSONArray.length();
            ArrayList<Comment> arrayList = new ArrayList<Comment>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new Comment(jSONArray.getJSONObject(i)));
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException);
        }
        catch (WeiboException weiboException) {
            throw weiboException;
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return object instanceof Comment && ((Comment)object).id == this.id;
    }

    public String toString() {
        return "Comment{createdAt=" + this.createdAt + ", id=" + this.id + ", text='" + this.text + '\'' + ", source='" + this.source + '\'' + ", isTruncated=" + this.isTruncated + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", isFavorited=" + this.isFavorited + ", inReplyToScreenName='" + this.inReplyToScreenName + '\'' + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", retweetDetails=" + this.retweetDetails + ", user=" + this.user + '}';
    }
}

