/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.Properties;
import weibo4j.Version;

public class Configuration {
    private static Properties defaultProperty;
    private static boolean DALVIK;

    static void init() {
        defaultProperty = new Properties();
        defaultProperty.setProperty("weibo4j.debug", "true");
        defaultProperty.setProperty("weibo4j.source", "1935062235");
        defaultProperty.setProperty("weibo4j.clientURL", "http://open.t.sina.com.cn/-{weibo4j.clientVersion}.xml");
        defaultProperty.setProperty("weibo4j.http.userAgent", "weibo4j http://open.t.sina.com.cn/ /{weibo4j.clientVersion}");
        defaultProperty.setProperty("weibo4j.http.useSSL", "false");
        defaultProperty.setProperty("weibo4j.http.proxyHost.fallback", "http.proxyHost");
        defaultProperty.setProperty("weibo4j.http.proxyPort.fallback", "http.proxyPort");
        defaultProperty.setProperty("weibo4j.http.connectionTimeout", "20000");
        defaultProperty.setProperty("weibo4j.http.readTimeout", "120000");
        defaultProperty.setProperty("weibo4j.http.retryCount", "3");
        defaultProperty.setProperty("weibo4j.http.retryIntervalSecs", "10");
        defaultProperty.setProperty("weibo4j.async.numThreads", "1");
        defaultProperty.setProperty("weibo4j.clientVersion", Version.getVersion());
        try {
            Class.forName("dalvik.system.VMRuntime");
            defaultProperty.setProperty("weibo4j.dalvik", "true");
        }
        catch (ClassNotFoundException classNotFoundException) {
            defaultProperty.setProperty("weibo4j.dalvik", "false");
        }
        DALVIK = Configuration.getBoolean("weibo4j.dalvik");
        String string = "weibo4j.properties";
        boolean bl = Configuration.loadProperties(defaultProperty, "." + File.separatorChar + string) || Configuration.loadProperties(defaultProperty, Configuration.class.getResourceAsStream("/WEB-INF/" + string)) || Configuration.loadProperties(defaultProperty, Configuration.class.getResourceAsStream("/" + string));
    }

    private static boolean loadProperties(Properties properties, String string) {
        try {
            File file = new File(string);
            if (file.exists() && file.isFile()) {
                properties.load(new FileInputStream(file));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean loadProperties(Properties properties, InputStream inputStream) {
        try {
            properties.load(inputStream);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDalvik() {
        return DALVIK;
    }

    public static boolean useSSL() {
        return Configuration.getBoolean("weibo4j.http.useSSL");
    }

    public static String getScheme() {
        return Configuration.useSSL() ? "https://" : "http://";
    }

    public static String getCilentVersion() {
        return Configuration.getProperty("weibo4j.clientVersion");
    }

    public static String getCilentVersion(String string) {
        return Configuration.getProperty("weibo4j.clientVersion", string);
    }

    public static String getSource() {
        return Configuration.getProperty("weibo4j.source");
    }

    public static String getSource(String string) {
        return Configuration.getProperty("weibo4j.source", string);
    }

    public static String getProxyHost() {
        return Configuration.getProperty("weibo4j.http.proxyHost");
    }

    public static String getProxyHost(String string) {
        return Configuration.getProperty("weibo4j.http.proxyHost", string);
    }

    public static String getProxyUser() {
        return Configuration.getProperty("weibo4j.http.proxyUser");
    }

    public static String getProxyUser(String string) {
        return Configuration.getProperty("weibo4j.http.proxyUser", string);
    }

    public static String getClientURL() {
        return Configuration.getProperty("weibo4j.clientURL");
    }

    public static String getClientURL(String string) {
        return Configuration.getProperty("weibo4j.clientURL", string);
    }

    public static String getProxyPassword() {
        return Configuration.getProperty("weibo4j.http.proxyPassword");
    }

    public static String getProxyPassword(String string) {
        return Configuration.getProperty("weibo4j.http.proxyPassword", string);
    }

    public static int getProxyPort() {
        return Configuration.getIntProperty("weibo4j.http.proxyPort");
    }

    public static int getProxyPort(int n) {
        return Configuration.getIntProperty("weibo4j.http.proxyPort", n);
    }

    public static int getConnectionTimeout() {
        return Configuration.getIntProperty("weibo4j.http.connectionTimeout");
    }

    public static int getConnectionTimeout(int n) {
        return Configuration.getIntProperty("weibo4j.http.connectionTimeout", n);
    }

    public static int getReadTimeout() {
        return Configuration.getIntProperty("weibo4j.http.readTimeout");
    }

    public static int getReadTimeout(int n) {
        return Configuration.getIntProperty("weibo4j.http.readTimeout", n);
    }

    public static int getRetryCount() {
        return Configuration.getIntProperty("weibo4j.http.retryCount");
    }

    public static int getRetryCount(int n) {
        return Configuration.getIntProperty("weibo4j.http.retryCount", n);
    }

    public static int getRetryIntervalSecs() {
        return Configuration.getIntProperty("weibo4j.http.retryIntervalSecs");
    }

    public static int getRetryIntervalSecs(int n) {
        return Configuration.getIntProperty("weibo4j.http.retryIntervalSecs", n);
    }

    public static String getUser() {
        return Configuration.getProperty("weibo4j.user");
    }

    public static String getUser(String string) {
        return Configuration.getProperty("weibo4j.user", string);
    }

    public static String getPassword() {
        return Configuration.getProperty("weibo4j.password");
    }

    public static String getPassword(String string) {
        return Configuration.getProperty("weibo4j.password", string);
    }

    public static String getUserAgent() {
        return Configuration.getProperty("weibo4j.http.userAgent");
    }

    public static String getUserAgent(String string) {
        return Configuration.getProperty("weibo4j.http.userAgent", string);
    }

    public static String getOAuthConsumerKey() {
        return Configuration.getProperty("weibo4j.oauth.consumerKey");
    }

    public static String getOAuthConsumerKey(String string) {
        return Configuration.getProperty("weibo4j.oauth.consumerKey", string);
    }

    public static String getOAuthConsumerSecret() {
        return Configuration.getProperty("weibo4j.oauth.consumerSecret");
    }

    public static String getOAuthConsumerSecret(String string) {
        return Configuration.getProperty("weibo4j.oauth.consumerSecret", string);
    }

    public static boolean getBoolean(String string) {
        String string2 = Configuration.getProperty(string);
        return Boolean.valueOf(string2);
    }

    public static int getIntProperty(String string) {
        String string2 = Configuration.getProperty(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static int getIntProperty(String string, int n) {
        String string2 = Configuration.getProperty(string, String.valueOf(n));
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static long getLongProperty(String string) {
        String string2 = Configuration.getProperty(string);
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static String getProperty(String string) {
        return Configuration.getProperty(string, null);
    }

    public static String getProperty(String string, String string2) {
        String string3;
        try {
            String string4;
            string3 = System.getProperty(string, string2);
            if (null == string3) {
                string3 = defaultProperty.getProperty(string);
            }
            if (null == string3 && null != (string4 = defaultProperty.getProperty(string + ".fallback"))) {
                string3 = System.getProperty(string4);
            }
        }
        catch (AccessControlException accessControlException) {
            string3 = string2;
        }
        return Configuration.replace(string3);
    }

    private static String replace(String string) {
        String string2;
        int n;
        if (null == string) {
            return string;
        }
        String string3 = string;
        int n2 = 0;
        if (-1 != (n2 = string.indexOf("{", n2)) && (n = string.indexOf("}", n2)) > n2 + 1 && (string2 = string.substring(n2 + 1, n)).length() > 0) {
            string3 = string.substring(0, n2) + Configuration.getProperty(string2) + string.substring(n + 1);
        }
        if (string3.equals(string)) {
            return string;
        }
        return Configuration.replace(string3);
    }

    public static int getNumberOfAsyncThreads() {
        return Configuration.getIntProperty("weibo4j.async.numThreads");
    }

    public static boolean getDebug() {
        return Configuration.getBoolean("weibo4j.debug");
    }

    static {
        Configuration.init();
    }
}

