/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import weibo4j.WeiboException;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Count
implements Serializable {
    private static final long serialVersionUID = 9076424494907778181L;
    private long id;
    private long comments;
    private long rt;
    private long dm;
    private long mentions;
    private long followers;

    public Count(JSONObject jSONObject) throws WeiboException, JSONException {
        this.id = jSONObject.getLong("id");
        this.comments = jSONObject.getLong("comments");
        this.rt = jSONObject.getLong("rt");
        this.dm = jSONObject.getLong("dm");
        this.mentions = jSONObject.getLong("mentions");
        this.followers = jSONObject.getLong("followers");
    }

    static List<Count> constructCounts(Response response) throws WeiboException {
        try {
            JSONArray jSONArray = response.asJSONArray();
            int n = jSONArray.length();
            ArrayList<Count> arrayList = new ArrayList<Count>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new Count(jSONArray.getJSONObject(i)));
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException);
        }
        catch (WeiboException weiboException) {
            throw weiboException;
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return object instanceof Count && ((Count)object).id == this.id;
    }

    public long getComments() {
        return this.comments;
    }

    public long getRt() {
        return this.rt;
    }

    public long getDm() {
        return this.dm;
    }

    public long getMentions() {
        return this.mentions;
    }

    public long getFollowers() {
        return this.followers;
    }

    public String toString() {
        return "Count{ id=" + this.id + ", comments=" + this.comments + ", rt=" + this.rt + ", dm=" + this.dm + ", mentions=" + this.mentions + ", followers=" + this.followers + '}';
    }
}

