/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.Arrays;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class IDs
extends WeiboResponse {
    private int[] ids;
    private long previousCursor;
    private long nextCursor;
    private static final long serialVersionUID = -6585026560164704953L;
    private static String[] ROOT_NODE_NAMES = new String[]{"id_list", "ids"};

    IDs(Response response) throws WeiboException {
        super(response);
        Element element = response.asDocument().getDocumentElement();
        IDs.ensureRootNodeNameIs(ROOT_NODE_NAMES, element);
        NodeList nodeList = element.getElementsByTagName("id");
        this.ids = new int[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            try {
                this.ids[i] = Integer.parseInt(nodeList.item(i).getFirstChild().getNodeValue());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new WeiboException("Weibo API returned malformed response: " + element, numberFormatException);
            }
        }
        this.previousCursor = IDs.getChildLong("previous_cursor", element);
        this.nextCursor = IDs.getChildLong("next_cursor", element);
    }

    IDs(Response response, Weibo weibo) throws WeiboException {
        super(response);
        JSONObject jSONObject = response.asJSONObject();
        try {
            this.previousCursor = jSONObject.getLong("previous_cursor");
            this.nextCursor = jSONObject.getLong("next_cursor");
            if (!jSONObject.isNull("ids")) {
                JSONArray jSONArray = jSONObject.getJSONArray("ids");
                int n = jSONArray.length();
                this.ids = new int[n];
                for (int i = 0; i < n; ++i) {
                    this.ids[i] = jSONArray.getInt(i);
                }
            }
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException);
        }
    }

    public int[] getIDs() {
        return this.ids;
    }

    public boolean hasPrevious() {
        return 0L != this.previousCursor;
    }

    public long getPreviousCursor() {
        return this.previousCursor;
    }

    public boolean hasNext() {
        return 0L != this.nextCursor;
    }

    public long getNextCursor() {
        return this.nextCursor;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IDs)) {
            return false;
        }
        IDs iDs = (IDs)object;
        return Arrays.equals(this.ids, iDs.ids);
    }

    public int hashCode() {
        return this.ids != null ? Arrays.hashCode(this.ids) : 0;
    }

    public String toString() {
        return "IDs{ids=" + this.ids + ", previousCursor=" + this.previousCursor + ", nextCursor=" + this.nextCursor + '}';
    }
}

