/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weibo4j.ListObjectWapper;
import weibo4j.User;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class ListObject
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 4208232205515192208L;
    private long id;
    private String name;
    private String fullName;
    private String slug;
    private String description;
    private String uri;
    private int subscriberCount;
    private int memberCount;
    private String mode;
    private User user;

    ListObject(Response response, Weibo weibo) throws WeiboException {
        super(response);
        this.init(response, response.asDocument().getDocumentElement(), weibo);
    }

    ListObject(Response response, Element element, Weibo weibo) throws WeiboException {
        super(response);
        this.init(response, element, weibo);
    }

    ListObject(JSONObject jSONObject) throws WeiboException {
        try {
            this.id = jSONObject.getLong("id");
            this.name = jSONObject.getString("name");
            this.fullName = jSONObject.getString("full_name");
            this.slug = jSONObject.getString("slug");
            this.description = jSONObject.getString("description");
            this.subscriberCount = jSONObject.getInt("subscriber_count");
            this.memberCount = jSONObject.getInt("member_count");
            this.uri = jSONObject.getString("uri");
            this.mode = jSONObject.getString("mode");
            if (!jSONObject.isNull("user")) {
                this.user = new User(jSONObject.getJSONObject("user"));
            }
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    private void init(Response response, Element element, Weibo weibo) throws WeiboException {
        ListObject.ensureRootNodeNameIs("list", element);
        this.id = ListObject.getChildLong("id", element);
        this.name = ListObject.getChildText("name", element);
        this.fullName = ListObject.getChildText("full_name", element);
        this.slug = ListObject.getChildText("slug", element);
        this.description = ListObject.getChildText("description", element);
        this.subscriberCount = ListObject.getChildInt("subscriber_count", element);
        this.memberCount = ListObject.getChildInt("member_count", element);
        this.uri = ListObject.getChildText("uri", element);
        this.mode = ListObject.getChildText("mode", element);
        NodeList nodeList = element.getElementsByTagName("user");
        if (nodeList.getLength() != 0) {
            Element element2 = (Element)nodeList.item(0);
            this.user = new User(response, element2, weibo);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String string) {
        this.fullName = string;
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String string) {
        this.slug = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public int getSubscriberCount() {
        return this.subscriberCount;
    }

    public void setSubscriberCount(int n) {
        this.subscriberCount = n;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public void setMemberCount(int n) {
        this.memberCount = n;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getId() {
        return this.id;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    static ListObjectWapper constructListObjects(Response response, Weibo weibo) throws WeiboException {
        Document document = response.asDocument();
        if (ListObject.isRootNodeNilClasses(document)) {
            return new ListObjectWapper(new ArrayList<ListObject>(0), 0L, 0L);
        }
        try {
            ListObject.ensureRootNodeNameIs("lists_list", document);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("lists");
            int n = nodeList.getLength();
            if (n == 0) {
                return new ListObjectWapper(new ArrayList<ListObject>(0), 0L, 0L);
            }
            Element element2 = (Element)nodeList.item(0);
            nodeList = element2.getElementsByTagName("list");
            n = nodeList.getLength();
            ArrayList<ListObject> arrayList = new ArrayList<ListObject>(n);
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                arrayList.add(new ListObject(response, element3, weibo));
            }
            long l = ListObject.getChildLong("previous_curosr", element);
            long l2 = ListObject.getChildLong("next_curosr", element);
            if (l2 == -1L) {
                l2 = ListObject.getChildLong("nextCurosr", element);
            }
            return new ListObjectWapper(arrayList, l, l2);
        }
        catch (WeiboException weiboException) {
            if (ListObject.isRootNodeNilClasses(document)) {
                return new ListObjectWapper(new ArrayList<ListObject>(0), 0L, 0L);
            }
            throw weiboException;
        }
    }

    static ListObjectWapper constructListObjects(Response response) throws WeiboException {
        JSONObject jSONObject = response.asJSONObject();
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("lists");
            int n = jSONArray.length();
            ArrayList<ListObject> arrayList = new ArrayList<ListObject>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new ListObject(jSONArray.getJSONObject(i)));
            }
            long l = jSONObject.getLong("previous_curosr");
            long l2 = jSONObject.getLong("next_cursor");
            if (l2 == -1L) {
                l2 = jSONObject.getLong("nextCursor");
            }
            return new ListObjectWapper(arrayList, l, l2);
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException);
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return object instanceof ListObject && ((ListObject)object).id == this.id;
    }

    public String toString() {
        return "ListObject{id=" + this.id + ", name='" + this.name + '\'' + ", fullName='" + this.fullName + '\'' + ", slug='" + this.slug + '\'' + ", description='" + this.description + '\'' + ", subscriberCount=" + this.subscriberCount + ", memberCount=" + this.memberCount + ", mode='" + this.mode + "', uri='" + this.uri + '\'' + ", user='" + this.user.toString() + "'}";
    }
}

