/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import org.w3c.dom.Element;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class ListUserCount
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 2638697034012299545L;
    private int listCount;
    private int subscriberCount;
    private int listedCount;

    public ListUserCount(JSONObject jSONObject) throws WeiboException, JSONException {
        this.listCount = jSONObject.getInt("lists");
        this.subscriberCount = jSONObject.getInt("subscriptions");
        this.listedCount = jSONObject.getInt("listed");
    }

    public ListUserCount(Response response) throws WeiboException {
        Element element = response.asDocument().getDocumentElement();
        ListUserCount.ensureRootNodeNameIs("count", element);
        this.listCount = ListUserCount.getChildInt("lists", element);
        this.subscriberCount = ListUserCount.getChildInt("subscriptions", element);
        this.listedCount = ListUserCount.getChildInt("listed", element);
    }

    public int hashCode() {
        return this.listCount * 100 + this.subscriberCount * 10 + this.listedCount;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return object instanceof ListUserCount && ((ListUserCount)object).hashCode() == this.hashCode();
    }

    public int getListCount() {
        return this.listCount;
    }

    public void setListCount(int n) {
        this.listCount = n;
    }

    public int getSubscriberCount() {
        return this.subscriberCount;
    }

    public void setSubscriberCount(int n) {
        this.subscriberCount = n;
    }

    public int getListedCount() {
        return this.listedCount;
    }

    public void setListedCount(int n) {
        this.listedCount = n;
    }

    public String toString() {
        return "ListUserCount{listCount=" + this.listCount + ", subscriberCount=" + this.subscriberCount + ", listedCount=" + this.listedCount + '}';
    }
}

