/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.Date;
import org.w3c.dom.Element;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class RateLimitStatus
extends WeiboResponse {
    private int remainingHits;
    private int hourlyLimit;
    private int resetTimeInSeconds;
    private Date resetTime;
    private static final long serialVersionUID = 933996804168952707L;

    RateLimitStatus(Response response) throws WeiboException {
        super(response);
        Element element = response.asDocument().getDocumentElement();
        this.remainingHits = RateLimitStatus.getChildInt("remaining-hits", element);
        this.hourlyLimit = RateLimitStatus.getChildInt("hourly-limit", element);
        this.resetTimeInSeconds = RateLimitStatus.getChildInt("reset-time-in-seconds", element);
        this.resetTime = RateLimitStatus.getChildDate("reset-time", element, "EEE MMM d HH:mm:ss z yyyy");
    }

    RateLimitStatus(Response response, Weibo weibo) throws WeiboException {
        super(response);
        JSONObject jSONObject = response.asJSONObject();
        try {
            this.remainingHits = jSONObject.getInt("remaining_hits");
            this.hourlyLimit = jSONObject.getInt("hourly_limit");
            this.resetTimeInSeconds = jSONObject.getInt("reset_time_in_seconds");
            this.resetTime = RateLimitStatus.parseDate(jSONObject.getString("reset_time"), "EEE MMM dd HH:mm:ss z yyyy");
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    public int getRemainingHits() {
        return this.remainingHits;
    }

    public int getHourlyLimit() {
        return this.hourlyLimit;
    }

    public int getResetTimeInSeconds() {
        return this.resetTimeInSeconds;
    }

    public Date getDateTime() {
        return this.resetTime;
    }

    public Date getResetTime() {
        return this.resetTime;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RateLimitStatus{remainingHits:");
        stringBuilder.append(this.remainingHits);
        stringBuilder.append(";hourlyLimit:");
        stringBuilder.append(this.hourlyLimit);
        stringBuilder.append(";resetTimeInSeconds:");
        stringBuilder.append(this.resetTimeInSeconds);
        stringBuilder.append(";resetTime:");
        stringBuilder.append(this.resetTime);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

