/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import weibo4j.Configuration;
import weibo4j.Status;
import weibo4j.StatusListener;
import weibo4j.StatusStream;
import weibo4j.WeiboException;
import weibo4j.WeiboSupport;
import weibo4j.http.PostParameter;

public class WeiboStream
extends WeiboSupport {
    private static final boolean DEBUG = Configuration.getDebug();
    private StatusListener statusListener;
    private StreamHandlingThread handler = null;
    private int retryPerMinutes = 1;

    public WeiboStream() {
    }

    public WeiboStream(String string, String string2) {
        super(string, string2);
    }

    public WeiboStream(String string, String string2, StatusListener statusListener) {
        super(string, string2);
        this.statusListener = statusListener;
    }

    public void firehose(int n) throws WeiboException {
        this.startHandler(new StreamHandlingThread(new Object[]{n}){

            @Override
            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getFirehoseStream((Integer)this.args[0]);
            }
        });
    }

    public StatusStream getFirehoseStream(int n) throws WeiboException {
        try {
            return new StatusStream(this.http.post(this.getStreamBaseURL() + "1/statuses/firehose.json", new PostParameter[]{new PostParameter("count", String.valueOf(n))}, true));
        }
        catch (IOException iOException) {
            throw new WeiboException(iOException);
        }
    }

    public void retweet() throws WeiboException {
        this.startHandler(new StreamHandlingThread(new Object[0]){

            @Override
            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getRetweetStream();
            }
        });
    }

    public StatusStream getRetweetStream() throws WeiboException {
        try {
            return new StatusStream(this.http.post(this.getStreamBaseURL() + "1/statuses/retweet.json", new PostParameter[0], true));
        }
        catch (IOException iOException) {
            throw new WeiboException(iOException);
        }
    }

    public void sample() throws WeiboException {
        this.startHandler(new StreamHandlingThread(null){

            @Override
            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getSampleStream();
            }
        });
    }

    public StatusStream getSampleStream() throws WeiboException {
        try {
            return new StatusStream(this.http.get(this.getStreamBaseURL() + "1/statuses/sample.json", true));
        }
        catch (IOException iOException) {
            throw new WeiboException(iOException);
        }
    }

    public void filter(int n, int[] nArray, String[] stringArray) throws WeiboException {
        this.startHandler(new StreamHandlingThread(new Object[]{n, nArray, stringArray}){

            @Override
            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getFilterStream((Integer)this.args[0], (int[])this.args[1], (String[])this.args[2]);
            }
        });
    }

    public StatusStream getFilterStream(int n, int[] nArray, String[] stringArray) throws WeiboException {
        ArrayList<PostParameter> arrayList = new ArrayList<PostParameter>();
        arrayList.add(new PostParameter("count", n));
        if (null != nArray && nArray.length > 0) {
            arrayList.add(new PostParameter("follow", this.toFollowString(nArray)));
        }
        if (null != stringArray && stringArray.length > 0) {
            arrayList.add(new PostParameter("track", this.toTrackString(stringArray)));
        }
        try {
            return new StatusStream(this.http.post(this.getStreamBaseURL() + "1/statuses/filter.json", arrayList.toArray(new PostParameter[0]), true));
        }
        catch (IOException iOException) {
            throw new WeiboException(iOException);
        }
    }

    public void gardenhose() throws WeiboException {
        this.startHandler(new StreamHandlingThread(null){

            @Override
            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getGardenhoseStream();
            }
        });
    }

    public StatusStream getGardenhoseStream() throws WeiboException {
        return this.getSampleStream();
    }

    public void spritzer() throws WeiboException {
        this.startHandler(new StreamHandlingThread(null){

            @Override
            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getSpritzerStream();
            }
        });
    }

    public StatusStream getSpritzerStream() throws WeiboException {
        return this.getSampleStream();
    }

    public void birddog(int n, int[] nArray) throws WeiboException {
        this.startHandler(new StreamHandlingThread(new Object[]{n, nArray}){

            @Override
            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getBirddogStream((Integer)this.args[0], (int[])this.args[1]);
            }
        });
    }

    public StatusStream getBirddogStream(int n, int[] nArray) throws WeiboException {
        return this.getFilterStream(n, nArray, null);
    }

    public void shadow(int n, int[] nArray) throws WeiboException {
        this.startHandler(new StreamHandlingThread(new Object[]{n, nArray}){

            @Override
            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getShadowStream((Integer)this.args[0], (int[])this.args[1]);
            }
        });
    }

    public StatusStream getShadowStream(int n, int[] nArray) throws WeiboException {
        return this.getFilterStream(n, nArray, null);
    }

    public void follow(int[] nArray) throws WeiboException {
        this.startHandler(new StreamHandlingThread(new Object[]{nArray}){

            @Override
            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getFollowStream((int[])this.args[0]);
            }
        });
    }

    public StatusStream getFollowStream(int[] nArray) throws WeiboException {
        return this.getFilterStream(0, nArray, null);
    }

    private String toFollowString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(11 * nArray.length);
        for (int n : nArray) {
            if (0 != stringBuffer.length()) {
                stringBuffer.append(",");
            }
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    public void track(final String[] stringArray) throws WeiboException {
        this.startHandler(new StreamHandlingThread(null){

            @Override
            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getTrackStream(stringArray);
            }
        });
    }

    public StatusStream getTrackStream(String[] stringArray) throws WeiboException {
        return this.getFilterStream(0, null, stringArray);
    }

    private String toTrackString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(20 * stringArray.length * 4);
        for (String string : stringArray) {
            if (0 != stringBuffer.length()) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private synchronized void startHandler(StreamHandlingThread streamHandlingThread) throws WeiboException {
        this.cleanup();
        if (null == this.statusListener) {
            throw new IllegalStateException("StatusListener is not set.");
        }
        this.handler = streamHandlingThread;
        this.handler.start();
    }

    public synchronized void cleanup() {
        if (null != this.handler) {
            try {
                this.handler.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public StatusListener getStatusListener() {
        return this.statusListener;
    }

    public void setStatusListener(StatusListener statusListener) {
        this.statusListener = statusListener;
    }

    private String getStreamBaseURL() {
        return this.USE_SSL ? "https://stream.t.sina.com.cn/" : "http://stream.t.sina.com.cn/";
    }

    private void log(String string) {
        if (DEBUG) {
            System.out.println("[" + new Date() + "]" + string);
        }
    }

    private void log(String string, String string2) {
        if (DEBUG) {
            this.log(string + string2);
        }
    }

    abstract class StreamHandlingThread
    extends Thread {
        StatusStream stream;
        Object[] args;
        private List<Long> retryHistory;
        private static final String NAME = "Weibo Stream Handling Thread";
        private boolean closed;

        StreamHandlingThread(Object[] objectArray) {
            super("Weibo Stream Handling Thread[initializing]");
            this.stream = null;
            this.closed = false;
            this.args = objectArray;
            this.retryHistory = new ArrayList<Long>(WeiboStream.this.retryPerMinutes);
        }

        @Override
        public void run() {
            while (!this.closed) {
                try {
                    Status status;
                    if (this.retryHistory.size() > 0 && System.currentTimeMillis() - this.retryHistory.get(0) > 60000L) {
                        this.retryHistory.remove(0);
                    }
                    if (this.retryHistory.size() < WeiboStream.this.retryPerMinutes) {
                        this.setStatus("[establishing connection]");
                        while (!this.closed && null == this.stream) {
                            if (this.retryHistory.size() >= WeiboStream.this.retryPerMinutes) continue;
                            this.retryHistory.add(System.currentTimeMillis());
                            this.stream = this.getStream();
                        }
                    } else {
                        long l = 60000L - (System.currentTimeMillis() - this.retryHistory.get(this.retryHistory.size() - 1));
                        this.setStatus("[retry limit reached. sleeping for " + l / 1000L + " secs]");
                        try {
                            Thread.sleep(l);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (null == this.stream) continue;
                    this.setStatus("[receiving stream]");
                    while (!this.closed && null != (status = this.stream.next())) {
                        WeiboStream.this.log("received:", status.toString());
                        if (null == WeiboStream.this.statusListener) continue;
                        WeiboStream.this.statusListener.onStatus(status);
                    }
                }
                catch (WeiboException weiboException) {
                    this.stream = null;
                    weiboException.printStackTrace();
                    WeiboStream.this.log(weiboException.getMessage());
                    WeiboStream.this.statusListener.onException(weiboException);
                }
            }
        }

        public synchronized void close() throws IOException {
            this.setStatus("[disposing thread]");
            if (null != this.stream) {
                this.stream.close();
                this.closed = true;
            }
        }

        private void setStatus(String string) {
            String string2 = NAME + string;
            this.setName(string2);
            WeiboStream.this.log(string2);
        }

        abstract StatusStream getStream() throws WeiboException;
    }
}

