/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import weibo4j.Configuration;
import weibo4j.http.HttpClient;

class WeiboSupport {
    protected HttpClient http = new HttpClient();
    protected String source = Configuration.getSource();
    protected final boolean USE_SSL = Configuration.useSSL();

    WeiboSupport() {
        this(null, null);
    }

    WeiboSupport(String string, String string2) {
        this.setClientVersion(null);
        this.setClientURL(null);
        this.setUserId(string);
        this.setPassword(string2);
    }

    public void setUserAgent(String string) {
        this.http.setUserAgent(string);
    }

    public String getUserAgent() {
        return this.http.getUserAgent();
    }

    public void setClientVersion(String string) {
        this.setRequestHeader("X-Weibo-Client-Version", Configuration.getCilentVersion(string));
    }

    public String getClientVersion() {
        return this.http.getRequestHeader("X-Weibo-Client-Version");
    }

    public void setClientURL(String string) {
        this.setRequestHeader("X-Weibo-Client-URL", Configuration.getClientURL(string));
    }

    public String getClientURL() {
        return this.http.getRequestHeader("X-Weibo-Client-URL");
    }

    public synchronized void setUserId(String string) {
        this.http.setUserId(Configuration.getUser(string));
    }

    public String getUserId() {
        return this.http.getUserId();
    }

    public synchronized void setPassword(String string) {
        this.http.setPassword(Configuration.getPassword(string));
    }

    public String getPassword() {
        return this.http.getPassword();
    }

    public void setHttpProxy(String string, int n) {
        this.http.setProxyHost(string);
        this.http.setProxyPort(n);
    }

    public void setHttpProxyAuth(String string, String string2) {
        this.http.setProxyAuthUser(string);
        this.http.setProxyAuthPassword(string2);
    }

    public void setHttpConnectionTimeout(int n) {
        this.http.setConnectionTimeout(n);
    }

    public void setHttpReadTimeout(int n) {
        this.http.setReadTimeout(n);
    }

    public void setSource(String string) {
        this.source = Configuration.getSource(string);
        this.setRequestHeader("X-Weibo-Client", this.source);
    }

    public String getSource() {
        return this.source;
    }

    public void setRequestHeader(String string, String string2) {
        this.http.setRequestHeader(string, string2);
    }

    public void forceUsePost(boolean bl) {
    }

    public boolean isUsePostForced() {
        return false;
    }

    public void setRetryCount(int n) {
        this.http.setRetryCount(n);
    }

    public void setRetryIntervalSecs(int n) {
        this.http.setRetryIntervalSecs(n);
    }
}

