/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.http;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartBase;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import weibo4j.Configuration;
import weibo4j.WeiboException;
import weibo4j.http.AccessToken;
import weibo4j.http.BASE64Encoder;
import weibo4j.http.ImageItem;
import weibo4j.http.OAuth;
import weibo4j.http.OAuthToken;
import weibo4j.http.PostParameter;
import weibo4j.http.RequestToken;
import weibo4j.http.Response;

public class HttpClient
implements Serializable {
    private static final int OK = 200;
    private static final int NOT_MODIFIED = 304;
    private static final int BAD_REQUEST = 400;
    private static final int NOT_AUTHORIZED = 401;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private static final int NOT_ACCEPTABLE = 406;
    private static final int INTERNAL_SERVER_ERROR = 500;
    private static final int BAD_GATEWAY = 502;
    private static final int SERVICE_UNAVAILABLE = 503;
    private static final boolean DEBUG = Configuration.getDebug();
    private String basic = null;
    private int retryCount = Configuration.getRetryCount();
    private int retryIntervalMillis = Configuration.getRetryIntervalSecs() * 1000;
    private String userId = Configuration.getUser();
    private String password = Configuration.getPassword();
    private String proxyHost = Configuration.getProxyHost();
    private int proxyPort = Configuration.getProxyPort();
    private String proxyAuthUser = Configuration.getProxyUser();
    private String proxyAuthPassword = Configuration.getProxyPassword();
    private int connectionTimeout = Configuration.getConnectionTimeout();
    private int readTimeout = Configuration.getReadTimeout();
    private static final long serialVersionUID = 808018030183407996L;
    private static boolean isJDK14orEarlier = false;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private OAuth oauth = null;
    private String requestTokenURL = Configuration.getScheme() + "api.t.sina.com.cn/oauth/request_token";
    private String authorizationURL = Configuration.getScheme() + "api.t.sina.com.cn/oauth/authorize";
    private String authenticationURL = Configuration.getScheme() + "api.t.sina.com.cn/oauth/authenticate";
    private String accessTokenURL = Configuration.getScheme() + "api.t.sina.com.cn/oauth/access_token";
    private OAuthToken oauthToken = null;
    private String token = null;

    public HttpClient(String string, String string2) {
        this();
        this.setUserId(string);
        this.setPassword(string2);
    }

    public HttpClient() {
        this.setUserAgent(null);
        this.setOAuthConsumer(null, null);
        this.setRequestHeader("Accept-Encoding", "gzip");
    }

    public void setUserId(String string) {
        this.userId = string;
        this.encodeBasicAuthenticationString();
    }

    public void setPassword(String string) {
        this.password = string;
        this.encodeBasicAuthenticationString();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAuthenticationEnabled() {
        return null != this.basic || null != this.oauth;
    }

    public void setOAuthConsumer(String string, String string2) {
        string = Configuration.getOAuthConsumerKey(string);
        string2 = Configuration.getOAuthConsumerSecret(string2);
        if (null != string && null != string2 && 0 != string.length() && 0 != string2.length()) {
            this.oauth = new OAuth(string, string2);
        }
    }

    public RequestToken setToken(String string, String string2) {
        this.token = string;
        this.oauthToken = new RequestToken(string, string2);
        return (RequestToken)this.oauthToken;
    }

    public RequestToken getOAuthRequestToken() throws WeiboException {
        this.oauthToken = new RequestToken(this.httpRequest(this.requestTokenURL, null, true), this);
        return (RequestToken)this.oauthToken;
    }

    public RequestToken getOauthRequestToken(String string) throws WeiboException {
        this.oauthToken = new RequestToken(this.httpRequest(this.requestTokenURL, new PostParameter[]{new PostParameter("oauth_callback", string)}, true), this);
        return (RequestToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(RequestToken requestToken) throws WeiboException {
        try {
            this.oauthToken = requestToken;
            this.oauthToken = new AccessToken(this.httpRequest(this.accessTokenURL, new PostParameter[0], true));
        }
        catch (WeiboException weiboException) {
            throw new WeiboException("The user has not given access to the account.", weiboException, weiboException.getStatusCode());
        }
        return (AccessToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(RequestToken requestToken, String string) throws WeiboException {
        try {
            this.oauthToken = requestToken;
            this.oauthToken = new AccessToken(this.httpRequest(this.accessTokenURL, new PostParameter[]{new PostParameter("oauth_verifier", string)}, true));
        }
        catch (WeiboException weiboException) {
            throw new WeiboException("The user has not given access to the account.", weiboException, weiboException.getStatusCode());
        }
        return (AccessToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(String string, String string2) throws WeiboException {
        try {
            this.oauthToken = new OAuthToken(string, string2){};
            this.oauthToken = new AccessToken(this.httpRequest(this.accessTokenURL, new PostParameter[0], true));
        }
        catch (WeiboException weiboException) {
            throw new WeiboException("The user has not given access to the account.", weiboException, weiboException.getStatusCode());
        }
        return (AccessToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(String string, String string2, String string3) throws WeiboException {
        try {
            this.oauthToken = new OAuthToken(string, string2){};
            this.oauthToken = new AccessToken(this.httpRequest(this.accessTokenURL, new PostParameter[]{new PostParameter("oauth_verifier", string3)}, true));
        }
        catch (WeiboException weiboException) {
            throw new WeiboException("The user has not given access to the account.", weiboException, weiboException.getStatusCode());
        }
        return (AccessToken)this.oauthToken;
    }

    public void setOAuthAccessToken(AccessToken accessToken) {
        this.oauthToken = accessToken;
    }

    public void setRequestTokenURL(String string) {
        this.requestTokenURL = string;
    }

    public String getRequestTokenURL() {
        return this.requestTokenURL;
    }

    public void setAuthorizationURL(String string) {
        this.authorizationURL = string;
    }

    public String getAuthorizationURL() {
        return this.authorizationURL;
    }

    public String getAuthenticationRL() {
        return this.authenticationURL;
    }

    public void setAccessTokenURL(String string) {
        this.accessTokenURL = string;
    }

    public String getAccessTokenURL() {
        return this.accessTokenURL;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String string) {
        this.proxyHost = Configuration.getProxyHost(string);
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int n) {
        this.proxyPort = Configuration.getProxyPort(n);
    }

    public String getProxyAuthUser() {
        return this.proxyAuthUser;
    }

    public void setProxyAuthUser(String string) {
        this.proxyAuthUser = Configuration.getProxyUser(string);
    }

    public String getProxyAuthPassword() {
        return this.proxyAuthPassword;
    }

    public void setProxyAuthPassword(String string) {
        this.proxyAuthPassword = Configuration.getProxyPassword(string);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout = Configuration.getConnectionTimeout(n);
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = Configuration.getReadTimeout(n);
    }

    private void encodeBasicAuthenticationString() {
        if (null != this.userId && null != this.password) {
            this.basic = "Basic " + new String(new BASE64Encoder().encode((this.userId + ":" + this.password).getBytes()));
            this.oauth = null;
        }
    }

    public void setRetryCount(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("RetryCount cannot be negative.");
        }
        this.retryCount = Configuration.getRetryCount(n);
    }

    public void setUserAgent(String string) {
        this.setRequestHeader("User-Agent", Configuration.getUserAgent(string));
    }

    public String getUserAgent() {
        return this.getRequestHeader("User-Agent");
    }

    public void setRetryIntervalSecs(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("RetryInterval cannot be negative.");
        }
        this.retryIntervalMillis = Configuration.getRetryIntervalSecs(n) * 1000;
    }

    public Response post(String string, PostParameter[] postParameterArray, boolean bl) throws WeiboException {
        PostParameter[] postParameterArray2 = Arrays.copyOf(postParameterArray, postParameterArray.length + 1);
        postParameterArray2[postParameterArray.length] = new PostParameter("source", "1935062235");
        return this.httpRequest(string, postParameterArray2, bl);
    }

    public Response delete(String string, boolean bl) throws WeiboException {
        return this.httpRequest(string, null, bl, "DELETE");
    }

    public Response multPartURL(String string, PostParameter[] postParameterArray, ImageItem imageItem, boolean bl) throws WeiboException {
        PostMethod postMethod = new PostMethod(string);
        try {
            Object object;
            org.apache.commons.httpclient.HttpClient httpClient = new org.apache.commons.httpclient.HttpClient();
            long l = System.currentTimeMillis();
            Part[] partArray = null;
            partArray = postParameterArray == null ? new Part[1] : new Part[postParameterArray.length + 1];
            if (postParameterArray != null) {
                int n = 0;
                for (PostParameter postParameter : postParameterArray) {
                    partArray[n++] = new StringPart(postParameter.getName(), postParameter.getValue());
                }
                partArray[partArray.length - 1] = new ByteArrayPart(imageItem.getContent(), imageItem.getName(), imageItem.getContentType());
            }
            postMethod.setRequestEntity(new MultipartRequestEntity(partArray, postMethod.getParams()));
            ArrayList<Header> arrayList = new ArrayList<Header>();
            if (bl) {
                if (this.basic != null || this.oauth == null) {
                    // empty if block
                }
                object = null;
                if (null != this.oauth) {
                    object = this.oauth.generateAuthorizationHeader("POST", string, postParameterArray, this.oauthToken);
                } else if (null != this.basic) {
                    object = this.basic;
                } else {
                    throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
                }
                arrayList.add(new Header("Authorization", (String)object));
                HttpClient.log("Authorization: " + (String)object);
            }
            httpClient.getHostConfiguration().getParams().setParameter("http.default-headers", arrayList);
            httpClient.executeMethod(postMethod);
            object = new Response();
            ((Response)object).setResponseAsString(postMethod.getResponseBodyAsString());
            ((Response)object).setStatusCode(postMethod.getStatusCode());
            HttpClient.log("multPartURL URL:" + string + ", result:" + object + ", time:" + (System.currentTimeMillis() - l));
            Object object2 = object;
            return object2;
        }
        catch (Exception exception) {
            throw new WeiboException(exception.getMessage(), exception, -1);
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    public Response multPartURL(String string, String string2, PostParameter[] postParameterArray, File file, boolean bl) throws WeiboException {
        PostMethod postMethod = new PostMethod(string2);
        org.apache.commons.httpclient.HttpClient httpClient = new org.apache.commons.httpclient.HttpClient();
        try {
            long l = System.currentTimeMillis();
            Part[] partArray = null;
            partArray = postParameterArray == null ? new Part[1] : new Part[postParameterArray.length + 1];
            if (postParameterArray != null) {
                int n = 0;
                for (PostParameter postParameter : postParameterArray) {
                    partArray[n++] = new StringPart(postParameter.getName(), postParameter.getValue());
                }
            }
            FilePart filePart = new FilePart(string, file.getName(), file, new MimetypesFileTypeMap().getContentType(file), "UTF-8");
            filePart.setTransferEncoding("binary");
            partArray[partArray.length - 1] = filePart;
            postMethod.setRequestEntity(new MultipartRequestEntity(partArray, postMethod.getParams()));
            ArrayList arrayList = new ArrayList();
            if (bl) {
                if (this.basic != null || this.oauth == null) {
                    // empty if block
                }
                String string3 = null;
                if (null != this.oauth) {
                    string3 = this.oauth.generateAuthorizationHeader("POST", string2, postParameterArray, this.oauthToken);
                } else if (null != this.basic) {
                    string3 = this.basic;
                } else {
                    throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
                }
                arrayList.add(new Header("Authorization", string3));
                HttpClient.log("Authorization: " + string3);
            }
            httpClient.getHostConfiguration().getParams().setParameter("http.default-headers", arrayList);
            httpClient.executeMethod(postMethod);
            Response response = new Response();
            response.setResponseAsString(postMethod.getResponseBodyAsString());
            response.setStatusCode(postMethod.getStatusCode());
            HttpClient.log("multPartURL URL:" + string2 + ", result:" + response + ", time:" + (System.currentTimeMillis() - l));
            Response response2 = response;
            return response2;
        }
        catch (Exception exception) {
            throw new WeiboException(exception.getMessage(), exception, -1);
        }
        finally {
            postMethod.releaseConnection();
            httpClient = null;
        }
    }

    public Response post(String string, boolean bl) throws WeiboException {
        return this.httpRequest(string, new PostParameter[0], bl);
    }

    public Response post(String string, PostParameter[] postParameterArray) throws WeiboException {
        return this.httpRequest(string, postParameterArray, false);
    }

    public Response post(String string) throws WeiboException {
        return this.httpRequest(string, new PostParameter[0], false);
    }

    public Response get(String string, boolean bl) throws WeiboException {
        return this.httpRequest(string, null, bl);
    }

    public Response get(String string) throws WeiboException {
        return this.httpRequest(string, null, false);
    }

    protected Response httpRequest(String string, PostParameter[] postParameterArray, boolean bl) throws WeiboException {
        int n = 1;
        PostParameter[] postParameterArray2 = postParameterArray;
        String string2 = "GET";
        if (postParameterArray != null) {
            string2 = "POST";
            n = postParameterArray.length + 1;
            postParameterArray2 = Arrays.copyOf(postParameterArray, n);
            postParameterArray2[postParameterArray.length] = new PostParameter("source", "1935062235");
        }
        return this.httpRequest(string, postParameterArray2, bl, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response httpRequest(String string, PostParameter[] postParameterArray, boolean bl, String string2) throws WeiboException {
        int n = this.retryCount + 1;
        Response response = null;
        for (int i = 0; i < n; ++i) {
            block25: {
                int n2 = -1;
                try {
                    HttpURLConnection httpURLConnection = null;
                    OutputStream outputStream = null;
                    try {
                        Object object;
                        Object object2;
                        httpURLConnection = this.getConnection(string);
                        httpURLConnection.setDoInput(true);
                        this.setHeaders(string, postParameterArray, httpURLConnection, bl, string2);
                        if (null != postParameterArray || "POST".equals(string2)) {
                            httpURLConnection.setRequestMethod("POST");
                            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            httpURLConnection.setDoOutput(true);
                            object2 = "";
                            if (postParameterArray != null) {
                                object2 = HttpClient.encodeParameters(postParameterArray);
                            }
                            HttpClient.log("Post Params: ", (String)object2);
                            object = ((String)object2).getBytes("UTF-8");
                            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(((byte[])object).length));
                            outputStream = httpURLConnection.getOutputStream();
                            outputStream.write((byte[])object);
                            outputStream.flush();
                            outputStream.close();
                        } else if ("DELETE".equals(string2)) {
                            httpURLConnection.setRequestMethod("DELETE");
                        } else {
                            httpURLConnection.setRequestMethod("GET");
                        }
                        response = new Response(httpURLConnection);
                        n2 = httpURLConnection.getResponseCode();
                        if (DEBUG) {
                            HttpClient.log("Response: ");
                            object2 = httpURLConnection.getHeaderFields();
                            object = object2.keySet().iterator();
                            while (object.hasNext()) {
                                String string3 = (String)object.next();
                                List list = (List)object2.get(string3);
                                for (String string4 : list) {
                                    if (null != string3) {
                                        HttpClient.log(string3 + ": " + string4);
                                        continue;
                                    }
                                    HttpClient.log(string4);
                                }
                            }
                        }
                        if (n2 == 200) break;
                        if (n2 < 500 || i == this.retryCount) {
                            throw new WeiboException(HttpClient.getCause(n2) + "\n" + response.asString(), n2);
                        }
                    }
                    finally {
                        try {
                            outputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException iOException) {
                    if (i != this.retryCount) break block25;
                    throw new WeiboException(iOException.getMessage(), iOException, n2);
                }
            }
            try {
                if (DEBUG && null != response) {
                    response.asString();
                }
                HttpClient.log("Sleeping " + this.retryIntervalMillis + " millisecs for next retry.");
                Thread.sleep(this.retryIntervalMillis);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return response;
    }

    public static String encodeParameters(PostParameter[] postParameterArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < postParameterArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append("&");
            }
            try {
                stringBuffer.append(URLEncoder.encode(postParameterArray[i].name, "UTF-8")).append("=").append(URLEncoder.encode(postParameterArray[i].value, "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    private void setHeaders(String string, PostParameter[] postParameterArray, HttpURLConnection httpURLConnection, boolean bl, String string2) {
        HttpClient.log("Request: ");
        HttpClient.log(string2 + " ", string);
        if (bl) {
            if (this.basic != null || this.oauth == null) {
                // empty if block
            }
            Object object = null;
            if (null != this.oauth) {
                object = this.oauth.generateAuthorizationHeader(string2, string, postParameterArray, this.oauthToken);
            } else if (null != this.basic) {
                object = this.basic;
            } else {
                throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
            }
            httpURLConnection.addRequestProperty("Authorization", (String)object);
            HttpClient.log("Authorization: " + (String)object);
        }
        for (String string3 : this.requestHeaders.keySet()) {
            httpURLConnection.addRequestProperty(string3, this.requestHeaders.get(string3));
            HttpClient.log(string3 + ": " + this.requestHeaders.get(string3));
        }
    }

    public void setRequestHeader(String string, String string2) {
        this.requestHeaders.put(string, string2);
    }

    public String getRequestHeader(String string) {
        return this.requestHeaders.get(string);
    }

    private HttpURLConnection getConnection(String string) throws IOException {
        HttpURLConnection httpURLConnection = null;
        if (this.proxyHost != null && !this.proxyHost.equals("")) {
            if (this.proxyAuthUser != null && !this.proxyAuthUser.equals("")) {
                HttpClient.log("Proxy AuthUser: " + this.proxyAuthUser);
                HttpClient.log("Proxy AuthPassword: " + this.proxyAuthPassword);
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                            return new PasswordAuthentication(HttpClient.this.proxyAuthUser, HttpClient.this.proxyAuthPassword.toCharArray());
                        }
                        return null;
                    }
                });
            }
            Proxy proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(this.proxyHost, this.proxyPort));
            if (DEBUG) {
                HttpClient.log("Opening proxied connection(" + this.proxyHost + ":" + this.proxyPort + ")");
            }
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection(proxy);
        } else {
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
        }
        if (this.connectionTimeout > 0 && !isJDK14orEarlier) {
            httpURLConnection.setConnectTimeout(this.connectionTimeout);
        }
        if (this.readTimeout > 0 && !isJDK14orEarlier) {
            httpURLConnection.setReadTimeout(this.readTimeout);
        }
        return httpURLConnection;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HttpClient)) {
            return false;
        }
        HttpClient httpClient = (HttpClient)object;
        if (this.connectionTimeout != httpClient.connectionTimeout) {
            return false;
        }
        if (this.proxyPort != httpClient.proxyPort) {
            return false;
        }
        if (this.readTimeout != httpClient.readTimeout) {
            return false;
        }
        if (this.retryCount != httpClient.retryCount) {
            return false;
        }
        if (this.retryIntervalMillis != httpClient.retryIntervalMillis) {
            return false;
        }
        if (this.accessTokenURL != null ? !this.accessTokenURL.equals(httpClient.accessTokenURL) : httpClient.accessTokenURL != null) {
            return false;
        }
        if (!this.authenticationURL.equals(httpClient.authenticationURL)) {
            return false;
        }
        if (!this.authorizationURL.equals(httpClient.authorizationURL)) {
            return false;
        }
        if (this.basic != null ? !this.basic.equals(httpClient.basic) : httpClient.basic != null) {
            return false;
        }
        if (this.oauth != null ? !this.oauth.equals(httpClient.oauth) : httpClient.oauth != null) {
            return false;
        }
        if (this.oauthToken != null ? !this.oauthToken.equals(httpClient.oauthToken) : httpClient.oauthToken != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(httpClient.password) : httpClient.password != null) {
            return false;
        }
        if (this.proxyAuthPassword != null ? !this.proxyAuthPassword.equals(httpClient.proxyAuthPassword) : httpClient.proxyAuthPassword != null) {
            return false;
        }
        if (this.proxyAuthUser != null ? !this.proxyAuthUser.equals(httpClient.proxyAuthUser) : httpClient.proxyAuthUser != null) {
            return false;
        }
        if (this.proxyHost != null ? !this.proxyHost.equals(httpClient.proxyHost) : httpClient.proxyHost != null) {
            return false;
        }
        if (!((Object)this.requestHeaders).equals(httpClient.requestHeaders)) {
            return false;
        }
        if (!this.requestTokenURL.equals(httpClient.requestTokenURL)) {
            return false;
        }
        return !(this.userId != null ? !this.userId.equals(httpClient.userId) : httpClient.userId != null);
    }

    public int hashCode() {
        int n = this.basic != null ? this.basic.hashCode() : 0;
        n = 31 * n + this.retryCount;
        n = 31 * n + this.retryIntervalMillis;
        n = 31 * n + (this.userId != null ? this.userId.hashCode() : 0);
        n = 31 * n + (this.password != null ? this.password.hashCode() : 0);
        n = 31 * n + (this.proxyHost != null ? this.proxyHost.hashCode() : 0);
        n = 31 * n + this.proxyPort;
        n = 31 * n + (this.proxyAuthUser != null ? this.proxyAuthUser.hashCode() : 0);
        n = 31 * n + (this.proxyAuthPassword != null ? this.proxyAuthPassword.hashCode() : 0);
        n = 31 * n + this.connectionTimeout;
        n = 31 * n + this.readTimeout;
        n = 31 * n + ((Object)this.requestHeaders).hashCode();
        n = 31 * n + (this.oauth != null ? this.oauth.hashCode() : 0);
        n = 31 * n + this.requestTokenURL.hashCode();
        n = 31 * n + this.authorizationURL.hashCode();
        n = 31 * n + this.authenticationURL.hashCode();
        n = 31 * n + (this.accessTokenURL != null ? this.accessTokenURL.hashCode() : 0);
        n = 31 * n + (this.oauthToken != null ? this.oauthToken.hashCode() : 0);
        return n;
    }

    private static void log(String string) {
        if (DEBUG) {
            System.out.println("[" + new Date() + "]" + string);
        }
    }

    private static void log(String string, String string2) {
        if (DEBUG) {
            HttpClient.log(string + string2);
        }
    }

    private static String getCause(int n) {
        String string = null;
        switch (n) {
            case 304: {
                break;
            }
            case 400: {
                string = "The request was invalid.  An accompanying error message will explain why. This is the status code will be returned during rate limiting.";
                break;
            }
            case 401: {
                string = "Authentication credentials were missing or incorrect.";
                break;
            }
            case 403: {
                string = "The request is understood, but it has been refused.  An accompanying error message will explain why.";
                break;
            }
            case 404: {
                string = "The URI requested is invalid or the resource requested, such as a user, does not exists.";
                break;
            }
            case 406: {
                string = "Returned by the Search API when an invalid format is specified in the request.";
                break;
            }
            case 500: {
                string = "Something is broken.  Please post to the group so the Weibo team can investigate.";
                break;
            }
            case 502: {
                string = "Weibo is down or being upgraded.";
                break;
            }
            case 503: {
                string = "Service Unavailable: The Weibo servers are up, but overloaded with requests. Try again later. The search and trend methods use this to indicate when you are being rate limited.";
                break;
            }
            default: {
                string = "";
            }
        }
        return n + ":" + string;
    }

    static {
        try {
            String string = System.getProperty("java.specification.version");
            if (null != string) {
                isJDK14orEarlier = 1.5 > Double.parseDouble(string);
            }
        }
        catch (AccessControlException accessControlException) {
            isJDK14orEarlier = true;
        }
    }

    private static class ByteArrayPart
    extends PartBase {
        private byte[] mData;
        private String mName;

        public ByteArrayPart(byte[] byArray, String string, String string2) throws IOException {
            super(string, string2, "UTF-8", "binary");
            this.mName = string;
            this.mData = byArray;
        }

        @Override
        protected void sendData(OutputStream outputStream) throws IOException {
            outputStream.write(this.mData);
        }

        @Override
        protected long lengthOfData() throws IOException {
            return this.mData.length;
        }

        @Override
        protected void sendDispositionHeader(OutputStream outputStream) throws IOException {
            super.sendDispositionHeader(outputStream);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("; filename=\"").append(this.mName).append("\"");
            outputStream.write(stringBuilder.toString().getBytes());
        }
    }
}

