/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.http;

import com.sun.imageio.plugins.bmp.BMPImageReader;
import com.sun.imageio.plugins.gif.GIFImageReader;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import com.sun.imageio.plugins.png.PNGImageReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class ImageItem {
    private byte[] content;
    private String name;
    private String contentType;

    public ImageItem(String string, byte[] byArray) throws Exception {
        String string2 = ImageItem.getContentType(byArray);
        if (string2 == null || !string2.equalsIgnoreCase("image/gif") && !string2.equalsIgnoreCase("image/png") && !string2.equalsIgnoreCase("image/jpeg")) {
            throw new IllegalStateException("Unsupported image type, Only Suport JPG ,GIF,PNG!");
        }
        this.content = byArray;
        this.name = string;
        this.content = byArray;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentType(byte[] byArray) throws IOException {
        String string = "";
        ByteArrayInputStream byteArrayInputStream = null;
        MemoryCacheImageInputStream memoryCacheImageInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            memoryCacheImageInputStream = new MemoryCacheImageInputStream(byteArrayInputStream);
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(memoryCacheImageInputStream);
            while (iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                if (imageReader instanceof GIFImageReader) {
                    string = "image/gif";
                    continue;
                }
                if (imageReader instanceof JPEGImageReader) {
                    string = "image/jpeg";
                    continue;
                }
                if (imageReader instanceof PNGImageReader) {
                    string = "image/png";
                    continue;
                }
                if (!(imageReader instanceof BMPImageReader)) continue;
                string = "application/x-bmp";
            }
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (memoryCacheImageInputStream != null) {
                try {
                    memoryCacheImageInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }
}

