/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.http;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import weibo4j.Configuration;
import weibo4j.http.BASE64Encoder;
import weibo4j.http.OAuthToken;
import weibo4j.http.PostParameter;

public class OAuth
implements Serializable {
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final PostParameter OAUTH_SIGNATURE_METHOD = new PostParameter("oauth_signature_method", "HMAC-SHA1");
    private static final boolean DEBUG = Configuration.getDebug();
    static final long serialVersionUID = -4368426677157998618L;
    private String consumerKey = "";
    private String consumerSecret;
    private static Random RAND = new Random();

    public OAuth(String string, String string2) {
        this.setConsumerKey(string);
        this.setConsumerSecret(string2);
    }

    String generateAuthorizationHeader(String string, String string2, PostParameter[] postParameterArray, String string3, String string4, OAuthToken oAuthToken) {
        if (null == postParameterArray) {
            postParameterArray = new PostParameter[]{};
        }
        ArrayList<PostParameter> arrayList = new ArrayList<PostParameter>(5);
        arrayList.add(new PostParameter("oauth_consumer_key", this.consumerKey));
        arrayList.add(OAUTH_SIGNATURE_METHOD);
        arrayList.add(new PostParameter("oauth_timestamp", string4));
        arrayList.add(new PostParameter("oauth_nonce", string3));
        arrayList.add(new PostParameter("oauth_version", "1.0"));
        if (null != oAuthToken) {
            arrayList.add(new PostParameter("oauth_token", oAuthToken.getToken()));
        }
        ArrayList<PostParameter> arrayList2 = new ArrayList<PostParameter>(arrayList.size() + postParameterArray.length);
        arrayList2.addAll(arrayList);
        arrayList2.addAll(OAuth.toParamList(postParameterArray));
        this.parseGetParameters(string2, arrayList2);
        StringBuffer stringBuffer = new StringBuffer(string).append("&").append(OAuth.encode(OAuth.constructRequestURL(string2))).append("&");
        stringBuffer.append(OAuth.encode(OAuth.normalizeRequestParameters(arrayList2)));
        String string5 = stringBuffer.toString();
        this.log("OAuth base string:", string5);
        String string6 = this.generateSignature(string5, oAuthToken);
        this.log("OAuth signature:", string6);
        arrayList.add(new PostParameter("oauth_signature", string6));
        return "OAuth " + OAuth.encodeParameters(arrayList, ",", true);
    }

    private void parseGetParameters(String string, List<PostParameter> list) {
        int n = string.indexOf("?");
        if (-1 != n) {
            String[] stringArray = string.substring(n + 1).split("&");
            try {
                for (String string2 : stringArray) {
                    String[] stringArray2 = string2.split("=");
                    if (stringArray2.length == 2) {
                        list.add(new PostParameter(URLDecoder.decode(stringArray2[0], "UTF-8"), URLDecoder.decode(stringArray2[1], "UTF-8")));
                        continue;
                    }
                    list.add(new PostParameter(URLDecoder.decode(stringArray2[0], "UTF-8"), ""));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    String generateAuthorizationHeader(String string, String string2, PostParameter[] postParameterArray, OAuthToken oAuthToken) {
        long l = System.currentTimeMillis() / 1000L;
        long l2 = l + (long)RAND.nextInt();
        return this.generateAuthorizationHeader(string, string2, postParameterArray, String.valueOf(l2), String.valueOf(l), oAuthToken);
    }

    String generateSignature(String string, OAuthToken oAuthToken) {
        byte[] byArray = null;
        try {
            SecretKeySpec secretKeySpec;
            Mac mac = Mac.getInstance(HMAC_SHA1);
            if (null == oAuthToken) {
                String string2 = OAuth.encode(this.consumerSecret) + "&";
                secretKeySpec = new SecretKeySpec(string2.getBytes(), HMAC_SHA1);
            } else {
                if (null == oAuthToken.getSecretKeySpec()) {
                    String string3 = OAuth.encode(this.consumerSecret) + "&" + OAuth.encode(oAuthToken.getTokenSecret());
                    secretKeySpec = new SecretKeySpec(string3.getBytes(), HMAC_SHA1);
                    oAuthToken.setSecretKeySpec(secretKeySpec);
                }
                secretKeySpec = oAuthToken.getSecretKeySpec();
            }
            mac.init(secretKeySpec);
            byArray = mac.doFinal(string.getBytes());
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return new BASE64Encoder().encode(byArray);
    }

    String generateSignature(String string) {
        return this.generateSignature(string, null);
    }

    public static String normalizeRequestParameters(PostParameter[] postParameterArray) {
        return OAuth.normalizeRequestParameters(OAuth.toParamList(postParameterArray));
    }

    public static String normalizeRequestParameters(List<PostParameter> list) {
        Collections.sort(list);
        return OAuth.encodeParameters(list);
    }

    public static String normalizeAuthorizationHeaders(List<PostParameter> list) {
        Collections.sort(list);
        return OAuth.encodeParameters(list);
    }

    public static List<PostParameter> toParamList(PostParameter[] postParameterArray) {
        ArrayList<PostParameter> arrayList = new ArrayList<PostParameter>(postParameterArray.length);
        arrayList.addAll(Arrays.asList(postParameterArray));
        return arrayList;
    }

    public static String encodeParameters(List<PostParameter> list) {
        return OAuth.encodeParameters(list, "&", false);
    }

    public static String encodeParameters(List<PostParameter> list, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (PostParameter postParameter : list) {
            if (stringBuffer.length() != 0) {
                if (bl) {
                    stringBuffer.append("\"");
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(OAuth.encode(postParameter.name)).append("=");
            if (bl) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(OAuth.encode(postParameter.value));
        }
        if (stringBuffer.length() != 0 && bl) {
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public static String encode(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '*') {
                stringBuffer.append("%2A");
                continue;
            }
            if (c == '+') {
                stringBuffer.append("%20");
                continue;
            }
            if (c == '%' && i + 1 < string2.length() && string2.charAt(i + 1) == '7' && string2.charAt(i + 2) == 'E') {
                stringBuffer.append('~');
                i += 2;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String constructRequestURL(String string) {
        int n;
        String string2;
        int n2;
        int n3 = string.indexOf("?");
        if (-1 != n3) {
            string = string.substring(0, n3);
        }
        if (-1 != (n2 = (string2 = string.substring(0, n = string.indexOf("/", 8)).toLowerCase()).indexOf(":", 8))) {
            if (string2.startsWith("http://") && string2.endsWith(":80")) {
                string2 = string2.substring(0, n2);
            } else if (string2.startsWith("https://") && string2.endsWith(":443")) {
                string2 = string2.substring(0, n2);
            }
        }
        string = string2 + string.substring(n);
        return string;
    }

    public void setConsumerKey(String string) {
        this.consumerKey = null != string ? string : "";
    }

    public void setConsumerSecret(String string) {
        this.consumerSecret = null != string ? string : "";
    }

    private void log(String string) {
        if (DEBUG) {
            System.out.println("[" + new Date() + "]" + string);
        }
    }

    private void log(String string, String string2) {
        if (DEBUG) {
            this.log(string + string2);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OAuth)) {
            return false;
        }
        OAuth oAuth = (OAuth)object;
        if (this.consumerKey != null ? !this.consumerKey.equals(oAuth.consumerKey) : oAuth.consumerKey != null) {
            return false;
        }
        return !(this.consumerSecret != null ? !this.consumerSecret.equals(oAuth.consumerSecret) : oAuth.consumerSecret != null);
    }

    public int hashCode() {
        int n = this.consumerKey != null ? this.consumerKey.hashCode() : 0;
        n = 31 * n + (this.consumerSecret != null ? this.consumerSecret.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "OAuth{consumerKey='" + this.consumerKey + '\'' + ", consumerSecret='" + this.consumerSecret + '\'' + '}';
    }
}

