/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.http;

import java.io.Serializable;
import javax.crypto.spec.SecretKeySpec;
import weibo4j.WeiboException;
import weibo4j.http.Response;

abstract class OAuthToken
implements Serializable {
    private String token;
    private String tokenSecret;
    private transient SecretKeySpec secretKeySpec;
    String[] responseStr = null;

    public OAuthToken(String string, String string2) {
        this.token = string;
        this.tokenSecret = string2;
    }

    OAuthToken(Response response) throws WeiboException {
        this(response.asString());
    }

    OAuthToken(String string) {
        this.responseStr = string.split("&");
        this.tokenSecret = this.getParameter("oauth_token_secret");
        this.token = this.getParameter("oauth_token");
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    void setSecretKeySpec(SecretKeySpec secretKeySpec) {
        this.secretKeySpec = secretKeySpec;
    }

    SecretKeySpec getSecretKeySpec() {
        return this.secretKeySpec;
    }

    public String getParameter(String string) {
        String string2 = null;
        for (String string3 : this.responseStr) {
            if (!string3.startsWith(string + '=')) continue;
            string2 = string3.split("=")[1].trim();
            break;
        }
        return string2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OAuthToken)) {
            return false;
        }
        OAuthToken oAuthToken = (OAuthToken)object;
        if (this.secretKeySpec != null ? !this.secretKeySpec.equals(oAuthToken.secretKeySpec) : oAuthToken.secretKeySpec != null) {
            return false;
        }
        if (!this.token.equals(oAuthToken.token)) {
            return false;
        }
        return this.tokenSecret.equals(oAuthToken.tokenSecret);
    }

    public int hashCode() {
        int n = this.token.hashCode();
        n = 31 * n + this.tokenSecret.hashCode();
        n = 31 * n + (this.secretKeySpec != null ? this.secretKeySpec.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "OAuthToken{token='" + this.token + '\'' + ", tokenSecret='" + this.tokenSecret + '\'' + ", secretKeySpec=" + this.secretKeySpec + '}';
    }
}

