/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.http;

import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

public class PostParameter
implements Serializable,
Comparable {
    String name;
    String value;
    private File file = null;
    private static final long serialVersionUID = -8708108746980739212L;
    private static final String JPEG = "image/jpeg";
    private static final String GIF = "image/gif";
    private static final String PNG = "image/png";
    private static final String OCTET = "application/octet-stream";

    public PostParameter(String string, String string2) {
        this.name = string;
        this.value = string2;
    }

    public PostParameter(String string, double d) {
        this.name = string;
        this.value = String.valueOf(d);
    }

    public PostParameter(String string, int n) {
        this.name = string;
        this.value = String.valueOf(n);
    }

    public PostParameter(String string, File file) {
        this.name = string;
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isFile() {
        return null != this.file;
    }

    public String getContentType() {
        if (!this.isFile()) {
            throw new IllegalStateException("not a file");
        }
        String string = this.file.getName();
        int n = string.lastIndexOf(".");
        String string2 = -1 == n ? OCTET : ((string = string.substring(string.lastIndexOf(".") + 1).toLowerCase()).length() == 3 ? ("gif".equals(string) ? GIF : ("png".equals(string) ? PNG : ("jpg".equals(string) ? JPEG : OCTET))) : (string.length() == 4 ? ("jpeg".equals(string) ? JPEG : OCTET) : OCTET));
        return string2;
    }

    public static boolean containsFile(PostParameter[] postParameterArray) {
        boolean bl = false;
        if (null == postParameterArray) {
            return false;
        }
        for (PostParameter postParameter : postParameterArray) {
            if (!postParameter.isFile()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static boolean containsFile(List<PostParameter> list) {
        boolean bl = false;
        for (PostParameter postParameter : list) {
            if (!postParameter.isFile()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static PostParameter[] getParameterArray(String string, String string2) {
        return new PostParameter[]{new PostParameter(string, string2)};
    }

    public static PostParameter[] getParameterArray(String string, int n) {
        return PostParameter.getParameterArray(string, String.valueOf(n));
    }

    public static PostParameter[] getParameterArray(String string, String string2, String string3, String string4) {
        return new PostParameter[]{new PostParameter(string, string2), new PostParameter(string3, string4)};
    }

    public static PostParameter[] getParameterArray(String string, int n, String string2, int n2) {
        return PostParameter.getParameterArray(string, String.valueOf(n), string2, String.valueOf(n2));
    }

    public int hashCode() {
        int n = this.name.hashCode();
        n = 31 * n + this.value.hashCode();
        n = 31 * n + (this.file != null ? this.file.hashCode() : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof PostParameter) {
            PostParameter postParameter = (PostParameter)object;
            if (this.file != null ? !this.file.equals(postParameter.file) : postParameter.file != null) {
                return false;
            }
            return this.name.equals(postParameter.name) && this.value.equals(postParameter.value);
        }
        return false;
    }

    public String toString() {
        return "PostParameter{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", file=" + this.file + '}';
    }

    public int compareTo(Object object) {
        PostParameter postParameter = (PostParameter)object;
        int n = this.name.compareTo(postParameter.name);
        if (0 == n) {
            n = this.value.compareTo(postParameter.value);
        }
        return n;
    }

    public static String encodeParameters(PostParameter[] postParameterArray) {
        if (null == postParameterArray) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < postParameterArray.length; ++i) {
            if (postParameterArray[i].isFile()) {
                throw new IllegalArgumentException("parameter [" + postParameterArray[i].name + "]should be text");
            }
            if (i != 0) {
                stringBuffer.append("&");
            }
            try {
                stringBuffer.append(URLEncoder.encode(postParameterArray[i].name, "UTF-8")).append("=").append(URLEncoder.encode(postParameterArray[i].value, "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }
}

