/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import weibo4j.Configuration;
import weibo4j.WeiboException;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Response {
    private static final boolean DEBUG = Configuration.getDebug();
    private static ThreadLocal<DocumentBuilder> builders = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new ExceptionInInitializerError(parserConfigurationException);
            }
        }
    };
    private int statusCode;
    private Document responseAsDocument = null;
    private String responseAsString = null;
    private InputStream is;
    private HttpURLConnection con;
    private boolean streamConsumed = false;
    private static Pattern escaped = Pattern.compile("&#([0-9]{3,5});");

    public Response() {
    }

    public Response(HttpURLConnection httpURLConnection) throws IOException {
        this.con = httpURLConnection;
        this.statusCode = httpURLConnection.getResponseCode();
        this.is = httpURLConnection.getErrorStream();
        if (null == this.is) {
            this.is = httpURLConnection.getInputStream();
        }
        if (null != this.is && "gzip".equals(httpURLConnection.getContentEncoding())) {
            this.is = new GZIPInputStream(this.is);
        }
    }

    Response(String string) {
        this.responseAsString = string;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseHeader(String string) {
        if (this.con != null) {
            return this.con.getHeaderField(string);
        }
        return null;
    }

    public InputStream asStream() {
        if (this.streamConsumed) {
            throw new IllegalStateException("Stream has already been consumed.");
        }
        return this.is;
    }

    public String asString() throws WeiboException {
        if (null == this.responseAsString) {
            try {
                String string;
                InputStream inputStream = this.asStream();
                if (null == inputStream) {
                    return null;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer stringBuffer = new StringBuffer();
                while (null != (string = bufferedReader.readLine())) {
                    stringBuffer.append(string).append("\n");
                }
                this.responseAsString = stringBuffer.toString();
                if (Configuration.isDalvik()) {
                    this.responseAsString = Response.unescape(this.responseAsString);
                }
                this.log(this.responseAsString);
                inputStream.close();
                this.con.disconnect();
                this.streamConsumed = true;
            }
            catch (NullPointerException nullPointerException) {
                throw new WeiboException(nullPointerException.getMessage(), nullPointerException);
            }
            catch (IOException iOException) {
                throw new WeiboException(iOException.getMessage(), iOException);
            }
        }
        return this.responseAsString;
    }

    public Document asDocument() throws WeiboException {
        if (null == this.responseAsDocument) {
            try {
                this.responseAsDocument = builders.get().parse(new ByteArrayInputStream(this.asString().getBytes("UTF-8")));
            }
            catch (SAXException sAXException) {
                throw new WeiboException("The response body was not well-formed:\n" + this.responseAsString, sAXException);
            }
            catch (IOException iOException) {
                throw new WeiboException("There's something with the connection.", iOException);
            }
        }
        return this.responseAsDocument;
    }

    public JSONObject asJSONObject() throws WeiboException {
        try {
            return new JSONObject(this.asString());
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException.getMessage() + ":" + this.responseAsString, jSONException);
        }
    }

    public JSONArray asJSONArray() throws WeiboException {
        try {
            return new JSONArray(this.asString());
        }
        catch (Exception exception) {
            throw new WeiboException(exception.getMessage() + ":" + this.responseAsString, exception);
        }
    }

    public InputStreamReader asReader() {
        try {
            return new InputStreamReader(this.is, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new InputStreamReader(this.is);
        }
    }

    public void disconnect() {
        this.con.disconnect();
    }

    public static String unescape(String string) {
        Matcher matcher = escaped.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, Character.toString((char)Integer.parseInt(matcher.group(1), 10)));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public String toString() {
        if (null != this.responseAsString) {
            return this.responseAsString;
        }
        return "Response{statusCode=" + this.statusCode + ", response=" + this.responseAsDocument + ", responseString='" + this.responseAsString + '\'' + ", is=" + this.is + ", con=" + this.con + '}';
    }

    private void log(String string) {
        if (DEBUG) {
            System.out.println("[" + new Date() + "]" + string);
        }
    }

    private void log(String string, String string2) {
        if (DEBUG) {
            this.log(string + string2);
        }
    }

    public String getResponseAsString() {
        return this.responseAsString;
    }

    public void setResponseAsString(String string) {
        this.responseAsString = string;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }
}

