/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import junit.extensions.TestDecorator;
import junit.framework.AssertionFailedError;
import junit.framework.JUnit4TestAdapter;
import junit.framework.JUnit4TestCaseFacade;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OldTestClassRunner
extends Runner {
    private Test fTest;

    public OldTestClassRunner(Class<?> klass) {
        this(new TestSuite((Class<? extends TestCase>)klass));
    }

    public OldTestClassRunner(Test test2) {
        this.fTest = test2;
    }

    @Override
    public void run(RunNotifier notifier) {
        TestResult result = new TestResult();
        result.addListener(this.getListener(notifier));
        this.fTest.run(result);
    }

    private TestListener getListener(final RunNotifier notifier) {
        return new TestListener(){

            public void endTest(Test test2) {
                notifier.fireTestFinished(this.asDescription(test2));
            }

            public void startTest(Test test2) {
                notifier.fireTestStarted(this.asDescription(test2));
            }

            public void addError(Test test2, Throwable t) {
                Failure failure = new Failure(this.asDescription(test2), t);
                notifier.fireTestFailure(failure);
            }

            private Description asDescription(Test test2) {
                if (test2 instanceof JUnit4TestCaseFacade) {
                    JUnit4TestCaseFacade facade = (JUnit4TestCaseFacade)test2;
                    return facade.getDescription();
                }
                return Description.createTestDescription(test2.getClass(), this.getName(test2));
            }

            private String getName(Test test2) {
                if (test2 instanceof TestCase) {
                    return ((TestCase)test2).getName();
                }
                return test2.toString();
            }

            public void addFailure(Test test2, AssertionFailedError t) {
                this.addError(test2, (Throwable)((Object)t));
            }
        };
    }

    @Override
    public Description getDescription() {
        return this.makeDescription(this.fTest);
    }

    private Description makeDescription(Test test2) {
        if (test2 instanceof TestCase) {
            TestCase tc = (TestCase)test2;
            return Description.createTestDescription(tc.getClass(), tc.getName());
        }
        if (test2 instanceof TestSuite) {
            TestSuite ts = (TestSuite)test2;
            Description description = Description.createSuiteDescription(ts.getName());
            int n = ts.testCount();
            for (int i = 0; i < n; ++i) {
                description.addChild(this.makeDescription(ts.testAt(i)));
            }
            return description;
        }
        if (test2 instanceof JUnit4TestAdapter) {
            JUnit4TestAdapter adapter = (JUnit4TestAdapter)test2;
            return adapter.getDescription();
        }
        if (test2 instanceof TestDecorator) {
            TestDecorator decorator = (TestDecorator)test2;
            return this.makeDescription(decorator.getTest());
        }
        return Description.createSuiteDescription(test2.getClass());
    }
}

