/*
 * Decompiled with CFR 0.152.
 */
package spreader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import spreader.authentication.AuthentacationService;
import spreader.service.base.AbstractWeiboService;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.http.AccessToken;

public class Account {
    private static Map<String, AccessToken> accessTokens;
    private static List<Account> accounts;
    public static String erroUser;
    private String username;
    private int friendCount;
    private int followerCount;
    private AccessToken token;

    public static Map<String, AccessToken> getAccessTokens() {
        return accessTokens;
    }

    public static List<Account> getAccounts() {
        return accounts;
    }

    public Account(String string, int n, int n2, AccessToken accessToken) {
        this.username = string;
        this.friendCount = n;
        this.followerCount = n2;
        this.token = accessToken;
    }

    public static void loadAccessTokens(String string) {
        Row row;
        accessTokens = new LinkedHashMap<String, AccessToken>();
        accounts = new ArrayList<Account>();
        FileInputStream fileInputStream = null;
        String string2 = string;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create(fileInputStream);
        }
        catch (InvalidFormatException invalidFormatException) {
            invalidFormatException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Sheet sheet = workbook.getSheetAt(0);
        int n = sheet.getFirstRowNum();
        int n2 = sheet.getLastRowNum();
        boolean bl = false;
        for (int i = n + 1; i <= n2 && (row = sheet.getRow(i)) != null; ++i) {
            AccessToken accessToken;
            short s = row.getFirstCellNum();
            String string3 = row.getCell(s, Row.CREATE_NULL_AS_BLANK).getStringCellValue();
            String string4 = row.getCell(s + 1, Row.CREATE_NULL_AS_BLANK).getStringCellValue();
            String string5 = row.getCell(s + 2, Row.CREATE_NULL_AS_BLANK).getStringCellValue();
            String string6 = row.getCell(s + 3, Row.CREATE_NULL_AS_BLANK).getStringCellValue();
            if (string3.trim().equals("")) break;
            if (null != string5 && string5.trim().length() > 0) {
                accessToken = new AccessToken(string5, string6);
                accessTokens.put(string3, accessToken);
                accounts.add(Account.retrieveAccount(string3, accessToken));
            } else {
                accessToken = AuthentacationService.retrieveAccessToken(string3, string4);
                if (null != accessToken) {
                    bl = true;
                    accessTokens.put(string3, accessToken);
                    row.getCell(s + 2).setCellValue(accessToken.getToken());
                    row.getCell(s + 3).setCellValue(accessToken.getTokenSecret());
                    accounts.add(Account.retrieveAccount(string3, accessToken));
                }
            }
            if (!bl) continue;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                workbook.write(fileOutputStream);
                fileOutputStream.close();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static Account retrieveAccount(String string, AccessToken accessToken) {
        Weibo weibo = AbstractWeiboService.getWeibo(true, accessToken);
        int n = 0;
        int n2 = 0;
        try {
            String string2 = String.valueOf(weibo.verifyCredentials().getId());
            n = weibo.showUser(string2).getFriendsCount();
            n2 = weibo.showUser(string2).getFollowersCount();
        }
        catch (WeiboException weiboException) {
            weiboException.printStackTrace();
        }
        return new Account(string, n, n2, accessToken);
    }

    private void updateAccount() {
        Weibo weibo = AbstractWeiboService.getWeibo(true, this.token);
        try {
            String string = String.valueOf(weibo.verifyCredentials().getId());
            this.friendCount = weibo.showUser(string).getFriendsCount();
            this.followerCount = weibo.showUser(string).getFollowersCount();
        }
        catch (WeiboException weiboException) {
            weiboException.printStackTrace();
        }
    }

    public static List<Account> updateAccountFriendFollowerCount() {
        for (Account account : accounts) {
            account.updateAccount();
        }
        return accounts;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public int getFollowerCount() {
        return this.followerCount;
    }

    public void setFollowerCount(int n) {
        this.followerCount = n;
    }

    public int getFriendCount() {
        return this.friendCount;
    }

    public void setFriendCount(int n) {
        this.friendCount = n;
    }

    static {
        erroUser = "";
    }
}

