/*
 * Decompiled with CFR 0.152.
 */
package spreader;

import java.awt.AWTException;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import spreader.Account;
import spreader.WeiboUtils;
import spreader.db.DBMethod;
import spreader.service.ProxyService;
import spreader.ui.AboutDialog;
import spreader.ui.AutomationPanel;
import spreader.ui.ConfigPane;
import spreader.ui.MySelfJudgePanel;
import spreader.ui.MySelfRepostPanel;
import spreader.ui.ProxyPanel;
import spreader.ui.SendJudgePanel;
import spreader.ui.SendMailPanel;
import spreader.ui.SendMentionPanel;
import spreader.ui.StatusPanel;
import spreader.ui.TJFriendPanel;
import spreader.ui.UIListener;

public class Spreader
extends JFrame {
    private static final long serialVersionUID = -2552902048551828449L;
    public static String loginUser = "";

    private void confirm() {
        int n = JOptionPane.showConfirmDialog(this, "Exit System?", "Confirmation", 0);
        if (n == 0) {
            System.exit(2);
        }
    }

    private void showAboutDialog() {
        new AboutDialog(this, "1.0").setVisible(true);
    }

    private void createIcon() {
        URL uRL = Spreader.class.getResource("/icon.png");
        Image image = this.getToolkit().getImage(uRL.getFile());
        this.setIconImage(image);
    }

    private void createMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Spreader.this.confirm();
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Help");
        JMenuItem jMenuItem2 = new JMenuItem("About Spreader");
        jMenu2.add(jMenuItem2);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Spreader.this.showAboutDialog();
            }
        });
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
    }

    private void systemTray() {
        TrayIcon trayIcon = null;
        Container container = this.getContentPane();
        container.setLayout(new FlowLayout());
        SystemTray systemTray = SystemTray.getSystemTray();
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        try {
            String string = "/icon.png";
            Image image = this.getToolkit().getImage(this.getClass().getResource(string));
            PopupMenu popupMenu = new PopupMenu();
            MenuItem menuItem = new MenuItem("\u6253\u5f00");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Spreader.this.setExtendedState(0);
                    Spreader.this.setVisible(true);
                }
            });
            popupMenu.add(menuItem);
            MenuItem menuItem2 = new MenuItem("\u9000\u51fa");
            menuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
            popupMenu.add(menuItem2);
            trayIcon = new TrayIcon(image, "\u65b0\u6d6a\u5fae\u535a\u5173\u6ce8", popupMenu);
            systemTray.add(trayIcon);
            this.dispose();
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                Spreader.this.dispose();
            }
        });
        trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    Spreader.this.setExtendedState(0);
                    Spreader.this.setVisible(true);
                }
            }
        });
    }

    public Spreader() {
        super("\u6f14\u793a\u7248- \u65b0\u6d6a\u5fae\u535a\u8425\u9500\u7aef V1.0 20110626");
        if (!Account.erroUser.equals("")) {
            JOptionPane.showMessageDialog(this, Account.erroUser);
            JOptionPane.showMessageDialog(this, "\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u8fd0\u884c");
            return;
        }
        Dimension dimension = new Dimension(800, 600);
        this.setPreferredSize(dimension);
        this.setDefaultCloseOperation(3);
        this.createIcon();
        this.createMenu();
        this.systemTray();
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.setContentPane(jTabbedPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 20, 30));
        jPanel.add(new AutomationPanel());
        jTabbedPane.addTab("\u9996\u9875", jPanel);
        jTabbedPane.setEnabledAt(0, true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 20, 30));
        jPanel2.add(new StatusPanel());
        jTabbedPane.add("\u53d1\u9001\u5fae\u535a", jPanel2);
        jTabbedPane.setEnabledAt(1, true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 20, 30));
        jPanel3.add(new SendJudgePanel(this));
        jTabbedPane.addTab("\u53d1\u9001\u8bc4\u8bba", jPanel3);
        jTabbedPane.setEnabledAt(2, true);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 20, 30));
        jPanel4.add(new SendMailPanel(this));
        jTabbedPane.addTab("\u53d1\u9001\u79c1\u4fe1", jPanel4);
        jTabbedPane.setEnabledAt(3, true);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0, 20, 30));
        jPanel5.add(new SendMentionPanel(this));
        jTabbedPane.addTab("\u53d1\u9001\u5e26@\u5fae\u535a", jPanel5);
        jTabbedPane.setEnabledAt(4, true);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0, 20, 30));
        jPanel6.add(new ConfigPane());
        jTabbedPane.addTab("\u914d\u7f6e", jPanel6);
        jTabbedPane.setEnabledAt(5, true);
        jTabbedPane.addTab("\u7c89\u4e1d\u7edf\u8ba1", new TJFriendPanel());
        jTabbedPane.setEnabledAt(6, true);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0, 20, 30));
        jPanel7.add(new ProxyPanel(this));
        jTabbedPane.addTab("\u4ee3\u7406\u5730\u5740", jPanel7);
        jTabbedPane.setEnabledAt(7, true);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(0, 20, 30));
        jPanel8.add(new MySelfJudgePanel(this));
        jTabbedPane.addTab("\u8bc4\u8bba\u6211\u7684\u5e10\u6237", jPanel8);
        jTabbedPane.setEnabledAt(8, true);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout(0, 20, 30));
        jPanel9.add(new MySelfRepostPanel(this));
        jTabbedPane.addTab("\u8f6c\u53d1\u6211\u7684\u5e10\u6237", jPanel9);
        jTabbedPane.setEnabledAt(9, true);
        jTabbedPane.setTabPlacement(1);
        jTabbedPane.setTabLayoutPolicy(1);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.setLocationRelativeTo(null);
    }

    private static void createAndShowGUI() {
        new Spreader();
    }

    private static void LoginGUI() {
        final JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setTitle("\u767b\u9646");
        jFrame.setSize(350, 160);
        Container container = jFrame.getContentPane();
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("     \u7528\u6237\u540d");
        jLabel.setVerticalAlignment(1);
        jLabel.setHorizontalAlignment(2);
        final JTextField jTextField = new JTextField(20);
        jLabel.setHorizontalAlignment(4);
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        JLabel jLabel2 = new JLabel("     \u5bc6    \u7801");
        jLabel2.setVerticalAlignment(0);
        jLabel2.setHorizontalAlignment(2);
        final JPasswordField jPasswordField = new JPasswordField(20);
        jLabel2.setHorizontalAlignment(0);
        jLabel2.setHorizontalAlignment(4);
        jPanel.add(jLabel2);
        jPanel.add(jPasswordField);
        JButton jButton = new JButton("\u767b\u9646");
        JButton jButton2 = new JButton("\u53d6\u6d88");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                char[] cArray;
                String string;
                String string2 = jTextField.getText().trim();
                if (DBMethod.isLogin(string2, string = new String(cArray = jPasswordField.getPassword()))) {
                    loginUser = string2;
                    jFrame.dispose();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Spreader.createAndShowGUI();
                        }
                    });
                } else {
                    JOptionPane.showMessageDialog(jFrame, "\u767b\u9646\u5931\u8d25,\u8bf7\u786e\u8ba4\u5e10\u6237\u548c\u5bc6\u7801\u662f\u5426\u6b63\u786e\uff01");
                    jPasswordField.setText("");
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        container.add(jPanel);
        jFrame.setVisible(true);
        jFrame.setLocationRelativeTo(null);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 5) {
            System.out.println("file not found!");
            System.exit(0);
        }
        UIListener.setFilePath(stringArray[0]);
        UIListener.setMessageFilePath(stringArray[1]);
        UIListener.setImageFolder(stringArray[2]);
        UIListener.setConfigFilePath(stringArray[3]);
        UIListener.setGzConfigFilePath(stringArray[4]);
        ProxyService.removeProxy();
        WeiboUtils.setSystemVariables();
        Account.loadAccessTokens(stringArray[0]);
        Spreader.createAndShowGUI();
    }
}

