/*
 * Decompiled with CFR 0.152.
 */
package spreader.research;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import spreader.research.CheckRenderer;

public class CheckList
extends JFrame {
    public CheckList() {
        super("CheckList Example");
        String[] stringArray = new String[]{"\u4e0a\u6d77", "\u5357\u4eac", "\u5317\u4eac", "\u6df1\u5733", "JList", "JList", "JList", "JList", "JList", "JList", "JList"};
        final JList<CheckableItem> jList = new JList<CheckableItem>(this.createData(stringArray));
        jList.setCellRenderer(new CheckListRenderer());
        jList.setSelectionMode(0);
        jList.setBorder(new EmptyBorder(0, 4, 0, 0));
        jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                CheckableItem checkableItem;
                int n = jList.locationToIndex(mouseEvent.getPoint());
                checkableItem.setSelected(!(checkableItem = (CheckableItem)jList.getModel().getElementAt(n)).isSelected());
                Rectangle rectangle = jList.getCellBounds(n, n);
                jList.repaint(rectangle);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jList);
        final JTextArea jTextArea = new JTextArea(3, 10);
        JScrollPane jScrollPane2 = new JScrollPane(jTextArea);
        JButton jButton = new JButton("print");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListModel listModel = jList.getModel();
                int n = listModel.getSize();
                for (int i = 0; i < n; ++i) {
                    CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
                    if (!checkableItem.isSelected()) continue;
                    jTextArea.append(checkableItem.toString());
                    jTextArea.append(System.getProperty("line.separator"));
                }
            }
        });
        JButton jButton2 = new JButton("clear");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextArea.setText("");
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "East");
        this.getContentPane().add((Component)jScrollPane2, "South");
    }

    private CheckableItem[] createData(String[] stringArray) {
        int n = stringArray.length;
        CheckableItem[] checkableItemArray = new CheckableItem[n];
        for (int i = 0; i < n; ++i) {
            checkableItemArray[i] = new CheckableItem(stringArray[i]);
        }
        return checkableItemArray;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        CheckList checkList = new CheckList();
        checkList.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        checkList.setSize(300, 200);
        checkList.setVisible(true);
    }

    class CheckListRenderer
    extends CheckRenderer
    implements ListCellRenderer {
        Icon commonIcon;

        public CheckListRenderer() {
            this.check.setBackground(UIManager.getColor("List.textBackground"));
            this.label.setForeground(UIManager.getColor("List.textForeground"));
            this.commonIcon = UIManager.getIcon("Tree.leafIcon");
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setEnabled(jList.isEnabled());
            this.check.setSelected(((CheckableItem)object).isSelected());
            this.label.setFont(jList.getFont());
            this.label.setText(object.toString());
            this.label.setSelected(bl);
            this.label.setFocus(bl2);
            Icon icon = ((CheckableItem)object).getIcon();
            if (icon == null) {
                icon = this.commonIcon;
            }
            this.label.setIcon(icon);
            return this;
        }
    }

    class CheckableItem {
        private String str;
        private boolean isSelected;
        private Icon icon;

        public CheckableItem(String string) {
            this.str = string;
            this.isSelected = false;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public String toString() {
            return this.str;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

