/*
 * Decompiled with CFR 0.152.
 */
package spreader.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import spreader.db.MailMethod;
import spreader.service.base.AbstractWeiboService;
import spreader.ui.UIListener;
import weibo4j.IDs;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.http.AccessToken;

public class GetFollowsService
extends AbstractWeiboService {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private Map<String, AccessToken> accessTokens;

    public GetFollowsService(Map<String, AccessToken> map) {
        this.accessTokens = map;
    }

    public void insertFollow() {
        String string = new SimpleDateFormat(DATE_TIME_FORMAT).format(new Date());
        UIListener.updateMailBoard(string + " \u8d26\u6237\u83b7\u53d6\u7c89\u4e1d\u5f00\u59cb\u6267\u884c...");
        for (String string2 : this.accessTokens.keySet()) {
            AccessToken accessToken = this.accessTokens.get(string2);
            this.create(string2, accessToken);
        }
        UIListener.updateMailBoard("\u8d26\u6237\u83b7\u53d6\u7c89\u4e1d\u5b8c\u6bd5!");
    }

    private void create(String string, AccessToken accessToken) {
        Weibo weibo = GetFollowsService.getWeibo(true, accessToken);
        try {
            IDs iDs = weibo.getFollowersIDs();
            int[] nArray = iDs.getIDs();
            for (int i = 0; i < nArray.length; ++i) {
                if (MailMethod.isExistFollow(String.valueOf(nArray[i]))) continue;
                MailMethod.insertFollows(String.valueOf(nArray[i]), string);
            }
        }
        catch (WeiboException weiboException) {
            weiboException.printStackTrace();
        }
    }
}

