/*
 * Decompiled with CFR 0.152.
 */
package spreader.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import spreader.db.DBMethod;
import spreader.service.SearchUserService;
import spreader.service.base.AbstractWeiboService;
import spreader.ui.UIListener;
import weibo4j.User;
import weibo4j.Weibo;
import weibo4j.http.AccessToken;

public class InsertUserDBService
extends AbstractWeiboService {
    private static int ADD_FRIEND_LOOP_TIMES = 120;
    private int delay;
    private Map<String, AccessToken> accessTokens;

    public InsertUserDBService(Map<String, AccessToken> map) {
        this.accessTokens = map;
        this.delay = map.size() > 0 ? 3600000 / (map.size() * ADD_FRIEND_LOOP_TIMES) : 3600000;
    }

    public void InsertUserDB() {
        block0: while (true) {
            Iterator<String> iterator = this.accessTokens.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                String string = iterator.next();
                AccessToken accessToken = this.accessTokens.get(string);
                this.insertUser(string, accessToken);
            }
            break;
        }
    }

    private void insertUser(String string, AccessToken accessToken) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Weibo weibo = InsertUserDBService.getWeibo(true, accessToken);
        for (int i = 0; i < ADD_FRIEND_LOOP_TIMES; ++i) {
            List<User> list = SearchUserService.findUsers(weibo);
            int n = 0;
            int n2 = 0;
            DBMethod dBMethod = new DBMethod();
            for (User user : list) {
                try {
                    if (!dBMethod.isExistUser(user)) {
                        ++n;
                        dBMethod.insertUser(user);
                        continue;
                    }
                    ++n2;
                }
                catch (Exception exception) {
                    System.out.println("Spreader - insert user Service error:" + exception.getMessage());
                    exception.printStackTrace();
                }
            }
            UIListener.updateBoard(simpleDateFormat.format(new Date()) + " " + string + "\u83b7\u53d6\u7684\u5e10\u6237\u6709" + n + "\u6761\u4fe1\u606f\u5b58\u5165\u6570\u636e\u5e93\uff0c\u6709" + n2 + "\u6761\u4fe1\u606f\u91cd\u590d");
            try {
                Thread.sleep(this.delay);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

