/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.Date;
import weibo4j.Configuration;
import weibo4j.Dispatcher;
import weibo4j.Paging;
import weibo4j.Query;
import weibo4j.Weibo;
import weibo4j.WeiboAdapter;
import weibo4j.WeiboException;
import weibo4j.WeiboListener;

public class AsyncWeibo
extends Weibo {
    private static final long serialVersionUID = -2008667933225051907L;
    private static transient Dispatcher dispatcher;
    private boolean shutdown = false;
    public static final int PUBLIC_TIMELINE = 0;
    public static final int HOME_TIMELINE = 51;
    public static final int FRIENDS_TIMELINE = 1;
    public static final int USER_TIMELINE = 2;
    public static final int SHOW = 3;
    public static final int SHOW_STATUS = 38;
    public static final int UPDATE = 4;
    public static final int UPDATE_STATUS = 39;
    public static final int REPLIES = 5;
    public static final int MENTIONS = 37;
    public static final int RETWEETED_BY_ME = 53;
    public static final int RETWEETED_TO_ME = 54;
    public static final int RETWEETS_OF_ME = 55;
    public static final int FRIENDS = 6;
    public static final int FOLLOWERS = 7;
    public static final int FEATURED = 8;
    public static final int USER_DETAIL = 9;
    public static final int DIRECT_MESSAGES = 10;
    public static final int DESTROY_DIRECT_MESSAGES = 40;
    public static final int SEND_DIRECT_MESSAGE = 11;
    public static final int CREATE = 12;
    public static final int CREATE_FRIENDSHIP = 32;
    public static final int DESTORY = 13;
    public static final int DESTROY = 13;
    public static final int DESTROY_FRIENDSHIP = 33;
    public static final int EXISTS = 28;
    public static final int EXISTS_FRIENDSHIP = 34;
    public static final int FOLLOW = 14;
    public static final int ENABLE_NOTIFICATION = 35;
    public static final int LEAVE = 15;
    public static final int DISABLE_NOTIFICATION = 36;
    public static final int FAVORITES = 17;
    public static final int FRIENDS_IDS = 29;
    public static final int FOLLOWERS_IDS = 30;
    public static final int CREATE_FAVORITE = 18;
    public static final int DESTROY_FAVORITE = 19;
    public static final int UPDATE_LOCATION = 20;
    public static final int UPDATE_PROFILE = 41;
    public static final int UPDATE_PROFILE_COLORS = 31;
    public static final int RATE_LIMIT_STATUS = 28;
    public static final int UPDATE_DELIVERLY_DEVICE = 21;
    public static final int BLOCK = 22;
    public static final int CREATED_BLOCK = 43;
    public static final int UNBLOCK = 23;
    public static final int DESTROYED_BLOCK = 42;
    private static final int EXISTS_BLOCK = 48;
    private static final int GET_BLOCKING_USERS = 49;
    private static final int GET_BLOCKING_USERS_IDS = 50;
    public static final int TEST = 24;
    public static final int GET_DOWNTIME_SCHEDULE = 25;
    public static final int DESTROY_STATUS = 26;
    public static final int RETWEET_STATUS = 52;
    public static final int SEARCH = 27;
    public static final int TRENDS = 44;
    public static final int CURRENT_TRENDS = 45;
    public static final int DAILY_TRENDS = 46;
    public static final int WEEKLY_TRENDS = 47;

    public AsyncWeibo(String string, String string2) {
        super(string, string2);
    }

    public AsyncWeibo(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public void searchAcync(Query query, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(27, weiboListener, new Object[]{query}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.searched(AsyncWeibo.this.search((Query)objectArray[0]));
            }
        });
    }

    public void getTrendsAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(44, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotTrends(AsyncWeibo.this.getTrends());
            }
        });
    }

    public void getCurrentTrendsAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(45, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotCurrentTrends(AsyncWeibo.this.getCurrentTrends());
            }
        });
    }

    public void getCurrentTrendsAsync(boolean bl, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(45, weiboListener, new Object[]{bl}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotCurrentTrends(AsyncWeibo.this.getCurrentTrends((Boolean)objectArray[0]));
            }
        });
    }

    public void getDailyTrendsAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(46, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotDailyTrends(AsyncWeibo.this.getDailyTrends());
            }
        });
    }

    public void getDailyTrendsAsync(Date date, boolean bl, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(46, weiboListener, new Object[]{date, bl}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotDailyTrends(AsyncWeibo.this.getDailyTrends((Date)objectArray[0], (Boolean)objectArray[1]));
            }
        });
    }

    public void getWeeklyTrendsAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(47, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotWeeklyTrends(AsyncWeibo.this.getWeeklyTrends());
            }
        });
    }

    public void getWeeklyTrendsAsync(Date date, boolean bl, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(47, weiboListener, new Object[]{date, bl}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotWeeklyTrends(AsyncWeibo.this.getWeeklyTrends((Date)objectArray[0], (Boolean)objectArray[1]));
            }
        });
    }

    public void getPublicTimelineAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(0, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotPublicTimeline(AsyncWeibo.this.getPublicTimeline());
            }
        });
    }

    public void getPublicTimelineAsync(int n, WeiboListener weiboListener) {
        this.getPublicTimelineAsync((long)n, weiboListener);
    }

    public void getPublicTimelineAsync(long l, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(0, weiboListener, new Long[]{l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotPublicTimeline(AsyncWeibo.this.getPublicTimeline((Long)objectArray[0]));
            }
        });
    }

    public void getHomeTimelineAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(51, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotHomeTimeline(AsyncWeibo.this.getHomeTimeline());
            }
        });
    }

    public void getHomeTimelineAsync(Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(51, weiboListener, new Object[]{paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotHomeTimeline(AsyncWeibo.this.getHomeTimeline((Paging)objectArray[0]));
            }
        });
    }

    public void getFriendsTimelineAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(1, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriendsTimeline(AsyncWeibo.this.getFriendsTimeline());
            }
        });
    }

    public void getFriendsTimelineAsync(Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(1, weiboListener, new Object[]{paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriendsTimeline(AsyncWeibo.this.getFriendsTimeline((Paging)objectArray[0]));
            }
        });
    }

    public void getFriendsTimelineByPageAsync(int n, WeiboListener weiboListener) {
        this.getFriendsTimelineAsync(new Paging(n), weiboListener);
    }

    public void getFriendsTimelineAsync(int n, WeiboListener weiboListener) {
        this.getFriendsTimelineAsync(new Paging(n), weiboListener);
    }

    public void getFriendsTimelineAsync(long l, int n, WeiboListener weiboListener) {
        this.getFriendsTimelineAsync(new Paging(n, l), weiboListener);
    }

    public void getFriendsTimelineAsync(String string, WeiboListener weiboListener) {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public void getFriendsTimelineAsync(String string, Paging paging, WeiboListener weiboListener) {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public void getFriendsTimelineByPageAsync(String string, int n, WeiboListener weiboListener) {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public void getFriendsTimelineAsync(String string, int n, WeiboListener weiboListener) {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public void getFriendsTimelineAsync(long l, String string, int n, WeiboListener weiboListener) {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public void getFriendsTimelineAsync(Date date, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(1, weiboListener, new Object[]{date}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriendsTimeline(AsyncWeibo.this.getFriendsTimeline((Date)objectArray[0]));
            }
        });
    }

    public void getFriendsTimelineAsync(long l, WeiboListener weiboListener) {
        this.getFriendsTimelineAsync(new Paging(l), weiboListener);
    }

    public void getFriendsTimelineAsync(String string, Date date, WeiboListener weiboListener) {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public void getFriendsTimelineAsync(String string, long l, WeiboListener weiboListener) {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public void getUserTimelineAsync(String string, int n, Date date, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(2, weiboListener, new Object[]{string, n, date}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotUserTimeline(AsyncWeibo.this.getUserTimeline((String)objectArray[0], (int)((Integer)objectArray[1]), (Date)objectArray[2]));
            }
        });
    }

    public void getUserTimelineAsync(String string, Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(2, weiboListener, new Object[]{string, paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotUserTimeline(AsyncWeibo.this.getUserTimeline((String)objectArray[0], (Paging)objectArray[1]));
            }
        });
    }

    public void getUserTimelineAsync(String string, int n, long l, WeiboListener weiboListener) {
        this.getUserTimelineAsync(string, new Paging(n, l), weiboListener);
    }

    public void getUserTimelineAsync(String string, Date date, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(2, weiboListener, new Object[]{string, date}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotUserTimeline(AsyncWeibo.this.getUserTimeline((String)objectArray[0], (Date)objectArray[1]));
            }
        });
    }

    public void getUserTimelineAsync(String string, int n, WeiboListener weiboListener) {
        this.getUserTimelineAsync(string, new Paging().count(n), weiboListener);
    }

    public void getUserTimelineAsync(int n, Date date, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(2, weiboListener, new Object[]{n, date}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotUserTimeline(AsyncWeibo.this.getUserTimeline((int)((Integer)objectArray[0]), (Date)objectArray[1]));
            }
        });
    }

    public void getUserTimelineAsync(Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(2, weiboListener, new Object[]{paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotUserTimeline(AsyncWeibo.this.getUserTimeline((Paging)objectArray[0]));
            }
        });
    }

    public void getUserTimelineAsync(int n, long l, WeiboListener weiboListener) {
        this.getUserTimelineAsync(new Paging(l).count(n), weiboListener);
    }

    public void getUserTimelineAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(2, weiboListener, new Object[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotUserTimeline(AsyncWeibo.this.getUserTimeline((String)objectArray[0]));
            }
        });
    }

    public void getUserTimelineAsync(String string, long l, WeiboListener weiboListener) {
        this.getUserTimelineAsync(string, new Paging(l), weiboListener);
    }

    public void getUserTimelineAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(2, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotUserTimeline(AsyncWeibo.this.getUserTimeline());
            }
        });
    }

    public void getUserTimelineAsync(long l, WeiboListener weiboListener) {
        this.getUserTimelineAsync(new Paging(l), weiboListener);
    }

    public void getRepliesAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(5, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotReplies(AsyncWeibo.this.getReplies());
            }
        });
    }

    public void getMentionsAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(37, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotMentions(AsyncWeibo.this.getMentions());
            }
        });
    }

    public void getMentionsAsync(Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(37, weiboListener, new Object[]{paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotMentions(AsyncWeibo.this.getMentions((Paging)objectArray[0]));
            }
        });
    }

    public void getRetweetedByMeAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(53, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotRetweetedByMe(AsyncWeibo.this.getRetweetedByMe());
            }
        });
    }

    public void getRetweetedByMeAsync(Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(53, weiboListener, new Object[]{paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotRetweetedByMe(AsyncWeibo.this.getRetweetedByMe((Paging)objectArray[0]));
            }
        });
    }

    public void getRetweetedToMeAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(54, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotRetweetedToMe(AsyncWeibo.this.getRetweetedToMe());
            }
        });
    }

    public void getRetweetedToMeAsync(Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(54, weiboListener, new Object[]{paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotRetweetedToMe(AsyncWeibo.this.getRetweetedToMe((Paging)objectArray[0]));
            }
        });
    }

    public void getRetweetsOfMeAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(55, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotRetweetsOfMe(AsyncWeibo.this.getRetweetsOfMe());
            }
        });
    }

    public void getRetweetsOfMeAsync(Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(55, weiboListener, new Object[]{paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotRetweetsOfMe(AsyncWeibo.this.getRetweetsOfMe((Paging)objectArray[0]));
            }
        });
    }

    public void getRepliesAsync(long l, WeiboListener weiboListener) {
        this.getMentionsAsync(new Paging(l), weiboListener);
    }

    public void getRepliesByPageAsync(int n, WeiboListener weiboListener) {
        this.getMentionsAsync(new Paging(n), weiboListener);
    }

    public void getRepliesAsync(int n, WeiboListener weiboListener) {
        this.getMentionsAsync(new Paging(n), weiboListener);
    }

    public void getRepliesAsync(long l, int n, WeiboListener weiboListener) {
        this.getMentionsAsync(new Paging(n, l), weiboListener);
    }

    public void showAsync(int n, WeiboListener weiboListener) {
        this.showAsync((long)n, weiboListener);
    }

    public void showAsync(long l, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(3, weiboListener, new Object[]{l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotShow(AsyncWeibo.this.show((Long)objectArray[0]));
            }
        });
    }

    public void showStatusAsync(long l, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(38, weiboListener, new Object[]{l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotShowStatus(AsyncWeibo.this.showStatus((Long)objectArray[0]));
            }
        });
    }

    public void updateAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(4, weiboListener, new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.updated(AsyncWeibo.this.update((String)objectArray[0]));
            }
        });
    }

    public void updateAsync(String string) {
        this.getDispatcher().invokeLater(new AsyncTask(4, new WeiboAdapter(), new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.updated(AsyncWeibo.this.update((String)objectArray[0]));
            }
        });
    }

    public void updateStatusAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(39, weiboListener, new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.updatedStatus(AsyncWeibo.this.updateStatus((String)objectArray[0]));
            }
        });
    }

    public void updateStatusAsync(String string) {
        this.getDispatcher().invokeLater(new AsyncTask(39, new WeiboAdapter(), new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.updatedStatus(AsyncWeibo.this.updateStatus((String)objectArray[0]));
            }
        });
    }

    public void updateAsync(String string, long l, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(4, weiboListener, new Object[]{string, l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.updated(AsyncWeibo.this.update((String)objectArray[0], (Long)objectArray[1]));
            }
        });
    }

    public void updateAsync(String string, long l) {
        this.getDispatcher().invokeLater(new AsyncTask(4, new WeiboAdapter(), new Object[]{string, l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.updated(AsyncWeibo.this.update((String)objectArray[0], (Long)objectArray[1]));
            }
        });
    }

    public void updateStatusAsync(String string, long l, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(39, weiboListener, new Object[]{string, l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.updatedStatus(AsyncWeibo.this.updateStatus((String)objectArray[0], (Long)objectArray[1]));
            }
        });
    }

    public void updateStatusAsync(String string, long l) {
        this.getDispatcher().invokeLater(new AsyncTask(39, new WeiboAdapter(), new Object[]{string, l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.updatedStatus(AsyncWeibo.this.updateStatus((String)objectArray[0], (Long)objectArray[1]));
            }
        });
    }

    public void destoryStatusAsync(int n) {
        this.destroyStatusAsync((long)n);
    }

    public void destroyStatusAsync(int n) {
        this.destroyStatusAsync((long)n);
    }

    public void destroyStatusAsync(long l) {
        this.getDispatcher().invokeLater(new AsyncTask(26, new WeiboAdapter(), new Long[]{l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.destroyedStatus(AsyncWeibo.this.destroyStatus((Long)objectArray[0]));
            }
        });
    }

    public void destoryStatusAsync(int n, WeiboListener weiboListener) {
        this.destroyStatusAsync((long)n, weiboListener);
    }

    public void destroyStatusAsync(int n, WeiboListener weiboListener) {
        this.destroyStatusAsync((long)n, weiboListener);
    }

    public void destroyStatusAsync(long l, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(26, weiboListener, new Long[]{l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.destroyedStatus(AsyncWeibo.this.destroyStatus((Long)objectArray[0]));
            }
        });
    }

    public void retweetStatusAsync(long l, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(52, weiboListener, new Long[]{l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.retweetedStatus(AsyncWeibo.this.retweetStatus((Long)objectArray[0]));
            }
        });
    }

    public void retweetStatusAsync(long l) {
        this.retweetStatusAsync(l, new WeiboAdapter());
    }

    public void getUserDetailAsync(String string, WeiboListener weiboListener) {
        this.showUserAsync(string, weiboListener);
    }

    public void showUserAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(9, weiboListener, new Object[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotUserDetail(AsyncWeibo.this.showUser((String)objectArray[0]));
            }
        });
    }

    public void getFriendsAsync(WeiboListener weiboListener) {
        this.getFriendsStatusesAsync(weiboListener);
    }

    public void getFriendsStatusesAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(6, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriends(AsyncWeibo.this.getFriendsStatuses());
            }
        });
    }

    public void getFriendsAsync(Paging paging, WeiboListener weiboListener) {
        this.getFriendsStatusesAsync(paging, weiboListener);
    }

    public void getFriendsStatusesAsync(Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(6, weiboListener, new Object[]{paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriends(AsyncWeibo.this.getFriendsStatuses((Paging)objectArray[0]));
            }
        });
    }

    public void getFriendsAsync(int n, WeiboListener weiboListener) {
        this.getFriendsStatusesAsync(new Paging(n), weiboListener);
    }

    public void getFriendsAsync(String string, WeiboListener weiboListener) {
        this.getFriendsStatusesAsync(string, weiboListener);
    }

    public void getFriendsStatusesAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(6, weiboListener, new Object[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriends(AsyncWeibo.this.getFriendsStatuses((String)objectArray[0]));
            }
        });
    }

    public void getFriendsAsync(String string, Paging paging, WeiboListener weiboListener) {
        this.getFriendsStatusesAsync(string, paging, weiboListener);
    }

    public void getFriendsStatusesAsync(String string, Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(6, weiboListener, new Object[]{string, paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriends(AsyncWeibo.this.getFriendsStatuses((String)objectArray[0], (Paging)objectArray[1]));
            }
        });
    }

    public void getFriendsAsync(String string, int n, WeiboListener weiboListener) {
        this.getFriendsStatusesAsync(string, new Paging(n), weiboListener);
    }

    public void getFollowersAsync(WeiboListener weiboListener) {
        this.getFollowersStatusesAsync(weiboListener);
    }

    public void getFollowersStatusesAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(7, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFollowers(AsyncWeibo.this.getFollowers());
            }
        });
    }

    public void getFollowersAsync(Paging paging, WeiboListener weiboListener) {
        this.getFollowersStatusesAsync(paging, weiboListener);
    }

    public void getFollowersStatusesAsync(Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(7, weiboListener, new Object[]{paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFollowers(AsyncWeibo.this.getFollowersStatuses((Paging)objectArray[0]));
            }
        });
    }

    public void getFollowersAsync(int n, WeiboListener weiboListener) {
        this.getFollowersStatusesAsync(new Paging(n), weiboListener);
    }

    public void getFollowersAsync(String string, WeiboListener weiboListener) {
        this.getFollowersStatusesAsync(string, weiboListener);
    }

    public void getFollowersStatusesAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(7, weiboListener, new Object[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFollowers(AsyncWeibo.this.getFollowersStatuses((String)objectArray[0]));
            }
        });
    }

    public void getFollowersAsync(String string, Paging paging, WeiboListener weiboListener) {
        this.getFollowersStatusesAsync(string, paging, weiboListener);
    }

    public void getFollowersStatusesAsync(String string, Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(7, weiboListener, new Object[]{string, paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFollowers(AsyncWeibo.this.getFollowersStatuses((String)objectArray[0], (Paging)objectArray[1]));
            }
        });
    }

    public void getFollowersAsync(String string, int n, WeiboListener weiboListener) {
        this.getFollowersStatusesAsync(string, new Paging(n), weiboListener);
    }

    public void getFeaturedAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(8, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFeatured(AsyncWeibo.this.getFeatured());
            }
        });
    }

    public void getDirectMessagesAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(10, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotDirectMessages(AsyncWeibo.this.getDirectMessages());
            }
        });
    }

    public void getDirectMessagesAsync(Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(10, weiboListener, new Object[]{paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotDirectMessages(AsyncWeibo.this.getDirectMessages((Paging)objectArray[0]));
            }
        });
    }

    public void getDirectMessagesByPageAsync(int n, WeiboListener weiboListener) {
        this.getDirectMessagesAsync(new Paging(n), weiboListener);
    }

    public void getDirectMessagesByPageAsync(int n, int n2, WeiboListener weiboListener) {
        this.getDirectMessagesAsync(new Paging(n, (long)n2), weiboListener);
    }

    public void getDirectMessagesAsync(int n, WeiboListener weiboListener) {
        this.getDirectMessagesAsync(new Paging((long)n), weiboListener);
    }

    public void getDirectMessagesAsync(Date date, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(10, weiboListener, new Object[]{date}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotDirectMessages(AsyncWeibo.this.getDirectMessages((Date)objectArray[0]));
            }
        });
    }

    public void getSentDirectMessagesAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(10, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotSentDirectMessages(AsyncWeibo.this.getSentDirectMessages());
            }
        });
    }

    public void getSentDirectMessagesAsync(Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(10, weiboListener, new Object[]{paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotSentDirectMessages(AsyncWeibo.this.getSentDirectMessages((Paging)objectArray[0]));
            }
        });
    }

    public void getSentDirectMessagesAsync(Date date, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(10, weiboListener, new Object[]{date}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotSentDirectMessages(AsyncWeibo.this.getSentDirectMessages((Date)objectArray[0]));
            }
        });
    }

    public void getSentDirectMessagesAsync(int n, WeiboListener weiboListener) {
        this.getSentDirectMessagesAsync(new Paging((long)n), weiboListener);
    }

    public void getSentDirectMessagesAsync(int n, int n2, WeiboListener weiboListener) {
        this.getSentDirectMessagesAsync(new Paging(n, (long)n2), weiboListener);
    }

    public void sendDirectMessageAsync(String string, String string2, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(11, weiboListener, new String[]{string, string2}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.sentDirectMessage(AsyncWeibo.this.sendDirectMessage((String)objectArray[0], (String)objectArray[1]));
            }
        });
    }

    public void sendDirectMessageAsync(String string, String string2) {
        this.getDispatcher().invokeLater(new AsyncTask(11, new WeiboAdapter(), new String[]{string, string2}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.sentDirectMessage(AsyncWeibo.this.sendDirectMessage((String)objectArray[0], (String)objectArray[1]));
            }
        });
    }

    public void deleteDirectMessageAsync(int n, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(40, weiboListener, new Object[]{n}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.deletedDirectMessage(AsyncWeibo.this.deleteDirectMessage((Integer)objectArray[0]));
            }
        });
    }

    public void destroyDirectMessageAsync(int n, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(40, weiboListener, new Object[]{n}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.destroyedDirectMessage(AsyncWeibo.this.destroyDirectMessage((Integer)objectArray[0]));
            }
        });
    }

    public void destroyDirectMessageAsync(int n) {
        this.getDispatcher().invokeLater(new AsyncTask(40, new WeiboAdapter(), new Object[]{n}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.destroyedDirectMessage(AsyncWeibo.this.destroyDirectMessage((Integer)objectArray[0]));
            }
        });
    }

    public void createAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(12, weiboListener, new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.created(AsyncWeibo.this.create((String)objectArray[0]));
            }
        });
    }

    public void createFriendshipAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(32, weiboListener, new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.createdFriendship(AsyncWeibo.this.createFriendship((String)objectArray[0]));
            }
        });
    }

    public void createFriendshipAsync(String string, boolean bl, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(32, weiboListener, new Object[]{string, bl}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.createdFriendship(AsyncWeibo.this.createFriendship((String)objectArray[0], (Boolean)objectArray[1]));
            }
        });
    }

    public void createAsync(String string) {
        this.getDispatcher().invokeLater(new AsyncTask(12, new WeiboAdapter(), new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.created(AsyncWeibo.this.create((String)objectArray[0]));
            }
        });
    }

    public void createFriendshipAsync(String string) {
        this.createFriendshipAsync(string, new WeiboAdapter());
    }

    public void destroyAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(13, weiboListener, new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.destroyed(AsyncWeibo.this.destroy((String)objectArray[0]));
            }
        });
    }

    public void destroyAsync(String string) {
        this.getDispatcher().invokeLater(new AsyncTask(13, new WeiboAdapter(), new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.destroyed(AsyncWeibo.this.destroy((String)objectArray[0]));
            }
        });
    }

    public void destroyFriendshipAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(33, weiboListener, new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.destroyedFriendship(AsyncWeibo.this.destroyFriendship((String)objectArray[0]));
            }
        });
    }

    public void destroyFriendshipAsync(String string) {
        this.destroyFriendshipAsync(string, new WeiboAdapter());
    }

    public void existsAsync(String string, String string2, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(28, weiboListener, new String[]{string, string2}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotExists(AsyncWeibo.this.exists((String)objectArray[0], (String)objectArray[1]));
            }
        });
    }

    public void existsFriendshipAsync(String string, String string2, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(34, weiboListener, new String[]{string, string2}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotExistsFriendship(AsyncWeibo.this.existsFriendship((String)objectArray[0], (String)objectArray[1]));
            }
        });
    }

    public void getFriendsIDsAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(29, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriendsIDs(AsyncWeibo.this.getFriendsIDs());
            }
        });
    }

    public void getFriendsIDsAsync(Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(29, weiboListener, new Object[]{paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriendsIDs(AsyncWeibo.this.getFriendsIDs((Paging)objectArray[0]));
            }
        });
    }

    public void getFriendsIDsAsync(long l, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(29, weiboListener, new Object[]{l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriendsIDs(AsyncWeibo.this.getFriendsIDs((Long)objectArray[0]));
            }
        });
    }

    public void getFriendsIDsAsync(int n, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(29, weiboListener, new Integer[]{n}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriendsIDs(AsyncWeibo.this.getFriendsIDs((Integer)objectArray[0]));
            }
        });
    }

    public void getFriendsIDsAsync(int n, Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(29, weiboListener, new Object[]{n, paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriendsIDs(AsyncWeibo.this.getFriendsIDs((int)((Integer)objectArray[0]), (Paging)objectArray[1]));
            }
        });
    }

    public void getFriendsIDsAsync(int n, long l, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(29, weiboListener, new Object[]{n, l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriendsIDs(AsyncWeibo.this.getFriendsIDs((int)((Integer)objectArray[0]), (long)((Long)objectArray[1])));
            }
        });
    }

    public void getFriendsIDsAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(29, weiboListener, new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriendsIDs(AsyncWeibo.this.getFriendsIDs((String)objectArray[0]));
            }
        });
    }

    public void getFriendsIDsAsync(String string, Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(29, weiboListener, new Object[]{string, paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriendsIDs(AsyncWeibo.this.getFriendsIDs((String)objectArray[0], (Paging)objectArray[1]));
            }
        });
    }

    public void getFriendsIDsAsync(String string, long l, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(29, weiboListener, new Object[]{string, l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFriendsIDs(AsyncWeibo.this.getFriendsIDs((String)objectArray[0], (long)((Long)objectArray[1])));
            }
        });
    }

    public void getFollowersIDsAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(30, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFollowersIDs(AsyncWeibo.this.getFollowersIDs());
            }
        });
    }

    public void getFollowersIDsAsync(Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(30, weiboListener, new Object[]{paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFollowersIDs(AsyncWeibo.this.getFollowersIDs((Paging)objectArray[0]));
            }
        });
    }

    public void getFollowersIDsAsync(long l, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(30, weiboListener, new Object[]{l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFollowersIDs(AsyncWeibo.this.getFollowersIDs((Long)objectArray[0]));
            }
        });
    }

    public void getFollowersIDsAsync(int n, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(30, weiboListener, new Integer[]{n}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFollowersIDs(AsyncWeibo.this.getFollowersIDs((Integer)objectArray[0]));
            }
        });
    }

    public void getFollowersIDsAsync(int n, Paging paging, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(30, weiboListener, new Object[]{n, paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFollowersIDs(AsyncWeibo.this.getFollowersIDs((int)((Integer)objectArray[0]), (Paging)objectArray[1]));
            }
        });
    }

    public void getFollowersIDsAsync(int n, long l, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(30, weiboListener, new Object[]{n, l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFollowersIDs(AsyncWeibo.this.getFollowersIDs((int)((Integer)objectArray[0]), (long)((Long)objectArray[1])));
            }
        });
    }

    public void getFollowersIDsAsync(String string, WeiboListener weiboListener) throws WeiboException {
        this.getDispatcher().invokeLater(new AsyncTask(30, weiboListener, new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFollowersIDs(AsyncWeibo.this.getFollowersIDs((String)objectArray[0]));
            }
        });
    }

    public void getFollowersIDsAsync(String string, Paging paging, WeiboListener weiboListener) throws WeiboException {
        this.getDispatcher().invokeLater(new AsyncTask(30, weiboListener, new Object[]{string, paging}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFollowersIDs(AsyncWeibo.this.getFollowersIDs((String)objectArray[0], (Paging)objectArray[1]));
            }
        });
    }

    public void getFollowersIDsAsync(String string, long l, WeiboListener weiboListener) throws WeiboException {
        this.getDispatcher().invokeLater(new AsyncTask(30, weiboListener, new Object[]{string, l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFollowersIDs(AsyncWeibo.this.getFollowersIDs((String)objectArray[0], (long)((Long)objectArray[1])));
            }
        });
    }

    public void updateLocationAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(20, weiboListener, new Object[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.updatedLocation(AsyncWeibo.this.updateLocation((String)objectArray[0]));
            }
        });
    }

    public void updateProfileAsync(String string, String string2, String string3, String string4, String string5, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(41, weiboListener, new String[]{string, string2, string3, string4, string5}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.updatedProfile(AsyncWeibo.this.updateProfile((String)objectArray[0], (String)objectArray[1], (String)objectArray[2], (String)objectArray[3], (String)objectArray[4]));
            }
        });
    }

    public void updateProfileAsync(String string, String string2, String string3, String string4, String string5) {
        this.updateProfileAsync(string, string2, string3, string4, string5, new WeiboAdapter());
    }

    public void rateLimitStatusAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(28, weiboListener, new Object[0]){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotRateLimitStatus(AsyncWeibo.this.rateLimitStatus());
            }
        });
    }

    public void updateDeliverlyDeviceAsync(Weibo.Device device, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(20, weiboListener, new Object[]{device}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.updatedDeliverlyDevice(AsyncWeibo.this.updateDeliverlyDevice((Weibo.Device)objectArray[0]));
            }
        });
    }

    public void updateProfileColorsAsync(String string, String string2, String string3, String string4, String string5, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(31, weiboListener, new Object[]{string, string2, string3, string4, string5}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.updatedProfileColors(AsyncWeibo.this.updateProfileColors((String)objectArray[0], (String)objectArray[1], (String)objectArray[2], (String)objectArray[3], (String)objectArray[4]));
            }
        });
    }

    public void updateProfileColorsAsync(String string, String string2, String string3, String string4, String string5) {
        this.updateProfileColorsAsync(string, string2, string3, string4, string5, new WeiboAdapter());
    }

    public void favoritesAsync(WeiboListener weiboListener) {
        this.getFavoritesAsync(weiboListener);
    }

    public void getFavoritesAsync(WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFavorites(AsyncWeibo.this.getFavorites());
            }
        });
    }

    public void favoritesAsync(int n, WeiboListener weiboListener) {
        this.getFavoritesAsync(n, weiboListener);
    }

    public void getFavoritesAsync(int n, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, weiboListener, new Object[]{n}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFavorites(AsyncWeibo.this.getFavorites((Integer)objectArray[0]));
            }
        });
    }

    public void favoritesAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, weiboListener, new Object[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFavorites(AsyncWeibo.this.favorites((String)objectArray[0]));
            }
        });
    }

    public void getFavoritesAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, weiboListener, new Object[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFavorites(AsyncWeibo.this.getFavorites((String)objectArray[0]));
            }
        });
    }

    public void favoritesAsync(String string, int n, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, weiboListener, new Object[]{string, n}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFavorites(AsyncWeibo.this.favorites((String)objectArray[0], (Integer)objectArray[1]));
            }
        });
    }

    public void getFavoritesAsync(String string, int n, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, weiboListener, new Object[]{string, n}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotFavorites(AsyncWeibo.this.getFavorites((String)objectArray[0], (Integer)objectArray[1]));
            }
        });
    }

    public void createFavoriteAsync(int n, WeiboListener weiboListener) {
        this.createFavoriteAsync((long)n, weiboListener);
    }

    public void createFavoriteAsync(long l, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, weiboListener, new Object[]{l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.createdFavorite(AsyncWeibo.this.createFavorite((Long)objectArray[0]));
            }
        });
    }

    public void createFavoriteAsync(int n) {
        this.createFavoriteAsync((long)n);
    }

    public void createFavoriteAsync(long l) {
        this.getDispatcher().invokeLater(new AsyncTask(17, new WeiboAdapter(), new Object[]{l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.createdFavorite(AsyncWeibo.this.createFavorite((Long)objectArray[0]));
            }
        });
    }

    public void destroyFavoriteAsync(int n, WeiboListener weiboListener) {
        this.destroyFavoriteAsync((long)n, weiboListener);
    }

    public void destroyFavoriteAsync(long l, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, weiboListener, new Object[]{l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.destroyedFavorite(AsyncWeibo.this.destroyFavorite((Long)objectArray[0]));
            }
        });
    }

    public void destroyFavoriteAsync(int n) {
        this.destroyFavoriteAsync((long)n);
    }

    public void destroyFavoriteAsync(long l) {
        this.getDispatcher().invokeLater(new AsyncTask(17, new WeiboAdapter(), new Object[]{l}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.destroyedFavorite(AsyncWeibo.this.destroyFavorite((Long)objectArray[0]));
            }
        });
    }

    public void followAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(14, weiboListener, new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.followed(AsyncWeibo.this.follow((String)objectArray[0]));
            }
        });
    }

    public void enableNotificationAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(35, weiboListener, new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.enabledNotification(AsyncWeibo.this.enableNotification((String)objectArray[0]));
            }
        });
    }

    public void followAsync(String string) {
        this.getDispatcher().invokeLater(new AsyncTask(14, new WeiboAdapter(), new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.followed(AsyncWeibo.this.follow((String)objectArray[0]));
            }
        });
    }

    public void enableNotificationAsync(String string) {
        this.enableNotificationAsync(string, new WeiboAdapter());
    }

    public void leaveAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(15, weiboListener, new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.left(AsyncWeibo.this.leave((String)objectArray[0]));
            }
        });
    }

    public void disableNotificationAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(36, weiboListener, new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.disabledNotification(AsyncWeibo.this.disableNotification((String)objectArray[0]));
            }
        });
    }

    public void leaveAsync(String string) {
        this.getDispatcher().invokeLater(new AsyncTask(15, new WeiboAdapter(), new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.left(AsyncWeibo.this.leave((String)objectArray[0]));
            }
        });
    }

    public void disableNotificationAsync(String string) {
        this.disableNotificationAsync(string, new WeiboAdapter());
    }

    public void blockAsync(String string) {
        this.getDispatcher().invokeLater(new AsyncTask(22, new WeiboAdapter(), new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.blocked(AsyncWeibo.this.block((String)objectArray[0]));
            }
        });
    }

    public void createBlockAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(43, weiboListener, new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.createdBlock(AsyncWeibo.this.createBlock((String)objectArray[0]));
            }
        });
    }

    public void createBlockAsync(String string) {
        this.createBlockAsync(string, new WeiboAdapter());
    }

    public void unblockAsync(String string) {
        this.getDispatcher().invokeLater(new AsyncTask(23, new WeiboAdapter(), new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.unblocked(AsyncWeibo.this.unblock((String)objectArray[0]));
            }
        });
    }

    public void destroyBlockAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(42, weiboListener, new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.destroyedBlock(AsyncWeibo.this.destroyBlock((String)objectArray[0]));
            }
        });
    }

    public void destroyBlockAsync(String string) {
        this.destroyBlockAsync(string, new WeiboAdapter());
    }

    public void existsBlockAsync(String string, WeiboListener weiboListener) {
        this.getDispatcher().invokeLater(new AsyncTask(48, weiboListener, new String[]{string}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotExistsBlock(AsyncWeibo.this.existsBlock((String)objectArray[0]));
            }
        });
    }

    public void getBlockingUsersAsync(WeiboListener weiboListener) throws WeiboException {
        this.getDispatcher().invokeLater(new AsyncTask(49, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotBlockingUsers(AsyncWeibo.this.getBlockingUsers());
            }
        });
    }

    public void getBlockingUsersAsync(int n, WeiboListener weiboListener) throws WeiboException {
        this.getDispatcher().invokeLater(new AsyncTask(49, weiboListener, new Integer[]{n}){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotBlockingUsers(AsyncWeibo.this.getBlockingUsers((Integer)objectArray[0]));
            }
        });
    }

    public void getBlockingUsersIDsAsync(WeiboListener weiboListener) throws WeiboException {
        this.getDispatcher().invokeLater(new AsyncTask(50, weiboListener, null){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.gotBlockingUsersIDs(AsyncWeibo.this.getBlockingUsersIDs());
            }
        });
    }

    public void testAsync() {
        this.getDispatcher().invokeLater(new AsyncTask(24, new WeiboAdapter(), new Object[0]){

            @Override
            public void invoke(WeiboListener weiboListener, Object[] objectArray) throws WeiboException {
                weiboListener.tested(AsyncWeibo.this.test());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Class<AsyncWeibo> clazz = AsyncWeibo.class;
        synchronized (AsyncWeibo.class) {
            this.shutdown = true;
            if (true) {
                throw new IllegalStateException("Already shut down");
            }
            this.getDispatcher().shutdown();
            dispatcher = null;
            this.shutdown = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private Dispatcher getDispatcher() {
        if (this.shutdown) {
            throw new IllegalStateException("Already shut down");
        }
        if (null == dispatcher) {
            dispatcher = new Dispatcher("Weibo4J Async Dispatcher", Configuration.getNumberOfAsyncThreads());
        }
        return dispatcher;
    }

    public void getDowntimeScheduleAsync() {
        throw new RuntimeException("this method is not supported by the Weibo API anymore", new NoSuchMethodException("this method is not supported by the Weibo API anymore"));
    }

    public void getAuthenticatedUserAsync(WeiboListener weiboListener) {
        if (null == this.getUserId()) {
            throw new IllegalStateException("User Id not specified.");
        }
        this.getUserDetailAsync(this.getUserId(), weiboListener);
    }

    abstract class AsyncTask
    implements Runnable {
        WeiboListener listener;
        Object[] args;
        int method;

        AsyncTask(int n, WeiboListener weiboListener, Object[] objectArray) {
            this.method = n;
            this.listener = weiboListener;
            this.args = objectArray;
        }

        abstract void invoke(WeiboListener var1, Object[] var2) throws WeiboException;

        @Override
        public void run() {
            block2: {
                try {
                    this.invoke(this.listener, this.args);
                }
                catch (WeiboException weiboException) {
                    if (null == this.listener) break block2;
                    this.listener.onException(weiboException, this.method);
                }
            }
        }
    }
}

