/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weibo4j.User;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class DirectMessage
extends WeiboResponse
implements Serializable {
    private int id;
    private String text;
    private int sender_id;
    private int recipient_id;
    private Date created_at;
    private String sender_screen_name;
    private String recipient_screen_name;
    private static final long serialVersionUID = -3253021825891789737L;
    private User sender;
    private User recipient;

    DirectMessage(Response response, Weibo weibo) throws WeiboException {
        super(response);
        this.init(response, response.asDocument().getDocumentElement(), weibo);
    }

    DirectMessage(Response response, Element element, Weibo weibo) throws WeiboException {
        super(response);
        this.init(response, element, weibo);
    }

    DirectMessage(JSONObject jSONObject) throws WeiboException {
        try {
            this.id = jSONObject.getInt("id");
            this.text = jSONObject.getString("text");
            this.sender_id = jSONObject.getInt("sender_id");
            this.recipient_id = jSONObject.getInt("recipient_id");
            this.created_at = DirectMessage.parseDate(jSONObject.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.sender_screen_name = jSONObject.getString("sender_screen_name");
            this.recipient_screen_name = jSONObject.getString("recipient_screen_name");
            if (!jSONObject.isNull("sender")) {
                this.sender = new User(jSONObject.getJSONObject("sender"));
            }
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    private void init(Response response, Element element, Weibo weibo) throws WeiboException {
        DirectMessage.ensureRootNodeNameIs("direct_message", element);
        this.sender = new User(response, (Element)element.getElementsByTagName("sender").item(0), weibo);
        this.recipient = new User(response, (Element)element.getElementsByTagName("recipient").item(0), weibo);
        this.id = DirectMessage.getChildInt("id", element);
        this.text = DirectMessage.getChildText("text", element);
        this.sender_id = DirectMessage.getChildInt("sender_id", element);
        this.recipient_id = DirectMessage.getChildInt("recipient_id", element);
        this.created_at = DirectMessage.getChildDate("created_at", element);
        this.sender_screen_name = DirectMessage.getChildText("sender_screen_name", element);
        this.recipient_screen_name = DirectMessage.getChildText("recipient_screen_name", element);
    }

    public int getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public int getSenderId() {
        return this.sender_id;
    }

    public int getRecipientId() {
        return this.recipient_id;
    }

    public Date getCreatedAt() {
        return this.created_at;
    }

    public String getSenderScreenName() {
        return this.sender_screen_name;
    }

    public String getRecipientScreenName() {
        return this.recipient_screen_name;
    }

    public User getSender() {
        return this.sender;
    }

    public User getRecipient() {
        return this.recipient;
    }

    static List<DirectMessage> constructDirectMessages(Response response, Weibo weibo) throws WeiboException {
        Document document = response.asDocument();
        if (DirectMessage.isRootNodeNilClasses(document)) {
            return new ArrayList<DirectMessage>(0);
        }
        try {
            DirectMessage.ensureRootNodeNameIs("direct-messages", document);
            NodeList nodeList = document.getDocumentElement().getElementsByTagName("direct_message");
            int n = nodeList.getLength();
            ArrayList<DirectMessage> arrayList = new ArrayList<DirectMessage>(n);
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                arrayList.add(new DirectMessage(response, element, weibo));
            }
            return arrayList;
        }
        catch (WeiboException weiboException) {
            if (DirectMessage.isRootNodeNilClasses(document)) {
                return new ArrayList<DirectMessage>(0);
            }
            throw weiboException;
        }
    }

    static List<DirectMessage> constructDirectMessages(Response response) throws WeiboException {
        JSONArray jSONArray = response.asJSONArray();
        try {
            int n = jSONArray.length();
            ArrayList<DirectMessage> arrayList = new ArrayList<DirectMessage>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new DirectMessage(jSONArray.getJSONObject(i)));
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException);
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return object instanceof DirectMessage && ((DirectMessage)object).id == this.id;
    }

    public String toString() {
        return "DirectMessage{id=" + this.id + ", text='" + this.text + '\'' + ", sender_id=" + this.sender_id + ", recipient_id=" + this.recipient_id + ", created_at=" + this.created_at + ", sender_screen_name='" + this.sender_screen_name + '\'' + ", recipient_screen_name='" + this.recipient_screen_name + '\'' + ", sender=" + this.sender + ", recipient=" + this.recipient + '}';
    }
}

