/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.LinkedList;
import java.util.List;
import weibo4j.ExecuteThread;

class Dispatcher {
    private ExecuteThread[] threads;
    private List<Runnable> q = new LinkedList<Runnable>();
    Object ticket = new Object();
    private boolean active = true;

    public Dispatcher(String string) {
        this(string, 1);
    }

    public Dispatcher(String string, int n) {
        this.threads = new ExecuteThread[n];
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new ExecuteThread(string, this, i);
            this.threads[i].setDaemon(true);
            this.threads[i].start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (Dispatcher.this.active) {
                    Dispatcher.this.shutdown();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void invokeLater(Runnable runnable) {
        Object object = this.q;
        synchronized (object) {
            this.q.add(runnable);
        }
        object = this.ticket;
        synchronized (object) {
            this.ticket.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable poll() {
        while (this.active) {
            Object object = this.q;
            synchronized (object) {
                Runnable runnable;
                if (this.q.size() > 0 && null != (runnable = this.q.remove(0))) {
                    return runnable;
                }
            }
            object = this.ticket;
            synchronized (object) {
                try {
                    this.ticket.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this.active) {
            this.active = false;
            for (ExecuteThread executeThread : this.threads) {
                executeThread.shutdown();
            }
            Object object = this.ticket;
            synchronized (object) {
                this.ticket.notify();
            }
        } else {
            throw new IllegalStateException("Already shutdown");
        }
    }
}

