/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.ArrayList;
import java.util.List;
import weibo4j.http.PostParameter;

public class Query {
    private String query = null;
    private String lang = null;
    private int rpp = -1;
    private int page = -1;
    private long sinceId = -1L;
    private String geocode = null;
    public static final String MILES = "mi";
    public static final String KILOMETERS = "km";

    public Query() {
    }

    public Query(String string) {
        this.query = string;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String string) {
        this.lang = string;
    }

    public int getRpp() {
        return this.rpp;
    }

    public void setRpp(int n) {
        this.rpp = n;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int n) {
        this.page = n;
    }

    public long getSinceId() {
        return this.sinceId;
    }

    public void setSinceId(long l) {
        this.sinceId = l;
    }

    public String getGeocode() {
        return this.geocode;
    }

    public void setGeoCode(double d, double d2, double d3, String string) {
        this.geocode = d + "," + d2 + "," + d3 + string;
    }

    public PostParameter[] asPostParameters() {
        ArrayList<PostParameter> arrayList = new ArrayList<PostParameter>();
        this.appendParameter("q", this.query, arrayList);
        this.appendParameter("lang", this.lang, arrayList);
        this.appendParameter("rpp", this.rpp, arrayList);
        this.appendParameter("page", this.page, arrayList);
        this.appendParameter("since_id", this.sinceId, arrayList);
        this.appendParameter("geocode", this.geocode, arrayList);
        PostParameter[] postParameterArray = new PostParameter[arrayList.size()];
        return arrayList.toArray(postParameterArray);
    }

    private void appendParameter(String string, String string2, List<PostParameter> list) {
        if (null != string2) {
            list.add(new PostParameter(string, string2));
        }
    }

    private void appendParameter(String string, long l, List<PostParameter> list) {
        if (0L <= l) {
            list.add(new PostParameter(string, String.valueOf(l)));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Query query = (Query)object;
        if (this.page != query.page) {
            return false;
        }
        if (this.rpp != query.rpp) {
            return false;
        }
        if (this.sinceId != query.sinceId) {
            return false;
        }
        if (this.geocode != null ? !this.geocode.equals(query.geocode) : query.geocode != null) {
            return false;
        }
        if (this.lang != null ? !this.lang.equals(query.lang) : query.lang != null) {
            return false;
        }
        return !(this.query != null ? !this.query.equals(query.query) : query.query != null);
    }

    public int hashCode() {
        int n = this.query != null ? this.query.hashCode() : 0;
        n = 31 * n + (this.lang != null ? this.lang.hashCode() : 0);
        n = 31 * n + this.rpp;
        n = 31 * n + this.page;
        n = 31 * n + (int)(this.sinceId ^ this.sinceId >>> 32);
        n = 31 * n + (this.geocode != null ? this.geocode.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "Query{query='" + this.query + '\'' + ", lang='" + this.lang + '\'' + ", rpp=" + this.rpp + ", page=" + this.page + ", sinceId=" + this.sinceId + ", geocode='" + this.geocode + '\'' + '}';
    }
}

