/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.ArrayList;
import java.util.List;
import weibo4j.Query;
import weibo4j.Tweet;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.WeiboSupport;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class QueryResult
extends WeiboResponse {
    private long sinceId;
    private long maxId;
    private String refreshUrl;
    private int resultsPerPage;
    private int total = -1;
    private String warning;
    private double completedIn;
    private int page;
    private String query;
    private List<Tweet> tweets;
    private static final long serialVersionUID = -9059136565234613286L;

    QueryResult(Response response, WeiboSupport weiboSupport) throws WeiboException {
        super(response);
        JSONObject jSONObject = response.asJSONObject();
        try {
            this.sinceId = jSONObject.getLong("since_id");
            this.maxId = jSONObject.getLong("max_id");
            this.refreshUrl = QueryResult.getString("refresh_url", jSONObject, true);
            this.resultsPerPage = jSONObject.getInt("results_per_page");
            this.warning = QueryResult.getString("warning", jSONObject, false);
            this.completedIn = jSONObject.getDouble("completed_in");
            this.page = jSONObject.getInt("page");
            this.query = QueryResult.getString("query", jSONObject, true);
            JSONArray jSONArray = jSONObject.getJSONArray("results");
            this.tweets = new ArrayList<Tweet>(jSONArray.length());
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                this.tweets.add(new Tweet(jSONObject2, weiboSupport));
            }
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    QueryResult(Query query) throws WeiboException {
        this.sinceId = query.getSinceId();
        this.resultsPerPage = query.getRpp();
        this.page = query.getPage();
        this.tweets = new ArrayList<Tweet>(0);
    }

    public long getSinceId() {
        return this.sinceId;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public int getResultsPerPage() {
        return this.resultsPerPage;
    }

    public int getTotal() {
        return this.total;
    }

    public String getWarning() {
        return this.warning;
    }

    public double getCompletedIn() {
        return this.completedIn;
    }

    public int getPage() {
        return this.page;
    }

    public String getQuery() {
        return this.query;
    }

    public List<Tweet> getTweets() {
        return this.tweets;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        QueryResult queryResult = (QueryResult)object;
        if (Double.compare(queryResult.completedIn, this.completedIn) != 0) {
            return false;
        }
        if (this.maxId != queryResult.maxId) {
            return false;
        }
        if (this.page != queryResult.page) {
            return false;
        }
        if (this.resultsPerPage != queryResult.resultsPerPage) {
            return false;
        }
        if (this.sinceId != queryResult.sinceId) {
            return false;
        }
        if (this.total != queryResult.total) {
            return false;
        }
        if (!this.query.equals(queryResult.query)) {
            return false;
        }
        if (this.refreshUrl != null ? !this.refreshUrl.equals(queryResult.refreshUrl) : queryResult.refreshUrl != null) {
            return false;
        }
        if (this.tweets != null ? !((Object)this.tweets).equals(queryResult.tweets) : queryResult.tweets != null) {
            return false;
        }
        return !(this.warning != null ? !this.warning.equals(queryResult.warning) : queryResult.warning != null);
    }

    public int hashCode() {
        int n = (int)(this.sinceId ^ this.sinceId >>> 32);
        n = 31 * n + (int)(this.maxId ^ this.maxId >>> 32);
        n = 31 * n + (this.refreshUrl != null ? this.refreshUrl.hashCode() : 0);
        n = 31 * n + this.resultsPerPage;
        n = 31 * n + this.total;
        n = 31 * n + (this.warning != null ? this.warning.hashCode() : 0);
        long l = this.completedIn != 0.0 ? Double.doubleToLongBits(this.completedIn) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + this.page;
        n = 31 * n + this.query.hashCode();
        n = 31 * n + (this.tweets != null ? ((Object)this.tweets).hashCode() : 0);
        return n;
    }

    public String toString() {
        return "QueryResult{sinceId=" + this.sinceId + ", maxId=" + this.maxId + ", refreshUrl='" + this.refreshUrl + '\'' + ", resultsPerPage=" + this.resultsPerPage + ", total=" + this.total + ", warning='" + this.warning + '\'' + ", completedIn=" + this.completedIn + ", page=" + this.page + ", query='" + this.query + '\'' + ", tweets=" + this.tweets + '}';
    }
}

