/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weibo4j.User;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class RetweetDetails
extends WeiboResponse
implements Serializable {
    private long retweetId;
    private Date retweetedAt;
    private User retweetingUser;
    static final long serialVersionUID = 1957982268696560598L;

    RetweetDetails(Response response, Weibo weibo) throws WeiboException {
        super(response);
        Element element = response.asDocument().getDocumentElement();
        this.init(response, element, weibo);
    }

    RetweetDetails(JSONObject jSONObject) throws WeiboException {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) throws WeiboException {
        try {
            this.retweetId = jSONObject.getInt("retweetId");
            this.retweetedAt = RetweetDetails.parseDate(jSONObject.getString("retweetedAt"), "EEE MMM dd HH:mm:ss z yyyy");
            this.retweetingUser = new User(jSONObject.getJSONObject("retweetingUser"));
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    RetweetDetails(Response response, Element element, Weibo weibo) throws WeiboException {
        super(response);
        this.init(response, element, weibo);
    }

    private void init(Response response, Element element, Weibo weibo) throws WeiboException {
        RetweetDetails.ensureRootNodeNameIs("retweet_details", element);
        this.retweetId = RetweetDetails.getChildLong("retweet_id", element);
        this.retweetedAt = RetweetDetails.getChildDate("retweeted_at", element);
        this.retweetingUser = new User(response, (Element)element.getElementsByTagName("retweeting_user").item(0), weibo);
    }

    public long getRetweetId() {
        return this.retweetId;
    }

    public Date getRetweetedAt() {
        return this.retweetedAt;
    }

    public User getRetweetingUser() {
        return this.retweetingUser;
    }

    static List<RetweetDetails> createRetweetDetails(Response response) throws WeiboException {
        try {
            JSONArray jSONArray = response.asJSONArray();
            int n = jSONArray.length();
            ArrayList<RetweetDetails> arrayList = new ArrayList<RetweetDetails>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new RetweetDetails(jSONArray.getJSONObject(i)));
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException);
        }
        catch (WeiboException weiboException) {
            throw weiboException;
        }
    }

    static List<RetweetDetails> createRetweetDetails(Response response, Weibo weibo) throws WeiboException {
        Document document = response.asDocument();
        if (RetweetDetails.isRootNodeNilClasses(document)) {
            return new ArrayList<RetweetDetails>(0);
        }
        try {
            RetweetDetails.ensureRootNodeNameIs("retweets", document);
            NodeList nodeList = document.getDocumentElement().getElementsByTagName("retweet_details");
            int n = nodeList.getLength();
            ArrayList<RetweetDetails> arrayList = new ArrayList<RetweetDetails>(n);
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                arrayList.add(new RetweetDetails(response, element, weibo));
            }
            return arrayList;
        }
        catch (WeiboException weiboException) {
            RetweetDetails.ensureRootNodeNameIs("nil-classes", document);
            return new ArrayList<RetweetDetails>(0);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RetweetDetails)) {
            return false;
        }
        RetweetDetails retweetDetails = (RetweetDetails)object;
        return this.retweetId == retweetDetails.retweetId;
    }

    public int hashCode() {
        int n = (int)(this.retweetId ^ this.retweetId >>> 32);
        n = 31 * n + this.retweetedAt.hashCode();
        n = 31 * n + this.retweetingUser.hashCode();
        return n;
    }

    public String toString() {
        return "RetweetDetails{retweetId=" + this.retweetId + ", retweetedAt=" + this.retweetedAt + ", retweetingUser=" + this.retweetingUser + '}';
    }
}

