/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class SavedSearch
extends WeiboResponse {
    private Date createdAt;
    private String query;
    private int position;
    private String name;
    private int id;
    private static final long serialVersionUID = 3083819860391598212L;

    SavedSearch(Response response) throws WeiboException {
        super(response);
        this.init(response.asJSONObject());
    }

    SavedSearch(Response response, JSONObject jSONObject) throws WeiboException {
        super(response);
        this.init(jSONObject);
    }

    SavedSearch(JSONObject jSONObject) throws WeiboException {
        this.init(jSONObject);
    }

    static List<SavedSearch> constructSavedSearches(Response response) throws WeiboException {
        JSONArray jSONArray = response.asJSONArray();
        try {
            ArrayList<SavedSearch> arrayList = new ArrayList<SavedSearch>(jSONArray.length());
            for (int i = 0; i < jSONArray.length(); ++i) {
                arrayList.add(new SavedSearch(response, jSONArray.getJSONObject(i)));
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException.getMessage() + ":" + response.asString(), jSONException);
        }
    }

    private void init(JSONObject jSONObject) throws WeiboException {
        try {
            this.createdAt = SavedSearch.parseDate(jSONObject.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.query = SavedSearch.getString("query", jSONObject, true);
            this.position = SavedSearch.getInt("position", jSONObject);
            this.name = SavedSearch.getString("name", jSONObject, true);
            this.id = SavedSearch.getInt("id", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getQuery() {
        return this.query;
    }

    public int getPosition() {
        return this.position;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SavedSearch)) {
            return false;
        }
        SavedSearch savedSearch = (SavedSearch)object;
        if (this.id != savedSearch.id) {
            return false;
        }
        if (this.position != savedSearch.position) {
            return false;
        }
        if (!this.createdAt.equals(savedSearch.createdAt)) {
            return false;
        }
        if (!this.name.equals(savedSearch.name)) {
            return false;
        }
        return this.query.equals(savedSearch.query);
    }

    public int hashCode() {
        int n = this.createdAt.hashCode();
        n = 31 * n + this.query.hashCode();
        n = 31 * n + this.position;
        n = 31 * n + this.name.hashCode();
        n = 31 * n + this.id;
        return n;
    }

    public String toString() {
        return "SavedSearch{createdAt=" + this.createdAt + ", query='" + this.query + '\'' + ", position=" + this.position + ", name='" + this.name + '\'' + ", id=" + this.id + '}';
    }
}

