/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weibo4j.RetweetDetails;
import weibo4j.User;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Status
extends WeiboResponse
implements Serializable {
    private Date createdAt;
    private long id;
    private String text;
    private String source;
    private boolean isTruncated;
    private long inReplyToStatusId;
    private int inReplyToUserId;
    private boolean isFavorited;
    private String inReplyToScreenName;
    private double latitude = -1.0;
    private double longitude = -1.0;
    private String thumbnail_pic;
    private String bmiddle_pic;
    private String original_pic;
    private RetweetDetails retweetDetails;
    private static final long serialVersionUID = 1608000492860584608L;
    private User user = null;

    Status(Response response, Weibo weibo) throws WeiboException {
        super(response);
        Element element = response.asDocument().getDocumentElement();
        this.init(response, element, weibo);
    }

    Status(Response response, Element element, Weibo weibo) throws WeiboException {
        super(response);
        this.init(response, element, weibo);
    }

    Status(Response response) throws WeiboException {
        super(response);
        JSONObject jSONObject = response.asJSONObject();
        try {
            this.id = jSONObject.getLong("id");
            this.text = jSONObject.getString("text");
            this.source = jSONObject.getString("source");
            this.createdAt = Status.parseDate(jSONObject.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.inReplyToStatusId = Status.getLong("in_reply_to_status_id", jSONObject);
            this.inReplyToUserId = Status.getInt("in_reply_to_user_id", jSONObject);
            this.isFavorited = Status.getBoolean("favorited", jSONObject);
            this.thumbnail_pic = jSONObject.getString("thumbnail_pic");
            this.bmiddle_pic = jSONObject.getString("bmiddle_pic");
            this.original_pic = jSONObject.getString("original_pic");
            if (!jSONObject.isNull("user")) {
                this.user = new User(jSONObject.getJSONObject("user"));
            }
            this.inReplyToScreenName = jSONObject.getString("inReplyToScreenName");
            if (!jSONObject.isNull("retweetDetails")) {
                this.retweetDetails = new RetweetDetails(jSONObject.getJSONObject("retweetDetails"));
            }
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    public Status(JSONObject jSONObject) throws WeiboException, JSONException {
        this.id = jSONObject.getLong("id");
        this.text = jSONObject.getString("text");
        this.source = jSONObject.getString("source");
        this.createdAt = Status.parseDate(jSONObject.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        this.isFavorited = Status.getBoolean("favorited", jSONObject);
        this.isTruncated = Status.getBoolean("truncated", jSONObject);
        this.inReplyToStatusId = Status.getLong("in_reply_to_status_id", jSONObject);
        this.inReplyToUserId = Status.getInt("in_reply_to_user_id", jSONObject);
        this.inReplyToScreenName = jSONObject.getString("in_reply_to_screen_name");
        this.thumbnail_pic = jSONObject.getString("thumbnail_pic");
        this.bmiddle_pic = jSONObject.getString("bmiddle_pic");
        this.original_pic = jSONObject.getString("original_pic");
        this.user = new User(jSONObject.getJSONObject("user"));
    }

    public Status(String string) throws WeiboException, JSONException {
        JSONObject jSONObject = new JSONObject(string);
        this.id = jSONObject.getLong("id");
        this.text = jSONObject.getString("text");
        this.source = jSONObject.getString("source");
        this.createdAt = Status.parseDate(jSONObject.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        this.inReplyToStatusId = Status.getLong("in_reply_to_status_id", jSONObject);
        this.inReplyToUserId = Status.getInt("in_reply_to_user_id", jSONObject);
        this.isFavorited = Status.getBoolean("favorited", jSONObject);
        this.thumbnail_pic = jSONObject.getString("thumbnail_pic");
        this.bmiddle_pic = jSONObject.getString("bmiddle_pic");
        this.original_pic = jSONObject.getString("original_pic");
        this.user = new User(jSONObject.getJSONObject("user"));
    }

    private void init(Response response, Element element, Weibo weibo) throws WeiboException {
        String[] stringArray;
        Status.ensureRootNodeNameIs("status", element);
        this.user = new User(response, (Element)element.getElementsByTagName("user").item(0), weibo);
        this.id = Status.getChildLong("id", element);
        this.text = Status.getChildText("text", element);
        this.source = Status.getChildText("source", element);
        this.createdAt = Status.getChildDate("created_at", element);
        this.isTruncated = Status.getChildBoolean("truncated", element);
        this.inReplyToStatusId = Status.getChildLong("in_reply_to_status_id", element);
        this.inReplyToUserId = Status.getChildInt("in_reply_to_user_id", element);
        this.isFavorited = Status.getChildBoolean("favorited", element);
        this.inReplyToScreenName = Status.getChildText("in_reply_to_screen_name", element);
        NodeList nodeList = element.getElementsByTagName("georss:point");
        if (1 == nodeList.getLength()) {
            stringArray = nodeList.item(0).getFirstChild().getNodeValue().split(" ");
            if (!"null".equals(stringArray[0])) {
                this.latitude = Double.parseDouble(stringArray[0]);
            }
            if (!"null".equals(stringArray[1])) {
                this.longitude = Double.parseDouble(stringArray[1]);
            }
        }
        if (1 == (stringArray = element.getElementsByTagName("retweet_details")).getLength()) {
            this.retweetDetails = new RetweetDetails(response, (Element)stringArray.item(0), weibo);
        }
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public long getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public int getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean isFavorited() {
        return this.isFavorited;
    }

    public String getThumbnail_pic() {
        return this.thumbnail_pic;
    }

    public String getBmiddle_pic() {
        return this.bmiddle_pic;
    }

    public String getOriginal_pic() {
        return this.original_pic;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isRetweet() {
        return null != this.retweetDetails;
    }

    public RetweetDetails getRetweetDetails() {
        return this.retweetDetails;
    }

    static List<Status> constructStatuses(Response response, Weibo weibo) throws WeiboException {
        Document document = response.asDocument();
        if (Status.isRootNodeNilClasses(document)) {
            return new ArrayList<Status>(0);
        }
        try {
            Status.ensureRootNodeNameIs("statuses", document);
            NodeList nodeList = document.getDocumentElement().getElementsByTagName("status");
            int n = nodeList.getLength();
            ArrayList<Status> arrayList = new ArrayList<Status>(n);
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                arrayList.add(new Status(response, element, weibo));
            }
            return arrayList;
        }
        catch (WeiboException weiboException) {
            Status.ensureRootNodeNameIs("nil-classes", document);
            return new ArrayList<Status>(0);
        }
    }

    static List<Status> constructStatuses(Response response) throws WeiboException {
        try {
            JSONArray jSONArray = response.asJSONArray();
            int n = jSONArray.length();
            ArrayList<Status> arrayList = new ArrayList<Status>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new Status(jSONArray.getJSONObject(i)));
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException);
        }
        catch (WeiboException weiboException) {
            throw weiboException;
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return object instanceof Status && ((Status)object).id == this.id;
    }

    public String toString() {
        return "Status{createdAt=" + this.createdAt + ", id=" + this.id + ", text='" + this.text + '\'' + ", source='" + this.source + '\'' + ", isTruncated=" + this.isTruncated + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", isFavorited=" + this.isFavorited + ", thumbnail_pic=" + this.thumbnail_pic + ", bmiddle_pic=" + this.bmiddle_pic + ", original_pic=" + this.original_pic + ", inReplyToScreenName='" + this.inReplyToScreenName + '\'' + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", retweetDetails=" + this.retweetDetails + ", user=" + this.user + '}';
    }
}

