/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import weibo4j.Status;
import weibo4j.WeiboException;
import weibo4j.http.Response;
import weibo4j.org.json.JSONException;

public class StatusStream {
    private boolean streamAlive = true;
    private BufferedReader br;
    private InputStream is;
    private Response response;

    StatusStream(InputStream inputStream) throws IOException {
        this.is = inputStream;
        this.br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
    }

    StatusStream(Response response) throws IOException {
        this(response.asStream());
        this.response = response;
    }

    public Status next() throws WeiboException {
        if (!this.streamAlive) {
            throw new IllegalStateException("Stream already closed.");
        }
        try {
            while (this.streamAlive) {
                String string = this.br.readLine();
                if (null == string || string.length() <= 0) continue;
                try {
                    return new Status(string);
                }
                catch (JSONException jSONException) {
                }
            }
            throw new WeiboException("Stream closed.");
        }
        catch (IOException iOException) {
            try {
                this.is.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            this.streamAlive = false;
            throw new WeiboException("Stream closed.", iOException);
        }
    }

    public void close() throws IOException {
        this.is.close();
        this.br.close();
        if (null != this.response) {
            this.response.disconnect();
        }
    }
}

