/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import weibo4j.Trend;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Trends
extends WeiboResponse
implements Comparable<Trends> {
    private Date asOf;
    private Date trendAt;
    private Trend[] trends;
    private static final long serialVersionUID = -7151479143843312309L;

    @Override
    public int compareTo(Trends trends) {
        return this.trendAt.compareTo(trends.trendAt);
    }

    Trends(Response response, Date date, Date date2, Trend[] trendArray) throws WeiboException {
        super(response);
        this.asOf = date;
        this.trendAt = date2;
        this.trends = trendArray;
    }

    static List<Trends> constructTrendsList(Response response) throws WeiboException {
        JSONObject jSONObject = response.asJSONObject();
        try {
            Date date = Trends.parseDate(jSONObject.getString("as_of"));
            JSONObject jSONObject2 = jSONObject.getJSONObject("trends");
            ArrayList<Trends> arrayList = new ArrayList<Trends>(jSONObject2.length());
            Iterator iterator = jSONObject2.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                JSONArray jSONArray = jSONObject2.getJSONArray(string);
                Trend[] trendArray = Trends.jsonArrayToTrendArray(jSONArray);
                if (string.length() == 19) {
                    arrayList.add(new Trends(response, date, Trends.parseDate(string, "yyyy-MM-dd HH:mm:ss"), trendArray));
                    continue;
                }
                if (string.length() == 16) {
                    arrayList.add(new Trends(response, date, Trends.parseDate(string, "yyyy-MM-dd HH:mm"), trendArray));
                    continue;
                }
                if (string.length() != 10) continue;
                arrayList.add(new Trends(response, date, Trends.parseDate(string, "yyyy-MM-dd"), trendArray));
            }
            Collections.sort(arrayList);
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException.getMessage() + ":" + response.asString(), jSONException);
        }
    }

    static Trends constructTrends(Response response) throws WeiboException {
        JSONObject jSONObject = response.asJSONObject();
        try {
            Date date = Trends.parseDate(jSONObject.getString("as_of"));
            JSONArray jSONArray = jSONObject.getJSONArray("trends");
            Trend[] trendArray = Trends.jsonArrayToTrendArray(jSONArray);
            return new Trends(response, date, date, trendArray);
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException.getMessage() + ":" + response.asString(), jSONException);
        }
    }

    private static Date parseDate(String string) throws WeiboException {
        Date date = string.length() == 10 ? new Date(Long.parseLong(string) * 1000L) : WeiboResponse.parseDate(string, "EEE, d MMM yyyy HH:mm:ss z");
        return date;
    }

    private static Trend[] jsonArrayToTrendArray(JSONArray jSONArray) throws JSONException {
        Trend[] trendArray = new Trend[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            trendArray[i] = new Trend(jSONObject);
        }
        return trendArray;
    }

    public Trend[] getTrends() {
        return this.trends;
    }

    public Date getAsOf() {
        return this.asOf;
    }

    public Date getTrendAt() {
        return this.trendAt;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Trends)) {
            return false;
        }
        Trends trends = (Trends)object;
        if (this.asOf != null ? !this.asOf.equals(trends.asOf) : trends.asOf != null) {
            return false;
        }
        if (this.trendAt != null ? !this.trendAt.equals(trends.trendAt) : trends.trendAt != null) {
            return false;
        }
        return Arrays.equals(this.trends, trends.trends);
    }

    public int hashCode() {
        int n = this.asOf != null ? this.asOf.hashCode() : 0;
        n = 31 * n + (this.trendAt != null ? this.trendAt.hashCode() : 0);
        n = 31 * n + (this.trends != null ? Arrays.hashCode(this.trends) : 0);
        return n;
    }

    public String toString() {
        return "Trends{asOf=" + this.asOf + ", trendAt=" + this.trendAt + ", trends=" + (this.trends == null ? null : Arrays.asList(this.trends)) + '}';
    }
}

