/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.Date;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.WeiboSupport;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Tweet
extends WeiboResponse {
    private String text;
    private int toUserId = -1;
    private String toUser = null;
    private String fromUser;
    private long id;
    private int fromUserId;
    private String isoLanguageCode = null;
    private String source;
    private String profileImageUrl;
    private Date createdAt;
    private static final long serialVersionUID = 4299736733993211587L;

    Tweet(JSONObject jSONObject, WeiboSupport weiboSupport) throws WeiboException {
        try {
            this.text = Tweet.getString("text", jSONObject, false);
            try {
                this.toUserId = jSONObject.getInt("to_user_id");
                this.toUser = jSONObject.getString("to_user");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.fromUser = jSONObject.getString("from_user");
            this.id = jSONObject.getLong("id");
            this.fromUserId = jSONObject.getInt("from_user_id");
            try {
                this.isoLanguageCode = jSONObject.getString("iso_language_code");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.source = Tweet.getString("source", jSONObject, true);
            this.profileImageUrl = Tweet.getString("profile_image_url", jSONObject, true);
            this.createdAt = Tweet.parseDate(jSONObject.getString("created_at"), "EEE, dd MMM yyyy HH:mm:ss z");
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    public String getText() {
        return this.text;
    }

    public int getToUserId() {
        return this.toUserId;
    }

    public String getToUser() {
        return this.toUser;
    }

    public String getFromUser() {
        return this.fromUser;
    }

    public long getId() {
        return this.id;
    }

    public int getFromUserId() {
        return this.fromUserId;
    }

    public String getIsoLanguageCode() {
        return this.isoLanguageCode;
    }

    public String getSource() {
        return this.source;
    }

    public String getProfileImageUrl() {
        return this.profileImageUrl;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Tweet tweet = (Tweet)object;
        if (this.fromUserId != tweet.fromUserId) {
            return false;
        }
        if (this.id != tweet.id) {
            return false;
        }
        if (this.toUserId != tweet.toUserId) {
            return false;
        }
        if (this.createdAt != null ? !this.createdAt.equals(tweet.createdAt) : tweet.createdAt != null) {
            return false;
        }
        if (this.fromUser != null ? !this.fromUser.equals(tweet.fromUser) : tweet.fromUser != null) {
            return false;
        }
        if (this.isoLanguageCode != null ? !this.isoLanguageCode.equals(tweet.isoLanguageCode) : tweet.isoLanguageCode != null) {
            return false;
        }
        if (this.profileImageUrl != null ? !this.profileImageUrl.equals(tweet.profileImageUrl) : tweet.profileImageUrl != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(tweet.source) : tweet.source != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(tweet.text) : tweet.text != null) {
            return false;
        }
        return !(this.toUser != null ? !this.toUser.equals(tweet.toUser) : tweet.toUser != null);
    }

    public int hashCode() {
        int n = this.text != null ? this.text.hashCode() : 0;
        n = 31 * n + (this.toUserId ^ this.toUserId >>> 32);
        n = 31 * n + (this.toUser != null ? this.toUser.hashCode() : 0);
        n = 31 * n + (this.fromUser != null ? this.fromUser.hashCode() : 0);
        n = 31 * n + (int)(this.id ^ this.id >>> 32);
        n = 31 * n + (this.fromUserId ^ this.fromUserId >>> 32);
        n = 31 * n + (this.isoLanguageCode != null ? this.isoLanguageCode.hashCode() : 0);
        n = 31 * n + (this.source != null ? this.source.hashCode() : 0);
        n = 31 * n + (this.profileImageUrl != null ? this.profileImageUrl.hashCode() : 0);
        n = 31 * n + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "Tweet{text='" + this.text + '\'' + ", toUserId=" + this.toUserId + ", toUser='" + this.toUser + '\'' + ", fromUser='" + this.fromUser + '\'' + ", id=" + this.id + ", fromUserId=" + this.fromUserId + ", isoLanguageCode='" + this.isoLanguageCode + '\'' + ", source='" + this.source + '\'' + ", profileImageUrl='" + this.profileImageUrl + '\'' + ", createdAt=" + this.createdAt + '}';
    }
}

