/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weibo4j.DirectMessage;
import weibo4j.UserWapper;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class User
extends WeiboResponse
implements Serializable {
    static final String[] POSSIBLE_ROOT_NAMES = new String[]{"user", "sender", "recipient", "retweeting_user"};
    private Weibo weibo;
    private int id;
    private String name;
    private String screenName;
    private String location;
    private String description;
    private String profileImageUrl;
    private String url;
    private boolean isProtected;
    private int followersCount;
    private Date statusCreatedAt;
    private long statusId = -1L;
    private String statusText = null;
    private String statusSource = null;
    private boolean statusTruncated = false;
    private long statusInReplyToStatusId = -1L;
    private int statusInReplyToUserId = -1;
    private boolean statusFavorited = false;
    private String statusInReplyToScreenName = null;
    private String profileBackgroundColor;
    private String profileTextColor;
    private String profileLinkColor;
    private String profileSidebarFillColor;
    private String profileSidebarBorderColor;
    private int friendsCount;
    private Date createdAt;
    private int favouritesCount;
    private int utcOffset;
    private String timeZone;
    private String profileBackgroundImageUrl;
    private String profileBackgroundTile;
    private boolean following;
    private boolean notificationEnabled;
    private int statusesCount;
    private boolean geoEnabled;
    private boolean verified;
    private String gender;
    private static final long serialVersionUID = -6345893237975349030L;

    User(Response response, Weibo weibo) throws WeiboException {
        super(response);
        Element element = response.asDocument().getDocumentElement();
        this.init(element, weibo);
    }

    User(Response response, Element element, Weibo weibo) throws WeiboException {
        super(response);
        this.init(element, weibo);
    }

    User(JSONObject jSONObject) throws WeiboException {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) throws WeiboException {
        try {
            this.id = jSONObject.getInt("id");
            this.name = jSONObject.getString("name");
            this.screenName = jSONObject.getString("screen_name");
            this.location = jSONObject.getString("location");
            this.description = jSONObject.getString("description");
            this.profileImageUrl = jSONObject.getString("profile_image_url");
            this.url = jSONObject.getString("url");
            this.isProtected = jSONObject.getBoolean("protected");
            this.followersCount = jSONObject.getInt("followers_count");
            this.gender = jSONObject.getString("gender");
            this.profileBackgroundColor = jSONObject.getString("profile_background_color");
            this.profileTextColor = jSONObject.getString("profile_text_color");
            this.profileLinkColor = jSONObject.getString("profile_link_color");
            this.profileSidebarFillColor = jSONObject.getString("profile_sidebar_fill_color");
            this.profileSidebarBorderColor = jSONObject.getString("profile_sidebar_border_color");
            this.friendsCount = jSONObject.getInt("friends_count");
            this.createdAt = User.parseDate(jSONObject.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.favouritesCount = jSONObject.getInt("favourites_count");
            this.utcOffset = User.getInt("utc_offset", jSONObject);
            this.timeZone = jSONObject.getString("time_zone");
            this.profileBackgroundImageUrl = jSONObject.getString("profile_background_image_url");
            this.profileBackgroundTile = jSONObject.getString("profile_background_tile");
            this.following = User.getBoolean("following", jSONObject);
            this.notificationEnabled = User.getBoolean("notifications", jSONObject);
            this.statusesCount = jSONObject.getInt("statuses_count");
            if (!jSONObject.isNull("status")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("status");
                this.statusCreatedAt = User.parseDate(jSONObject2.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
                this.statusId = jSONObject2.getLong("id");
                this.statusText = jSONObject2.getString("text");
                this.statusSource = jSONObject2.getString("source");
                this.statusTruncated = jSONObject2.getBoolean("truncated");
                this.statusInReplyToStatusId = jSONObject2.getLong("in_reply_to_status_id");
                this.statusInReplyToUserId = jSONObject2.getInt("in_reply_to_user_id");
                this.statusFavorited = jSONObject2.getBoolean("favorited");
                this.statusInReplyToScreenName = jSONObject2.getString("in_reply_to_screen_name");
            }
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    private void init(Element element, Weibo weibo) throws WeiboException {
        this.weibo = weibo;
        User.ensureRootNodeNameIs(POSSIBLE_ROOT_NAMES, element);
        this.id = User.getChildInt("id", element);
        this.name = User.getChildText("name", element);
        this.screenName = User.getChildText("screen_name", element);
        this.location = User.getChildText("location", element);
        this.description = User.getChildText("description", element);
        this.profileImageUrl = User.getChildText("profile_image_url", element);
        this.url = User.getChildText("url", element);
        this.isProtected = User.getChildBoolean("protected", element);
        this.followersCount = User.getChildInt("followers_count", element);
        this.profileBackgroundColor = User.getChildText("profile_background_color", element);
        this.profileTextColor = User.getChildText("profile_text_color", element);
        this.profileLinkColor = User.getChildText("profile_link_color", element);
        this.profileSidebarFillColor = User.getChildText("profile_sidebar_fill_color", element);
        this.profileSidebarBorderColor = User.getChildText("profile_sidebar_border_color", element);
        this.friendsCount = User.getChildInt("friends_count", element);
        this.createdAt = User.getChildDate("created_at", element);
        this.favouritesCount = User.getChildInt("favourites_count", element);
        this.utcOffset = User.getChildInt("utc_offset", element);
        this.timeZone = User.getChildText("time_zone", element);
        this.profileBackgroundImageUrl = User.getChildText("profile_background_image_url", element);
        this.profileBackgroundTile = User.getChildText("profile_background_tile", element);
        this.following = User.getChildBoolean("following", element);
        this.notificationEnabled = User.getChildBoolean("notifications", element);
        this.statusesCount = User.getChildInt("statuses_count", element);
        this.geoEnabled = User.getChildBoolean("geo_enabled", element);
        this.verified = User.getChildBoolean("verified", element);
        this.gender = User.getChildText("gender", element);
        NodeList nodeList = element.getElementsByTagName("status");
        if (nodeList.getLength() != 0) {
            Element element2 = (Element)nodeList.item(0);
            this.statusCreatedAt = User.getChildDate("created_at", element2);
            this.statusId = User.getChildLong("id", element2);
            this.statusText = User.getChildText("text", element2);
            this.statusSource = User.getChildText("source", element2);
            this.statusTruncated = User.getChildBoolean("truncated", element2);
            this.statusInReplyToStatusId = User.getChildLong("in_reply_to_status_id", element2);
            this.statusInReplyToUserId = User.getChildInt("in_reply_to_user_id", element2);
            this.statusFavorited = User.getChildBoolean("favorited", element2);
            this.statusInReplyToScreenName = User.getChildText("in_reply_to_screen_name", element2);
        }
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public URL getProfileImageURL() {
        try {
            return new URL(this.profileImageUrl);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public int getFollowersCount() {
        return this.followersCount;
    }

    public DirectMessage sendDirectMessage(String string) throws WeiboException {
        return this.weibo.sendDirectMessage(this.getName(), string);
    }

    public static List<User> constructUsers(Response response, Weibo weibo) throws WeiboException {
        Document document = response.asDocument();
        if (User.isRootNodeNilClasses(document)) {
            return new ArrayList<User>(0);
        }
        try {
            User.ensureRootNodeNameIs("users", document);
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            ArrayList<User> arrayList = new ArrayList<User>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("user")) continue;
                arrayList.add(new User(response, (Element)node, weibo));
            }
            return arrayList;
        }
        catch (WeiboException weiboException) {
            if (User.isRootNodeNilClasses(document)) {
                return new ArrayList<User>(0);
            }
            throw weiboException;
        }
    }

    public static UserWapper constructWapperUsers(Response response, Weibo weibo) throws WeiboException {
        Document document = response.asDocument();
        if (User.isRootNodeNilClasses(document)) {
            return new UserWapper(new ArrayList<User>(0), 0L, 0L);
        }
        try {
            User.ensureRootNodeNameIs("users_list", document);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("users");
            int n = nodeList.getLength();
            if (n == 0) {
                return new UserWapper(new ArrayList<User>(0), 0L, 0L);
            }
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getChildNodes();
            ArrayList<User> arrayList = new ArrayList<User>(nodeList2.getLength());
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                if (!node.getNodeName().equals("user")) continue;
                arrayList.add(new User(response, (Element)node, weibo));
            }
            long l = User.getChildLong("previous_curosr", element);
            long l2 = User.getChildLong("next_curosr", element);
            if (l2 == -1L) {
                l2 = User.getChildLong("nextCurosr", element);
            }
            return new UserWapper(arrayList, l, l2);
        }
        catch (WeiboException weiboException) {
            if (User.isRootNodeNilClasses(document)) {
                return new UserWapper(new ArrayList<User>(0), 0L, 0L);
            }
            throw weiboException;
        }
    }

    public static List<User> constructUsers(Response response) throws WeiboException {
        try {
            JSONArray jSONArray = response.asJSONArray();
            int n = jSONArray.length();
            ArrayList<User> arrayList = new ArrayList<User>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new User(jSONArray.getJSONObject(i)));
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException);
        }
        catch (WeiboException weiboException) {
            throw weiboException;
        }
    }

    public static UserWapper constructWapperUsers(Response response) throws WeiboException {
        JSONObject jSONObject = response.asJSONObject();
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("users");
            int n = jSONArray.length();
            ArrayList<User> arrayList = new ArrayList<User>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new User(jSONArray.getJSONObject(i)));
            }
            long l = jSONObject.getLong("previous_curosr");
            long l2 = jSONObject.getLong("next_cursor");
            if (l2 == -1L) {
                l2 = jSONObject.getLong("nextCursor");
            }
            return new UserWapper(arrayList, l, l2);
        }
        catch (JSONException jSONException) {
            throw new WeiboException(jSONException);
        }
    }

    static List<User> constructResult(Response response) throws WeiboException {
        JSONArray jSONArray = response.asJSONArray();
        try {
            int n = jSONArray.length();
            ArrayList<User> arrayList = new ArrayList<User>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new User(jSONArray.getJSONObject(i)));
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Date getStatusCreatedAt() {
        return this.statusCreatedAt;
    }

    public long getStatusId() {
        return this.statusId;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getStatusSource() {
        return this.statusSource;
    }

    public boolean isStatusTruncated() {
        return this.statusTruncated;
    }

    public long getStatusInReplyToStatusId() {
        return this.statusInReplyToStatusId;
    }

    public int getStatusInReplyToUserId() {
        return this.statusInReplyToUserId;
    }

    public boolean isStatusFavorited() {
        return this.statusFavorited;
    }

    public String getStatusInReplyToScreenName() {
        return -1 != this.statusInReplyToUserId ? this.statusInReplyToScreenName : null;
    }

    public String getProfileBackgroundColor() {
        return this.profileBackgroundColor;
    }

    public String getProfileTextColor() {
        return this.profileTextColor;
    }

    public String getProfileLinkColor() {
        return this.profileLinkColor;
    }

    public String getProfileSidebarFillColor() {
        return this.profileSidebarFillColor;
    }

    public String getProfileSidebarBorderColor() {
        return this.profileSidebarBorderColor;
    }

    public int getFriendsCount() {
        return this.friendsCount;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public int getFavouritesCount() {
        return this.favouritesCount;
    }

    public int getUtcOffset() {
        return this.utcOffset;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getProfileBackgroundImageUrl() {
        return this.profileBackgroundImageUrl;
    }

    public String getProfileBackgroundTile() {
        return this.profileBackgroundTile;
    }

    public boolean isFollowing() {
        return this.following;
    }

    public boolean isNotifications() {
        return this.notificationEnabled;
    }

    public boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    public int getStatusesCount() {
        return this.statusesCount;
    }

    public boolean isGeoEnabled() {
        return this.geoEnabled;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public String getGender() {
        return this.gender;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return object instanceof User && ((User)object).id == this.id;
    }

    public String toString() {
        return "User{weibo=" + this.weibo + ", id=" + this.id + ", name='" + this.name + '\'' + ", screenName='" + this.screenName + '\'' + ", location='" + this.location + '\'' + ", description='" + this.description + '\'' + ", profileImageUrl='" + this.profileImageUrl + '\'' + ", url='" + this.url + '\'' + ", isProtected=" + this.isProtected + ", followersCount=" + this.followersCount + ", statusCreatedAt=" + this.statusCreatedAt + ", statusId=" + this.statusId + ", statusText='" + this.statusText + '\'' + ", statusSource='" + this.statusSource + '\'' + ", statusTruncated=" + this.statusTruncated + ", statusInReplyToStatusId=" + this.statusInReplyToStatusId + ", statusInReplyToUserId=" + this.statusInReplyToUserId + ", statusFavorited=" + this.statusFavorited + ", statusInReplyToScreenName='" + this.statusInReplyToScreenName + '\'' + ", profileBackgroundColor='" + this.profileBackgroundColor + '\'' + ", profileTextColor='" + this.profileTextColor + '\'' + ", profileLinkColor='" + this.profileLinkColor + '\'' + ", profileSidebarFillColor='" + this.profileSidebarFillColor + '\'' + ", profileSidebarBorderColor='" + this.profileSidebarBorderColor + '\'' + ", friendsCount=" + this.friendsCount + ", createdAt=" + this.createdAt + ", favouritesCount=" + this.favouritesCount + ", utcOffset=" + this.utcOffset + ", timeZone='" + this.timeZone + '\'' + ", profileBackgroundImageUrl='" + this.profileBackgroundImageUrl + '\'' + ", profileBackgroundTile='" + this.profileBackgroundTile + '\'' + ", following=" + this.following + ", notificationEnabled=" + this.notificationEnabled + ", statusesCount=" + this.statusesCount + ", geoEnabled=" + this.geoEnabled + ", verified=" + this.verified + '}';
    }
}

