/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weibo4j.Comment;
import weibo4j.Configuration;
import weibo4j.Count;
import weibo4j.DirectMessage;
import weibo4j.IDs;
import weibo4j.ListObject;
import weibo4j.ListObjectWapper;
import weibo4j.ListUserCount;
import weibo4j.Paging;
import weibo4j.Query;
import weibo4j.QueryResult;
import weibo4j.RateLimitStatus;
import weibo4j.Repost;
import weibo4j.RetweetDetails;
import weibo4j.SavedSearch;
import weibo4j.Status;
import weibo4j.Trends;
import weibo4j.User;
import weibo4j.UserWapper;
import weibo4j.WeiboException;
import weibo4j.WeiboSupport;
import weibo4j.http.AccessToken;
import weibo4j.http.HttpClient;
import weibo4j.http.ImageItem;
import weibo4j.http.PostParameter;
import weibo4j.http.RequestToken;
import weibo4j.http.Response;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Weibo
extends WeiboSupport
implements Serializable {
    public static final String CONSUMER_KEY = "1935062235";
    public static final String CONSUMER_SECRET = "830a9fe913162d425e1606e91cac1559";
    private String baseURL = Configuration.getScheme() + "api.t.sina.com.cn/";
    private String searchBaseURL = Configuration.getScheme() + "api.t.sina.com.cn/";
    private static final long serialVersionUID = -1486360080128882436L;
    public static final Device IM = new Device("im");
    public static final Device SMS = new Device("sms");
    public static final Device NONE = new Device("none");
    private SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);

    public Weibo() {
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.http.setRequestTokenURL(Configuration.getScheme() + "api.t.sina.com.cn/oauth/request_token");
        this.http.setAuthorizationURL(Configuration.getScheme() + "api.t.sina.com.cn/oauth/authorize");
        this.http.setAccessTokenURL(Configuration.getScheme() + "api.t.sina.com.cn/oauth/access_token");
    }

    public void setToken(String string, String string2) {
        this.http.setToken(string, string2);
    }

    public Weibo(String string) {
        this();
        this.baseURL = string;
    }

    public Weibo(String string, String string2) {
        this();
        this.setUserId(string);
        this.setPassword(string2);
    }

    public Weibo(String string, String string2, String string3) {
        this();
        this.setUserId(string);
        this.setPassword(string2);
        this.baseURL = string3;
    }

    public void setBaseURL(String string) {
        this.baseURL = string;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setSearchBaseURL(String string) {
        this.searchBaseURL = string;
    }

    public String getSearchBaseURL() {
        return this.searchBaseURL;
    }

    public synchronized void setOAuthConsumer(String string, String string2) {
        this.http.setOAuthConsumer(string, string2);
    }

    public RequestToken getOAuthRequestToken() throws WeiboException {
        return this.http.getOAuthRequestToken();
    }

    public RequestToken getOAuthRequestToken(String string) throws WeiboException {
        return this.http.getOauthRequestToken(string);
    }

    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken) throws WeiboException {
        return this.http.getOAuthAccessToken(requestToken);
    }

    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken, String string) throws WeiboException {
        AccessToken accessToken = this.http.getOAuthAccessToken(requestToken, string);
        this.setUserId(accessToken.getScreenName());
        return accessToken;
    }

    public synchronized AccessToken getOAuthAccessToken(String string, String string2) throws WeiboException {
        AccessToken accessToken = this.http.getOAuthAccessToken(string, string2);
        this.setUserId(accessToken.getScreenName());
        return accessToken;
    }

    public synchronized AccessToken getOAuthAccessToken(String string, String string2, String string3) throws WeiboException {
        return this.http.getOAuthAccessToken(string, string2, string3);
    }

    public void setOAuthAccessToken(AccessToken accessToken) {
        this.http.setOAuthAccessToken(accessToken);
    }

    public void setOAuthAccessToken(String string, String string2) {
        this.setOAuthAccessToken(new AccessToken(string, string2));
    }

    private Response get(String string, boolean bl) throws WeiboException {
        return this.get(string, null, bl);
    }

    protected Response get(String string, String string2, String string3, boolean bl) throws WeiboException {
        return this.get(string, new PostParameter[]{new PostParameter(string2, string3)}, bl);
    }

    protected Response get(String string, String string2, String string3, String string4, String string5, boolean bl) throws WeiboException {
        return this.get(string, new PostParameter[]{new PostParameter(string2, string3), new PostParameter(string4, string5)}, bl);
    }

    protected Response get(String string, PostParameter[] postParameterArray, boolean bl) throws WeiboException {
        if (string.indexOf("?") == -1) {
            string = string + "?source=1935062235";
        } else if (string.indexOf("source") == -1) {
            string = string + "&source=1935062235";
        }
        if (null != postParameterArray && postParameterArray.length > 0) {
            string = string + "&" + HttpClient.encodeParameters(postParameterArray);
        }
        return this.http.get(string, bl);
    }

    protected Response get(String string, PostParameter[] postParameterArray, Paging paging, boolean bl) throws WeiboException {
        if (null != paging) {
            ArrayList<PostParameter> arrayList = new ArrayList<PostParameter>(4);
            if (-1L != paging.getMaxId()) {
                arrayList.add(new PostParameter("max_id", String.valueOf(paging.getMaxId())));
            }
            if (-1L != paging.getSinceId()) {
                arrayList.add(new PostParameter("since_id", String.valueOf(paging.getSinceId())));
            }
            if (-1 != paging.getPage()) {
                arrayList.add(new PostParameter("page", String.valueOf(paging.getPage())));
            }
            if (-1 != paging.getCount()) {
                if (-1 != string.indexOf("search")) {
                    arrayList.add(new PostParameter("rpp", String.valueOf(paging.getCount())));
                } else {
                    arrayList.add(new PostParameter("count", String.valueOf(paging.getCount())));
                }
            }
            PostParameter[] postParameterArray2 = null;
            PostParameter[] postParameterArray3 = arrayList.toArray(new PostParameter[arrayList.size()]);
            if (null != postParameterArray) {
                postParameterArray2 = new PostParameter[postParameterArray.length + arrayList.size()];
                System.arraycopy(postParameterArray, 0, postParameterArray2, 0, postParameterArray.length);
                System.arraycopy(postParameterArray3, 0, postParameterArray2, postParameterArray.length, arrayList.size());
            } else if (0 != postParameterArray3.length) {
                String string2 = HttpClient.encodeParameters(postParameterArray3);
                string = -1 != string.indexOf("?") ? string + "&source=1935062235&" + string2 : string + "?source=1935062235&" + string2;
            }
            return this.get(string, postParameterArray2, bl);
        }
        return this.get(string, postParameterArray, bl);
    }

    public QueryResult search(Query query) throws WeiboException {
        try {
            return new QueryResult(this.get(this.searchBaseURL + "search.json", query.asPostParameters(), false), this);
        }
        catch (WeiboException weiboException) {
            if (404 == weiboException.getStatusCode()) {
                return new QueryResult(query);
            }
            throw weiboException;
        }
    }

    public Trends getTrends() throws WeiboException {
        return Trends.constructTrends(this.get(this.searchBaseURL + "trends.json", false));
    }

    public Trends getCurrentTrends() throws WeiboException {
        return Trends.constructTrendsList(this.get(this.searchBaseURL + "trends/current.json", false)).get(0);
    }

    public Trends getCurrentTrends(boolean bl) throws WeiboException {
        return Trends.constructTrendsList(this.get(this.searchBaseURL + "trends/current.json" + (bl ? "?exclude=hashtags" : ""), false)).get(0);
    }

    public List<Trends> getDailyTrends() throws WeiboException {
        return Trends.constructTrendsList(this.get(this.searchBaseURL + "trends/daily.json", false));
    }

    public List<Trends> getDailyTrends(Date date, boolean bl) throws WeiboException {
        return Trends.constructTrendsList(this.get(this.searchBaseURL + "trends/daily.json?date=" + this.toDateStr(date) + (bl ? "&exclude=hashtags" : ""), false));
    }

    private String toDateStr(Date date) {
        if (null == date) {
            date = new Date();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(date);
    }

    public List<Trends> getWeeklyTrends() throws WeiboException {
        return Trends.constructTrendsList(this.get(this.searchBaseURL + "trends/weekly.json", false));
    }

    public List<Trends> getWeeklyTrends(Date date, boolean bl) throws WeiboException {
        return Trends.constructTrendsList(this.get(this.searchBaseURL + "trends/weekly.json?date=" + this.toDateStr(date) + (bl ? "&exclude=hashtags" : ""), false));
    }

    public List<Status> getPublicTimeline() throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/public_timeline.json", true));
    }

    public RateLimitStatus getRateLimitStatus() throws WeiboException {
        return new RateLimitStatus(this.get(this.getBaseURL() + "account/rate_limit_status.json", true), this);
    }

    public List<Status> getPublicTimeline(int n) throws WeiboException {
        return this.getPublicTimeline((long)n);
    }

    public List<Status> getPublicTimeline(long l) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/public_timeline.json", null, new Paging(l), false));
    }

    public List<Status> getHomeTimeline() throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/home_timeline.json", true));
    }

    public List<Status> getHomeTimeline(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/home_timeline.json", null, paging, true));
    }

    public List<Status> getFriendsTimeline() throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/friends_timeline.json", true));
    }

    public List<Status> getFriendsTimelineByPage(int n) throws WeiboException {
        return this.getFriendsTimeline(new Paging(n));
    }

    public List<Status> getFriendsTimeline(int n) throws WeiboException {
        return this.getFriendsTimeline(new Paging(n));
    }

    public List<Status> getFriendsTimeline(long l, int n) throws WeiboException {
        return this.getFriendsTimeline(new Paging(n).sinceId(l));
    }

    public List<Status> getFriendsTimeline(String string) throws WeiboException {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public List<Status> getFriendsTimelineByPage(String string, int n) throws WeiboException {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public List<Status> getFriendsTimeline(String string, int n) throws WeiboException {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public List<Status> getFriendsTimeline(long l, String string, int n) throws WeiboException {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public List<Status> getFriendsTimeline(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/friends_timeline.json", null, paging, true));
    }

    public List<Status> getFriendsTimeline(String string, Paging paging) throws WeiboException {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public List<Status> getFriendsTimeline(Date date) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/friends_timeline.xml", "since", this.format.format(date), true), this);
    }

    public List<Status> getFriendsTimeline(long l) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/friends_timeline.xml", "since_id", String.valueOf(l), true), this);
    }

    public List<Status> getFriendsTimeline(String string, Date date) throws WeiboException {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public List<Status> getFriendsTimeline(String string, long l) throws WeiboException {
        throw new IllegalStateException("The Weibo API is not supporting this method anymore");
    }

    public List<Status> getUserTimeline(String string, int n, Date date) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/user_timeline/" + string + ".xml", "since", this.format.format(date), "count", String.valueOf(n), this.http.isAuthenticationEnabled()), this);
    }

    public List<Status> getUserTimeline(String string, int n, long l) throws WeiboException {
        return this.getUserTimeline(string, new Paging(l).count(n));
    }

    public List<Status> getUserTimeline(String string, Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/user_timeline/" + string + ".xml", null, paging, this.http.isAuthenticationEnabled()), this);
    }

    public List<Status> getUserTimeline(String string, Date date) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/user_timeline/" + string + ".xml", "since", this.format.format(date), this.http.isAuthenticationEnabled()), this);
    }

    public List<Status> getUserTimeline(String string, int n) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/user_timeline/" + string + ".xml", "count", String.valueOf(n), this.http.isAuthenticationEnabled()), this);
    }

    public List<Status> getUserTimeline(int n, Date date) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/user_timeline.xml", "since", this.format.format(date), "count", String.valueOf(n), true), this);
    }

    public List<Status> getUserTimeline(int n, long l) throws WeiboException {
        return this.getUserTimeline(new Paging(l).count(n));
    }

    public List<Status> getUserTimeline(String string) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/user_timeline/" + string + ".json", this.http.isAuthenticationEnabled()));
    }

    public List<Status> getUserTimeline(String string, long l) throws WeiboException {
        return this.getUserTimeline(string, new Paging(l));
    }

    public List<Status> getUserTimeline() throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/user_timeline.json", true));
    }

    public List<Status> getUserTimeline(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/user_timeline.json", null, paging, true));
    }

    public List<Status> getUserTimeline(long l) throws WeiboException {
        return this.getUserTimeline(new Paging(l));
    }

    public List<Status> getReplies() throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/replies.xml", true), this);
    }

    public List<Status> getReplies(long l) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/replies.xml", "since_id", String.valueOf(l), true), this);
    }

    public List<Status> getRepliesByPage(int n) throws WeiboException {
        if (n < 1) {
            throw new IllegalArgumentException("page should be positive integer. passed:" + n);
        }
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/replies.xml", "page", String.valueOf(n), true), this);
    }

    public List<Status> getReplies(int n) throws WeiboException {
        if (n < 1) {
            throw new IllegalArgumentException("page should be positive integer. passed:" + n);
        }
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/replies.xml", "page", String.valueOf(n), true), this);
    }

    public List<Status> getReplies(long l, int n) throws WeiboException {
        if (n < 1) {
            throw new IllegalArgumentException("page should be positive integer. passed:" + n);
        }
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/replies.xml", "since_id", String.valueOf(l), "page", String.valueOf(n), true), this);
    }

    public List<Status> getMentions() throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/mentions.json", null, true));
    }

    public List<Status> getMentions(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/mentions.json", null, paging, true));
    }

    public List<Status> getRetweetedByMe() throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/retweeted_by_me.json", null, true));
    }

    public List<Status> getRetweetedByMe(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/retweeted_by_me.json", null, true));
    }

    public List<Status> getRetweetedToMe() throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/retweeted_to_me.json", null, true));
    }

    public List<Status> getRetweetedToMe(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/retweeted_to_me.json", null, paging, true));
    }

    public List<Status> getRetweetsOfMe() throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/retweets_of_me.json", null, true));
    }

    public List<Status> getRetweetsOfMe(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "statuses/retweets_of_me.json", null, paging, true));
    }

    public Status show(int n) throws WeiboException {
        return this.showStatus(n);
    }

    public Status show(long l) throws WeiboException {
        return new Status(this.get(this.getBaseURL() + "statuses/show/" + l + ".xml", false), this);
    }

    public Status showStatus(long l) throws WeiboException {
        return new Status(this.get(this.getBaseURL() + "statuses/show/" + l + ".json", true));
    }

    public Status update(String string) throws WeiboException {
        return this.updateStatus(string);
    }

    public Status updateStatus(String string) throws WeiboException {
        return new Status(this.http.post(this.getBaseURL() + "statuses/update.json", new PostParameter[]{new PostParameter("status", string)}, true));
    }

    public Comment updateComment(String string, String string2, String string3) throws WeiboException {
        PostParameter[] postParameterArray = null;
        postParameterArray = string3 == null ? new PostParameter[]{new PostParameter("comment", string), new PostParameter("id", string2)} : new PostParameter[]{new PostParameter("comment", string), new PostParameter("cid", string3), new PostParameter("id", string2)};
        return new Comment(this.http.post(this.getBaseURL() + "statuses/comment.json", postParameterArray, true));
    }

    public void updateRepost(String string, String string2, int n) throws WeiboException {
        PostParameter[] postParameterArray = null;
        postParameterArray = string == null ? new PostParameter[]{new PostParameter("is_comment", n), new PostParameter("id", string2)} : new PostParameter[]{new PostParameter("status", string), new PostParameter("id", string2), new PostParameter("is_comment", n)};
        new Repost(this.http.post(this.getBaseURL() + "statuses/repost.json", postParameterArray, true));
    }

    public Status uploadStatus(String string, ImageItem imageItem) throws WeiboException {
        return new Status(this.http.multPartURL(this.getBaseURL() + "statuses/upload.json", new PostParameter[]{new PostParameter("status", string), new PostParameter("source", this.source)}, imageItem, true));
    }

    public Status uploadStatus(String string, File file) throws WeiboException {
        return new Status(this.http.multPartURL("pic", this.getBaseURL() + "statuses/upload.json", new PostParameter[]{new PostParameter("status", string), new PostParameter("source", this.source)}, file, true));
    }

    public Status updateStatus(String string, double d, double d2) throws WeiboException, JSONException {
        return new Status(this.http.post(this.getBaseURL() + "statuses/update.json", new PostParameter[]{new PostParameter("status", string), new PostParameter("lat", d), new PostParameter("long", d2)}, true));
    }

    public Status update(String string, long l) throws WeiboException {
        return this.updateStatus(string, l);
    }

    public Status updateStatus(String string, long l) throws WeiboException {
        return new Status(this.http.post(this.getBaseURL() + "statuses/update.json", new PostParameter[]{new PostParameter("status", string), new PostParameter("in_reply_to_status_id", String.valueOf(l)), new PostParameter("source", this.source)}, true));
    }

    public Status updateStatus(String string, long l, double d, double d2) throws WeiboException {
        return new Status(this.http.post(this.getBaseURL() + "statuses/update.json", new PostParameter[]{new PostParameter("status", string), new PostParameter("lat", d), new PostParameter("long", d2), new PostParameter("in_reply_to_status_id", String.valueOf(l)), new PostParameter("source", this.source)}, true));
    }

    public Status destroyStatus(long l) throws WeiboException {
        return new Status(this.http.post(this.getBaseURL() + "statuses/destroy/" + l + ".json", new PostParameter[0], true));
    }

    public Comment destroyComment(long l) throws WeiboException {
        return new Comment(this.http.delete(this.getBaseURL() + "statuses/comment_destroy/" + l + ".json?source=" + CONSUMER_KEY, true));
    }

    public Status retweetStatus(long l) throws WeiboException {
        return new Status(this.http.post(this.getBaseURL() + "statuses/retweet/" + l + ".json", new PostParameter[0], true));
    }

    public List<RetweetDetails> getRetweets(long l) throws WeiboException {
        return RetweetDetails.createRetweetDetails(this.get(this.getBaseURL() + "statuses/retweets/" + l + ".json", true));
    }

    public User getUserDetail(String string) throws WeiboException {
        return this.showUser(string);
    }

    public User showUser(String string) throws WeiboException {
        return new User(this.get(this.getBaseURL() + "users/show/" + string + ".json", this.http.isAuthenticationEnabled()).asJSONObject());
    }

    public List<User> getFriends() throws WeiboException {
        return this.getFriendsStatuses();
    }

    public List<User> getFriendsStatuses() throws WeiboException {
        return User.constructResult(this.get(this.getBaseURL() + "statuses/friends.json", true));
    }

    public List<User> getFriends(Paging paging) throws WeiboException {
        return this.getFriendsStatuses(paging);
    }

    public List<User> getFriendsStatuses(Paging paging) throws WeiboException {
        return User.constructUsers(this.get(this.getBaseURL() + "statuses/friends.json", null, paging, true));
    }

    public List<User> getFriends(int n) throws WeiboException {
        return this.getFriendsStatuses(new Paging(n));
    }

    public List<User> getFriends(String string) throws WeiboException {
        return this.getFriendsStatuses(string);
    }

    public List<User> getFriendsStatuses(String string) throws WeiboException {
        return User.constructUsers(this.get(this.getBaseURL() + "statuses/friends/" + string + ".json", false));
    }

    public List<User> getFriends(String string, Paging paging) throws WeiboException {
        return this.getFriendsStatuses(string, paging);
    }

    public List<User> getFriendsStatuses(String string, Paging paging) throws WeiboException {
        return User.constructUsers(this.get(this.getBaseURL() + "statuses/friends/" + string + ".json", false));
    }

    public List<User> getFriends(String string, int n) throws WeiboException {
        return this.getFriendsStatuses(string, new Paging(n));
    }

    public List<User> getFollowers() throws WeiboException {
        return this.getFollowersStatuses();
    }

    public List<User> getFollowersStatuses() throws WeiboException {
        return User.constructResult(this.get(this.getBaseURL() + "statuses/followers.json", true));
    }

    public List<User> getFollowers(Paging paging) throws WeiboException {
        return this.getFollowersStatuses(paging);
    }

    public List<User> getFollowersStatuses(Paging paging) throws WeiboException {
        return User.constructUsers(this.get(this.getBaseURL() + "statuses/followers.json", null, paging, true));
    }

    public List<User> getFollowers(int n) throws WeiboException {
        return this.getFollowersStatuses(new Paging(n));
    }

    public List<User> getFollowers(String string) throws WeiboException {
        return this.getFollowersStatuses(string);
    }

    public List<User> getFollowersStatuses(String string) throws WeiboException {
        return User.constructUsers(this.get(this.getBaseURL() + "statuses/followers/" + string + ".json", true));
    }

    public List<User> getFollowers(String string, Paging paging) throws WeiboException {
        return this.getFollowersStatuses(string, paging);
    }

    public List<User> getFollowersStatuses(String string, Paging paging) throws WeiboException {
        return User.constructUsers(this.get(this.getBaseURL() + "statuses/followers/" + string + ".json", null, paging, true));
    }

    public List<User> getFollowers(String string, int n) throws WeiboException {
        return this.getFollowersStatuses(string, new Paging(n));
    }

    public List<User> getFeatured() throws WeiboException {
        return User.constructUsers(this.get(this.getBaseURL() + "statuses/featured.json", true));
    }

    public List<DirectMessage> getDirectMessages() throws WeiboException {
        return DirectMessage.constructDirectMessages(this.get(this.getBaseURL() + "direct_messages.json", true));
    }

    public List<DirectMessage> getDirectMessages(Paging paging) throws WeiboException {
        return DirectMessage.constructDirectMessages(this.get(this.getBaseURL() + "direct_messages.json", null, paging, true));
    }

    public List<DirectMessage> getDirectMessagesByPage(int n) throws WeiboException {
        return this.getDirectMessages(new Paging(n));
    }

    public List<DirectMessage> getDirectMessages(int n, int n2) throws WeiboException {
        return this.getDirectMessages(new Paging(n).sinceId(n2));
    }

    public List<DirectMessage> getDirectMessages(int n) throws WeiboException {
        return this.getDirectMessages(new Paging((long)n));
    }

    public List<DirectMessage> getDirectMessages(Date date) throws WeiboException {
        return DirectMessage.constructDirectMessages(this.get(this.getBaseURL() + "direct_messages.xml", "since", this.format.format(date), true), this);
    }

    public List<DirectMessage> getSentDirectMessages() throws WeiboException {
        return DirectMessage.constructDirectMessages(this.get(this.getBaseURL() + "direct_messages/sent.json", new PostParameter[0], true));
    }

    public List<DirectMessage> getSentDirectMessages(Paging paging) throws WeiboException {
        return DirectMessage.constructDirectMessages(this.get(this.getBaseURL() + "direct_messages/sent.json", new PostParameter[0], paging, true));
    }

    public List<DirectMessage> getSentDirectMessages(Date date) throws WeiboException {
        return DirectMessage.constructDirectMessages(this.get(this.getBaseURL() + "direct_messages/sent.xml", "since", this.format.format(date), true), this);
    }

    public List<DirectMessage> getSentDirectMessages(int n) throws WeiboException {
        return this.getSentDirectMessages(new Paging((long)n));
    }

    public List<DirectMessage> getSentDirectMessages(int n, int n2) throws WeiboException {
        return this.getSentDirectMessages(new Paging(n, (long)n2));
    }

    public DirectMessage sendDirectMessage(String string, String string2) throws WeiboException {
        return new DirectMessage(this.http.post(this.getBaseURL() + "direct_messages/new.json", new PostParameter[]{new PostParameter("user_id", string), new PostParameter("text", string2), new PostParameter("source", this.source)}, true).asJSONObject());
    }

    public DirectMessage deleteDirectMessage(int n) throws WeiboException {
        return this.destroyDirectMessage(n);
    }

    public DirectMessage destroyDirectMessage(int n) throws WeiboException {
        return new DirectMessage(this.http.post(this.getBaseURL() + "direct_messages/destroy/" + n + ".json", new PostParameter[0], true).asJSONObject());
    }

    public User create(String string) throws WeiboException {
        return this.createFriendship(string);
    }

    public User createFriendship(String string) throws WeiboException {
        return new User(this.http.post(this.getBaseURL() + "friendships/create/" + string + ".json", new PostParameter[0], true).asJSONObject());
    }

    public User createFriendship(String string, boolean bl) throws WeiboException {
        return new User(this.http.post(this.getBaseURL() + "friendships/create/" + string + ".json", new PostParameter[]{new PostParameter("follow", String.valueOf(bl))}, true).asJSONObject());
    }

    public User destroy(String string) throws WeiboException {
        return this.destroyFriendship(string);
    }

    public User destroyFriendship(String string) throws WeiboException {
        return new User(this.http.post(this.getBaseURL() + "friendships/destroy/" + string + ".json", new PostParameter[0], true).asJSONObject());
    }

    public boolean exists(String string, String string2) throws WeiboException {
        return this.existsFriendship(string, string2);
    }

    public boolean existsFriendship(String string, String string2) throws WeiboException {
        return -1 != this.get(this.getBaseURL() + "friendships/exists.json", "user_a", string, "user_b", string2, true).asString().indexOf("true");
    }

    public IDs getFriendsIDs() throws WeiboException {
        return this.getFriendsIDs(-1L);
    }

    public IDs getFriendsIDs(Paging paging) throws WeiboException {
        return new IDs(this.get(this.getBaseURL() + "friends/ids.xml", null, paging, true));
    }

    public IDs getFriendsIDs(long l) throws WeiboException {
        return new IDs(this.get(this.getBaseURL() + "friends/ids.xml?cursor=" + l, true));
    }

    public IDs getFriendsIDs(int n) throws WeiboException {
        return this.getFriendsIDs(n, -1L);
    }

    public IDs getFriendsIDs(int n, Paging paging) throws WeiboException {
        return new IDs(this.get(this.getBaseURL() + "friends/ids.xml?user_id=" + n, null, paging, true));
    }

    public IDs getFriendsIDs(int n, long l) throws WeiboException {
        return new IDs(this.get(this.getBaseURL() + "friends/ids.json?user_id=" + n + "&cursor=" + l, true), this);
    }

    public IDs getFriendsIDs(String string) throws WeiboException {
        return this.getFriendsIDs(string, -1L);
    }

    public IDs getFriendsIDs(String string, Paging paging) throws WeiboException {
        return new IDs(this.get(this.getBaseURL() + "friends/ids.xml?screen_name=" + string, null, paging, true));
    }

    public IDs getFriendsIDs(String string, long l) throws WeiboException {
        return new IDs(this.get(this.getBaseURL() + "friends/ids.json?screen_name=" + string + "&cursor=" + l, true), this);
    }

    public IDs getFollowersIDs() throws WeiboException {
        return this.getFollowersIDs(-1L);
    }

    public IDs getFollowersIDs(Paging paging) throws WeiboException {
        return new IDs(this.get(this.getBaseURL() + "followers/ids.xml", null, paging, true));
    }

    public IDs getFollowersIDs(long l) throws WeiboException {
        return new IDs(this.get(this.getBaseURL() + "followers/ids.json?cursor=" + l, true), this);
    }

    public IDs getFollowersIDs(int n) throws WeiboException {
        return this.getFollowersIDs(n, -1L);
    }

    public IDs getFollowersIDs(int n, Paging paging) throws WeiboException {
        return new IDs(this.get(this.getBaseURL() + "followers/ids.xml?user_id=" + n, null, paging, true));
    }

    public IDs getFollowersIDs(int n, long l) throws WeiboException {
        return new IDs(this.get(this.getBaseURL() + "followers/ids.xml?user_id=" + n + "&cursor=" + l, true));
    }

    public IDs getFollowersIDs(String string) throws WeiboException {
        return this.getFollowersIDs(string, -1L);
    }

    public IDs getFollowersIDs(String string, Paging paging) throws WeiboException {
        return new IDs(this.get(this.getBaseURL() + "followers/ids.xml?screen_name=" + string, null, paging, true));
    }

    public IDs getFollowersIDs(String string, long l) throws WeiboException {
        return new IDs(this.get(this.getBaseURL() + "followers/ids.json?screen_name=" + string + "&cursor=" + l, true), this);
    }

    public User verifyCredentials() throws WeiboException {
        return new User(this.get(this.getBaseURL() + "account/verify_credentials.json", true).asJSONObject());
    }

    public User updateLocation(String string) throws WeiboException {
        return new User(this.http.post(this.getBaseURL() + "account/update_location.xml", new PostParameter[]{new PostParameter("location", string)}, true), this);
    }

    public User updateProfile(String string, String string2, String string3, String string4, String string5) throws WeiboException {
        ArrayList<PostParameter> arrayList = new ArrayList<PostParameter>(5);
        this.addParameterToList(arrayList, "name", string);
        this.addParameterToList(arrayList, "email", string2);
        this.addParameterToList(arrayList, "url", string3);
        this.addParameterToList(arrayList, "location", string4);
        this.addParameterToList(arrayList, "description", string5);
        return new User(this.http.post(this.getBaseURL() + "account/update_profile.json", arrayList.toArray(new PostParameter[arrayList.size()]), true).asJSONObject());
    }

    public User updateProfileImage(File file) throws WeiboException {
        return new User(this.http.multPartURL("image", this.getBaseURL() + "account/update_profile_image.json", null, file, true).asJSONObject());
    }

    public RateLimitStatus rateLimitStatus() throws WeiboException {
        return new RateLimitStatus(this.http.get(this.getBaseURL() + "account/rate_limit_status.json", true), this);
    }

    public User updateDeliverlyDevice(Device device) throws WeiboException {
        return new User(this.http.post(this.getBaseURL() + "account/update_delivery_device.json", new PostParameter[]{new PostParameter("device", device.DEVICE)}, true).asJSONObject());
    }

    public User updateProfileColors(String string, String string2, String string3, String string4, String string5) throws WeiboException {
        ArrayList<PostParameter> arrayList = new ArrayList<PostParameter>(5);
        this.addParameterToList(arrayList, "profile_background_color", string);
        this.addParameterToList(arrayList, "profile_text_color", string2);
        this.addParameterToList(arrayList, "profile_link_color", string3);
        this.addParameterToList(arrayList, "profile_sidebar_fill_color", string4);
        this.addParameterToList(arrayList, "profile_sidebar_border_color", string5);
        return new User(this.http.post(this.getBaseURL() + "account/update_profile_colors.json", arrayList.toArray(new PostParameter[arrayList.size()]), true).asJSONObject());
    }

    private void addParameterToList(List<PostParameter> list, String string, String string2) {
        if (null != string2) {
            list.add(new PostParameter(string, string2));
        }
    }

    public List<Status> favorites() throws WeiboException {
        return this.getFavorites();
    }

    public List<Status> getFavorites() throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "favorites.json", new PostParameter[0], true));
    }

    public List<Status> favorites(int n) throws WeiboException {
        return this.getFavorites(n);
    }

    public List<Status> getFavorites(int n) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "favorites.json", "page", String.valueOf(n), true));
    }

    public List<Status> favorites(String string) throws WeiboException {
        return this.getFavorites(string);
    }

    public List<Status> getFavorites(String string) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "favorites/" + string + ".json", new PostParameter[0], true));
    }

    public List<Status> favorites(String string, int n) throws WeiboException {
        return this.getFavorites(string, n);
    }

    public List<Status> getFavorites(String string, int n) throws WeiboException {
        return Status.constructStatuses(this.get(this.getBaseURL() + "favorites/" + string + ".json", "page", String.valueOf(n), true));
    }

    public Status createFavorite(long l) throws WeiboException {
        return new Status(this.http.post(this.getBaseURL() + "favorites/create/" + l + ".json", true));
    }

    public Status destroyFavorite(long l) throws WeiboException {
        return new Status(this.http.post(this.getBaseURL() + "favorites/destroy/" + l + ".json", true));
    }

    public User follow(String string) throws WeiboException {
        return this.enableNotification(string);
    }

    public User enableNotification(String string) throws WeiboException {
        return new User(this.http.post(this.getBaseURL() + "notifications/follow/" + string + ".json", true).asJSONObject());
    }

    public User leave(String string) throws WeiboException {
        return this.disableNotification(string);
    }

    public User disableNotification(String string) throws WeiboException {
        return new User(this.http.post(this.getBaseURL() + "notifications/leave/" + string + ".json", true).asJSONObject());
    }

    public User block(String string) throws WeiboException {
        return new User(this.http.post(this.getBaseURL() + "blocks/create/" + string + ".xml", true), this);
    }

    public User createBlock(String string) throws WeiboException {
        return new User(this.http.post(this.getBaseURL() + "blocks/create/" + string + ".json", true).asJSONObject());
    }

    public User unblock(String string) throws WeiboException {
        return new User(this.http.post(this.getBaseURL() + "blocks/destroy/" + string + ".xml", true), this);
    }

    public User destroyBlock(String string) throws WeiboException {
        return new User(this.http.post(this.getBaseURL() + "blocks/destroy/" + string + ".json", true).asJSONObject());
    }

    public boolean existsBlock(String string) throws WeiboException {
        try {
            return -1 == this.get(this.getBaseURL() + "blocks/exists/" + string + ".json", true).asString().indexOf("<error>You are not blocking this user.</error>");
        }
        catch (WeiboException weiboException) {
            if (weiboException.getStatusCode() == 404) {
                return false;
            }
            throw weiboException;
        }
    }

    public List<User> getBlockingUsers() throws WeiboException {
        return User.constructUsers(this.get(this.getBaseURL() + "blocks/blocking.json", true));
    }

    public List<User> getBlockingUsers(int n) throws WeiboException {
        return User.constructUsers(this.get(this.getBaseURL() + "blocks/blocking.json?page=" + n, true));
    }

    public IDs getBlockingUsersIDs() throws WeiboException {
        return new IDs(this.get(this.getBaseURL() + "blocks/blocking/ids.json", true), this);
    }

    public List<SavedSearch> getSavedSearches() throws WeiboException {
        return SavedSearch.constructSavedSearches(this.get(this.getBaseURL() + "saved_searches.json", true));
    }

    public SavedSearch showSavedSearch(int n) throws WeiboException {
        return new SavedSearch(this.get(this.getBaseURL() + "saved_searches/show/" + n + ".json", true));
    }

    public SavedSearch createSavedSearch(String string) throws WeiboException {
        return new SavedSearch(this.http.post(this.getBaseURL() + "saved_searches/create.json", new PostParameter[]{new PostParameter("query", string)}, true));
    }

    public SavedSearch destroySavedSearch(int n) throws WeiboException {
        return new SavedSearch(this.http.post(this.getBaseURL() + "saved_searches/destroy/" + n + ".json", true));
    }

    public ListObject getList(String string, String string2, boolean bl) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/lists/").append(string2).append(".xml").append("?source=").append(CONSUMER_KEY);
        String string3 = "GET";
        String string4 = stringBuilder.toString();
        Response response = this.http.httpRequest(string4, null, bl, string3);
        return new ListObject(response, this);
    }

    public List<Status> getListStatuses(String string, String string2, boolean bl) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/lists/").append(string2).append("/statuses.xml").append("?source=").append(CONSUMER_KEY);
        String string3 = "GET";
        String string4 = stringBuilder.toString();
        return Status.constructStatuses(this.http.httpRequest(string4, null, bl, string3), this);
    }

    public ListObjectWapper getUserLists(String string, boolean bl) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/lists.xml").append("?source=").append(CONSUMER_KEY);
        String string2 = "GET";
        String string3 = stringBuilder.toString();
        Response response = this.http.httpRequest(string3, null, bl, string2);
        return ListObject.constructListObjects(response, this);
    }

    public ListObjectWapper getUserSubscriberLists(String string, boolean bl) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/lists/subscriptions.xml").append("?source=").append(CONSUMER_KEY);
        String string2 = "GET";
        String string3 = stringBuilder.toString();
        Response response = this.http.httpRequest(string3, null, bl, string2);
        return ListObject.constructListObjects(response, this);
    }

    public ListObjectWapper getUserListedLists(String string, boolean bl) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/lists/memberships.xml").append("?source=").append(CONSUMER_KEY);
        String string2 = "GET";
        String string3 = stringBuilder.toString();
        Response response = this.http.httpRequest(string3, null, bl, string2);
        return ListObject.constructListObjects(response, this);
    }

    public ListUserCount getListUserCount(String string, boolean bl) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(String.valueOf(string)).append("/lists").append("/counts.xml").append("?source=").append(CONSUMER_KEY);
        String string2 = "GET";
        String string3 = stringBuilder.toString();
        Response response = this.http.httpRequest(string3, null, bl, string2);
        return new ListUserCount(response);
    }

    public UserWapper getListMembers(String string, String string2, boolean bl) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/").append(string2).append("/members.xml").append("?source=").append(CONSUMER_KEY);
        String string3 = "GET";
        String string4 = stringBuilder.toString();
        return User.constructWapperUsers(this.http.httpRequest(string4, null, bl, string3), this);
    }

    public UserWapper getListSubscribers(String string, String string2, boolean bl) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/").append(string2).append("/subscribers.xml").append("?source=").append(CONSUMER_KEY);
        String string3 = "GET";
        String string4 = stringBuilder.toString();
        return User.constructWapperUsers(this.http.httpRequest(string4, null, bl, string3), this);
    }

    public ListObject insertList(String string, String string2, boolean bl, String string3, boolean bl2) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/lists.xml");
        LinkedList<PostParameter> linkedList = new LinkedList<PostParameter>();
        linkedList.add(new PostParameter("name", string2));
        linkedList.add(new PostParameter("description", string3));
        linkedList.add(new PostParameter("mode", bl ? "public" : "private"));
        linkedList.add(new PostParameter("source", CONSUMER_KEY));
        PostParameter[] postParameterArray = new PostParameter[linkedList.size()];
        int n = 0;
        for (PostParameter object2 : linkedList) {
            postParameterArray[n++] = object2;
        }
        String string4 = "POST";
        String string5 = stringBuilder.toString();
        Response response = this.http.httpRequest(string5, postParameterArray, bl2, string4);
        return new ListObject(response, this);
    }

    public ListObject updateList(String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/lists/").append(string2).append(".xml");
        LinkedList<PostParameter> linkedList = new LinkedList<PostParameter>();
        linkedList.add(new PostParameter("name", string3));
        linkedList.add(new PostParameter("mode", bl ? "public" : "private"));
        linkedList.add(new PostParameter("description", string4));
        linkedList.add(new PostParameter("source", CONSUMER_KEY));
        PostParameter[] postParameterArray = new PostParameter[linkedList.size()];
        int n = 0;
        for (PostParameter object2 : linkedList) {
            postParameterArray[n++] = object2;
        }
        String string5 = "POST";
        String string6 = stringBuilder.toString();
        Response response = this.http.httpRequest(string6, postParameterArray, bl2, string5);
        return new ListObject(response, this);
    }

    public ListObject removeList(String string, String string2, boolean bl) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/lists/").append(string2).append(".xml").append("?source=").append(CONSUMER_KEY);
        String string3 = stringBuilder.toString();
        String string4 = "DELETE";
        Response response = this.http.httpRequest(string3, null, bl, string4);
        return new ListObject(response, this);
    }

    public ListObject addListMember(String string, String string2, String string3, boolean bl) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/").append(string2).append("/members.xml");
        String string4 = stringBuilder.toString();
        LinkedList<PostParameter> linkedList = new LinkedList<PostParameter>();
        linkedList.add(new PostParameter("id", String.valueOf(string3)));
        linkedList.add(new PostParameter("source", CONSUMER_KEY));
        PostParameter[] postParameterArray = new PostParameter[linkedList.size()];
        int n = 0;
        for (PostParameter object2 : linkedList) {
            postParameterArray[n++] = object2;
        }
        String string5 = "POST";
        Response response = this.http.httpRequest(string4, postParameterArray, bl, string5);
        return new ListObject(response, this);
    }

    public ListObject removeListMember(String string, String string2, String string3, boolean bl) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/").append(string2).append("/members.xml").append("?source=").append(CONSUMER_KEY).append("&id=").append(String.valueOf(string3));
        String string4 = stringBuilder.toString();
        String string5 = "DELETE";
        Response response = this.http.httpRequest(string4, null, bl, string5);
        return new ListObject(response, this);
    }

    public ListObject addListSubscriber(String string, String string2, boolean bl) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/").append(string2).append("/subscribers.xml");
        String string3 = stringBuilder.toString();
        LinkedList<PostParameter> linkedList = new LinkedList<PostParameter>();
        linkedList.add(new PostParameter("source", CONSUMER_KEY));
        PostParameter[] postParameterArray = new PostParameter[linkedList.size()];
        int n = 0;
        for (PostParameter object2 : linkedList) {
            postParameterArray[n++] = object2;
        }
        String string4 = "POST";
        Response response = this.http.httpRequest(string3, postParameterArray, bl, string4);
        return new ListObject(response, this);
    }

    public ListObject removeListSubscriber(String string, String string2, boolean bl) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/").append(string2).append("/subscribers.xml").append("?source=").append(CONSUMER_KEY);
        String string3 = stringBuilder.toString();
        String string4 = "DELETE";
        Response response = this.http.httpRequest(string3, null, bl, string4);
        return new ListObject(response, this);
    }

    public boolean isListMember(String string, String string2, String string3, boolean bl) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/").append(string2).append("/members/").append(string3).append(".xml").append("?source=").append(CONSUMER_KEY);
        String string4 = stringBuilder.toString();
        String string5 = "GET";
        Document document = this.http.httpRequest(string4, null, bl, string5).asDocument();
        Element element = document.getDocumentElement();
        return "true".equals(element.getTextContent());
    }

    public boolean isListSubscriber(String string, String string2, String string3, boolean bl) throws WeiboException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseURL()).append(string).append("/").append(string2).append("/subscribers/").append(string3).append(".xml").append("?source=").append(CONSUMER_KEY);
        String string4 = stringBuilder.toString();
        String string5 = "GET";
        Document document = this.http.httpRequest(string4, null, bl, string5).asDocument();
        Element element = document.getDocumentElement();
        return "true".equals(element.getTextContent());
    }

    public boolean test() throws WeiboException {
        return -1 != this.get(this.getBaseURL() + "help/test.json", false).asString().indexOf("ok");
    }

    public User getAuthenticatedUser() throws WeiboException {
        return new User(this.get(this.getBaseURL() + "account/verify_credentials.xml", true), this);
    }

    public String getDowntimeSchedule() throws WeiboException {
        throw new WeiboException("this method is not supported by the Weibo API anymore", new NoSuchMethodException("this method is not supported by the Weibo API anymore"));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Weibo weibo = (Weibo)object;
        if (!this.baseURL.equals(weibo.baseURL)) {
            return false;
        }
        if (!this.format.equals(weibo.format)) {
            return false;
        }
        if (!this.http.equals(weibo.http)) {
            return false;
        }
        if (!this.searchBaseURL.equals(weibo.searchBaseURL)) {
            return false;
        }
        return this.source.equals(weibo.source);
    }

    public int hashCode() {
        int n = this.http.hashCode();
        n = 31 * n + this.baseURL.hashCode();
        n = 31 * n + this.searchBaseURL.hashCode();
        n = 31 * n + this.source.hashCode();
        n = 31 * n + this.format.hashCode();
        return n;
    }

    public String toString() {
        return "Weibo{http=" + this.http + ", baseURL='" + this.baseURL + '\'' + ", searchBaseURL='" + this.searchBaseURL + '\'' + ", source='" + this.source + '\'' + ", format=" + this.format + '}';
    }

    public List<Comment> getComments(String string) throws WeiboException {
        return Comment.constructComments(this.get(this.getBaseURL() + "statuses/comments.json?id=" + string, true));
    }

    public List<Comment> getCommentsTimeline() throws WeiboException {
        return Comment.constructComments(this.get(this.getBaseURL() + "statuses/comments_timeline.json", true));
    }

    public List<Comment> getCommentsByMe() throws WeiboException {
        return Comment.constructComments(this.get(this.getBaseURL() + "statuses/comments_by_me.json", true));
    }

    public List<Count> getCounts(String string) throws WeiboException {
        return Count.constructCounts(this.get(this.getBaseURL() + "statuses/counts.json?ids=" + string, true));
    }

    public Count getUnread() throws WeiboException, JSONException {
        return new Count(this.get(this.getBaseURL() + "statuses/unread.json", true).asJSONObject());
    }

    public Status repost(String string, String string2) throws WeiboException {
        return new Status(this.http.post(this.getBaseURL() + "statuses/repost.json", new PostParameter[]{new PostParameter("id", string), new PostParameter("status", string2)}, true));
    }

    public Status reply(String string, String string2, String string3) throws WeiboException {
        return new Status(this.http.post(this.getBaseURL() + "statuses/reply.json", new PostParameter[]{new PostParameter("id", string), new PostParameter("cid", string2), new PostParameter("comment", string3)}, true));
    }

    public JSONObject showFriendships(String string) throws WeiboException {
        return this.get(this.getBaseURL() + "friendships/show.json?target_id=" + string, true).asJSONObject();
    }

    public JSONObject showFriendships(String string, String string2) throws WeiboException {
        return this.get(this.getBaseURL() + "friendships/show.json?target_id=" + string2 + "&source_id" + string, true).asJSONObject();
    }

    public User endSession() throws WeiboException {
        return new User(this.get(this.getBaseURL() + "account/end_session.json", true).asJSONObject());
    }

    public JSONObject register(String string, String ... stringArray) throws WeiboException {
        return this.http.post(this.getBaseURL() + "account/register.json", new PostParameter[]{new PostParameter("nick", stringArray[2]), new PostParameter("gender", stringArray[3]), new PostParameter("password", stringArray[4]), new PostParameter("email", stringArray[5]), new PostParameter("ip", string)}, true).asJSONObject();
    }

    static class Device {
        final String DEVICE;

        public Device(String string) {
            this.DEVICE = string;
        }
    }
}

