/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weibo4j.Configuration;
import weibo4j.WeiboException;
import weibo4j.http.HTMLEntity;
import weibo4j.http.Response;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class WeiboResponse
implements Serializable {
    private static Map<String, SimpleDateFormat> formatMap = new HashMap<String, SimpleDateFormat>();
    private static final long serialVersionUID = 3519962197957449562L;
    private transient int rateLimitLimit = -1;
    private transient int rateLimitRemaining = -1;
    private transient long rateLimitReset = -1L;
    private static final boolean IS_DALVIK = Configuration.isDalvik();

    public WeiboResponse() {
    }

    public WeiboResponse(Response response) {
        String string;
        String string2;
        String string3 = response.getResponseHeader("X-RateLimit-Limit");
        if (null != string3) {
            this.rateLimitLimit = Integer.parseInt(string3);
        }
        if (null != (string2 = response.getResponseHeader("X-RateLimit-Remaining"))) {
            this.rateLimitRemaining = Integer.parseInt(string2);
        }
        if (null != (string = response.getResponseHeader("X-RateLimit-Reset"))) {
            this.rateLimitReset = Long.parseLong(string);
        }
    }

    protected static void ensureRootNodeNameIs(String string, Element element) throws WeiboException {
        if (!string.equals(element.getNodeName())) {
            throw new WeiboException("Unexpected root node name:" + element.getNodeName() + ". Expected:" + string + ". Check the availability of the Weibo API at http://open.t.sina.com.cn/.");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static void ensureRootNodeNameIs(String[] stringArray, Element element) throws WeiboException {
        void var3_5;
        String string = element.getNodeName();
        String[] object = stringArray;
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            String string2 = object[i];
            if (!string2.equals(string)) continue;
            return;
        }
        String string3 = "";
        for (n = 0; n < stringArray.length; ++n) {
            void var3_7;
            if (n != 0) {
                String string4 = (String)var3_5 + " or ";
            }
            String string5 = (String)var3_7 + stringArray[n];
        }
        throw new WeiboException("Unexpected root node name:" + element.getNodeName() + ". Expected:" + (String)var3_5 + ". Check the availability of the Weibo API at http://open.t.sina.com.cn/.");
    }

    protected static void ensureRootNodeNameIs(String string, Document document) throws WeiboException {
        Element element = document.getDocumentElement();
        if (!string.equals(element.getNodeName())) {
            throw new WeiboException("Unexpected root node name:" + element.getNodeName() + ". Expected:" + string + ". Check the availability of the Weibo API at http://open.t.sina.com.cn/");
        }
    }

    protected static boolean isRootNodeNilClasses(Document document) {
        String string = document.getDocumentElement().getNodeName();
        return "nil-classes".equals(string) || "nilclasses".equals(string);
    }

    protected static String getChildText(String string, Element element) {
        return HTMLEntity.unescape(WeiboResponse.getTextContent(string, element));
    }

    protected static String getTextContent(String string, Element element) {
        Node node;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0 && null != (node = nodeList.item(0).getFirstChild())) {
            String string2 = node.getNodeValue();
            return null != string2 ? string2 : "";
        }
        return "";
    }

    protected static int getChildInt(String string, Element element) {
        String string2 = WeiboResponse.getTextContent(string, element);
        if (null == string2 || "".equals(string2) || "null".equals(string)) {
            return -1;
        }
        return Integer.valueOf(string2);
    }

    protected static long getChildLong(String string, Element element) {
        String string2 = WeiboResponse.getTextContent(string, element);
        if (null == string2 || "".equals(string2) || "null".equals(string)) {
            return -1L;
        }
        return Long.valueOf(string2);
    }

    protected static String getString(String string, JSONObject jSONObject, boolean bl) {
        String string2 = null;
        try {
            string2 = jSONObject.getString(string);
            if (bl) {
                try {
                    string2 = URLDecoder.decode(string2, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return string2;
    }

    protected static boolean getChildBoolean(String string, Element element) {
        String string2 = WeiboResponse.getTextContent(string, element);
        return Boolean.valueOf(string2);
    }

    protected static Date getChildDate(String string, Element element) throws WeiboException {
        return WeiboResponse.getChildDate(string, element, "EEE MMM d HH:mm:ss z yyyy");
    }

    protected static Date getChildDate(String string, Element element, String string2) throws WeiboException {
        return WeiboResponse.parseDate(WeiboResponse.getChildText(string, element), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Date parseDate(String string, String string2) throws WeiboException {
        if (string == null || "".equals(string)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = formatMap.get(string2);
        if (null == simpleDateFormat) {
            simpleDateFormat = new SimpleDateFormat(string2, Locale.ENGLISH);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            formatMap.put(string2, simpleDateFormat);
        }
        try {
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            synchronized (simpleDateFormat2) {
                return simpleDateFormat.parse(string);
            }
        }
        catch (ParseException parseException) {
            throw new WeiboException("Unexpected format(" + string + ") returned from sina.com.cn");
        }
    }

    protected static int getInt(String string, JSONObject jSONObject) throws JSONException {
        String string2 = jSONObject.getString(string);
        if (null == string2 || "".equals(string2) || "null".equals(string2)) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    protected static long getLong(String string, JSONObject jSONObject) throws JSONException {
        String string2 = jSONObject.getString(string);
        if (null == string2 || "".equals(string2) || "null".equals(string2)) {
            return -1L;
        }
        return Long.parseLong(string2);
    }

    protected static boolean getBoolean(String string, JSONObject jSONObject) throws JSONException {
        String string2 = jSONObject.getString(string);
        if (null == string2 || "".equals(string2) || "null".equals(string2)) {
            return false;
        }
        return Boolean.valueOf(string2);
    }

    public int getRateLimitLimit() {
        return this.rateLimitLimit;
    }

    public int getRateLimitRemaining() {
        return this.rateLimitRemaining;
    }

    public long getRateLimitReset() {
        return this.rateLimitReset;
    }
}

