/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.examples;

import java.util.List;
import weibo4j.Status;
import weibo4j.Weibo;
import weibo4j.WeiboException;

public class GetTimelines {
    public static void main(String[] stringArray) {
        System.out.println("Showing public timeline.");
        try {
            if (stringArray.length < 2) {
                System.out.println("You need to specify WeiboID/Password combination to show UserTimelines.");
                System.out.println("Usage: java weibo4j.examples.GetTimelines ID Password");
                System.exit(0);
            }
            Weibo weibo = new Weibo(stringArray[0], stringArray[1]);
            List<Status> list = weibo.getPublicTimeline();
            for (Status status : list) {
                System.out.println(status.getUser().getName() + ":" + status.getText());
            }
            list = weibo.getFriendsTimeline();
            System.out.println("------------------------------");
            System.out.println("Showing " + stringArray[0] + "'s friends timeline.");
            for (Status status : list) {
                System.out.println(status.getUser().getName() + ":" + status.getText());
            }
            list = weibo.getUserTimeline();
            System.out.println("------------------------------");
            System.out.println("Showing " + stringArray[0] + "'s timeline.");
            for (Status status : list) {
                System.out.println(status.getUser().getName() + ":" + status.getText());
            }
            System.exit(0);
        }
        catch (WeiboException weiboException) {
            System.out.println("Failed to get timeline: " + weiboException.getMessage());
            System.exit(-1);
        }
    }
}

