AddComponentPostInit("playercontroller", function(PlayerController, inst)

function PlayerController:RotRight()
	local rotamount = GetModConfigData("ROTATION_SNAP")
	if GLOBAL.TheCamera:CanControl() then  
		
		if GLOBAL.IsPaused() then
			if GetWorld().minimap.MiniMap:IsVisible() then
				GLOBAL.TheCamera:SetHeadingTarget(GLOBAL.TheCamera:GetHeadingTarget() + rotamount) 
				GLOBAL.TheCamera:Snap()
			end
		else
			GLOBAL.TheCamera:SetHeadingTarget(GLOBAL.TheCamera:GetHeadingTarget() + rotamount) 
			--UpdateCameraHeadings() 
		end
	end
end

function PlayerController:RotLeft()
	local rotamount = GetModConfigData("ROTATION_SNAP")
	if GLOBAL.TheCamera:CanControl() then  
		
		if GLOBAL.IsPaused() then
			if GLOBAL.GetWorld().minimap.MiniMap:IsVisible() then
				GLOBAL.TheCamera:SetHeadingTarget(GLOBAL.TheCamera:GetHeadingTarget() - rotamount) 
				GLOBAL.TheCamera:Snap()
			end
		else
			GLOBAL.TheCamera:SetHeadingTarget(GLOBAL.TheCamera:GetHeadingTarget() - rotamount) 
			--UpdateCameraHeadings() 
		end
	end
end

function PlayerController:DoCameraControl()
	--camera controls
	local time = GLOBAL.GetTime()

	local ROT_REPEAT = GetModConfigData("ROTATION_SPEED")
	local ZOOM_REPEAT = .1

	if GLOBAL.TheCamera:CanControl() then
		
		if not self.lastrottime or time - self.lastrottime > ROT_REPEAT then
			
			if GLOBAL.TheInput:IsControlPressed(GLOBAL.CONTROL_ROTATE_LEFT) then
				self:RotLeft()
				self.lastrottime = time
			elseif GLOBAL.TheInput:IsControlPressed(GLOBAL.CONTROL_ROTATE_RIGHT) then
				self:RotRight()
				self.lastrottime = time
			end
		end

	    if not GLOBAL.TheCamera:CanControl()
	        or (self.inst.HUD ~= nil and
	            self.inst.HUD:IsCraftingOpen()) then
	        --Check crafting again because this time
	        --we block even with mouse crafting open
	        return
	    end

		if not self.lastzoomtime or time - self.lastzoomtime > ZOOM_REPEAT then
			if GLOBAL.TheInput:IsControlPressed(GLOBAL.CONTROL_ZOOM_IN) then
				GLOBAL.TheCamera:ZoomIn()
				self.lastzoomtime = time
			elseif GLOBAL.TheInput:IsControlPressed(GLOBAL.CONTROL_ZOOM_OUT) then
				GLOBAL.TheCamera:ZoomOut()
				self.lastzoomtime = time
			end
		end
	end

end

end)