/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans;

import com.l2fprod.common.beans.DefaultBeanDescriptor;
import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.util.ResourceManager;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;

public class BaseBeanInfo
extends SimpleBeanInfo {
    private Class type;
    private BeanDescriptor beanDescriptor;
    private List properties = new ArrayList(0);

    public BaseBeanInfo(Class clazz) {
        this.type = clazz;
    }

    public final Class getType() {
        return this.type;
    }

    public ResourceManager getResources() {
        return ResourceManager.get(this.getType());
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        if (this.beanDescriptor == null) {
            this.beanDescriptor = new DefaultBeanDescriptor(this);
        }
        return this.beanDescriptor;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.properties.toArray(new PropertyDescriptor[0]);
    }

    public int getPropertyDescriptorCount() {
        return this.properties.size();
    }

    public PropertyDescriptor getPropertyDescriptor(int n) {
        return (PropertyDescriptor)this.properties.get(n);
    }

    protected PropertyDescriptor addPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        this.properties.add(propertyDescriptor);
        return propertyDescriptor;
    }

    public ExtendedPropertyDescriptor addProperty(String string) {
        try {
            if (string == null || string.trim().length() == 0) {
                throw new IntrospectionException("bad property name");
            }
            ExtendedPropertyDescriptor extendedPropertyDescriptor = ExtendedPropertyDescriptor.newPropertyDescriptor(string, this.getType());
            try {
                extendedPropertyDescriptor.setDisplayName(this.getResources().getString(string));
            }
            catch (MissingResourceException missingResourceException) {}
            try {
                extendedPropertyDescriptor.setShortDescription(this.getResources().getString(String.valueOf(string) + ".shortDescription"));
            }
            catch (MissingResourceException missingResourceException) {}
            this.addPropertyDescriptor(extendedPropertyDescriptor);
            return extendedPropertyDescriptor;
        }
        catch (IntrospectionException introspectionException) {
            throw new RuntimeException(introspectionException);
        }
    }

    public PropertyDescriptor removeProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Property name can not be null");
        }
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)iterator.next();
            if (!string.equals(propertyDescriptor.getName())) continue;
            iterator.remove();
            return propertyDescriptor;
        }
        return null;
    }

    @Override
    public Image getIcon(int n) {
        return null;
    }

    public String getText(Object object) {
        return object.toString();
    }

    public String getDescription(Object object) {
        return this.getText(object);
    }

    public String getToolTipText(Object object) {
        return this.getText(object);
    }
}

