/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.beans.editor.FixedButton;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.UserPreferences;
import com.l2fprod.common.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.TransferHandler;

public class FilePropertyEditor
extends AbstractPropertyEditor {
    protected JTextField textfield;
    private JButton button;

    public FilePropertyEditor() {
        this.editor = new JPanel(new BorderLayout(0, 0));
        this.textfield = new JTextField();
        ((JPanel)this.editor).add("Center", this.textfield);
        this.textfield.setEditable(false);
        this.button = new FixedButton("\u9009\u62e9\u56fe\u6807\u6587\u4ef6");
        ((JPanel)this.editor).add("West", this.button);
        this.textfield.setBorder(LookAndFeelTweaks.EMPTY_BORDER);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilePropertyEditor.this.selectFile();
            }
        });
        this.textfield.setTransferHandler(new FileTransferHandler());
    }

    @Override
    public Object getValue() {
        if ("".equals(this.textfield.getText().trim())) {
            return null;
        }
        return new File(this.textfield.getText());
    }

    @Override
    public void setValue(Object object) {
        if (object instanceof File) {
            this.textfield.setText(((File)object).getAbsolutePath());
        } else {
            this.textfield.setText("");
        }
    }

    protected void selectFile() {
        ResourceManager resourceManager = ResourceManager.all(FilePropertyEditor.class);
        JFileChooser jFileChooser = UserPreferences.getDefaultFileChooser();
        jFileChooser.setDialogTitle(resourceManager.getString("FilePropertyEditor.dialogTitle"));
        jFileChooser.setApproveButtonText(resourceManager.getString("FilePropertyEditor.approveButtonText"));
        jFileChooser.setApproveButtonMnemonic(resourceManager.getChar("FilePropertyEditor.approveButtonMnemonic"));
        if (jFileChooser.showOpenDialog(this.editor) == 0) {
            File file = (File)this.getValue();
            File file2 = jFileChooser.getSelectedFile();
            String string = file2.getAbsolutePath();
            this.textfield.setText(string);
            this.firePropertyChange(file, file2);
        }
    }

    class FileTransferHandler
    extends TransferHandler {
        FileTransferHandler() {
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            int n = 0;
            int n2 = dataFlavorArray.length;
            while (n < n2) {
                if (dataFlavorArray[n].equals(DataFlavor.javaFileListFlavor)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            try {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (list.size() > 0) {
                    File file = (File)FilePropertyEditor.this.getValue();
                    File file2 = (File)list.get(0);
                    String string = file2.getAbsolutePath();
                    FilePropertyEditor.this.textfield.setText(string);
                    FilePropertyEditor.this.firePropertyChange(file, file2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
    }
}

