/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.util.converter.ConverterRegistry;
import com.l2fprod.common.util.converter.NumberConverters;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class NumberPropertyEditor
extends AbstractPropertyEditor {
    private final Class type;
    private Object lastGoodValue;

    public NumberPropertyEditor(Class clazz) {
        if (!Number.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("type must be a subclass of Number");
        }
        this.editor = new JFormattedTextField();
        this.type = clazz;
        ((JFormattedTextField)this.editor).setValue(this.getDefaultValue());
        ((JFormattedTextField)this.editor).setBorder(LookAndFeelTweaks.EMPTY_BORDER);
        NumberFormat numberFormat = NumberConverters.getDefaultFormat();
        ((JFormattedTextField)this.editor).setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(numberFormat)));
    }

    @Override
    public Object getValue() {
        String string = ((JTextField)this.editor).getText();
        if (string == null || string.trim().length() == 0) {
            return this.getDefaultValue();
        }
        string = string.replace(',', '.');
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(string.length());
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if ('.' == c || '-' == c || Double.class.equals((Object)this.type) && 'E' == c || Float.class.equals((Object)this.type) && 'E' == c || Character.isDigit(c)) {
                stringBuffer.append(c);
            } else if (' ' != c) break;
            ++n;
        }
        try {
            this.lastGoodValue = ConverterRegistry.instance().convert(this.type, stringBuffer.toString());
        }
        catch (Exception exception) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.editor);
        }
        return this.lastGoodValue;
    }

    @Override
    public void setValue(Object object) {
        if (object instanceof Number) {
            ((JFormattedTextField)this.editor).setText(object.toString());
        } else {
            ((JFormattedTextField)this.editor).setValue(this.getDefaultValue());
        }
        this.lastGoodValue = object;
    }

    private Object getDefaultValue() {
        try {
            return this.type.getConstructor(String.class).newInstance("0");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

