/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.demo;

import com.l2fprod.common.swing.JButtonBar;
import com.l2fprod.common.swing.plaf.blue.BlueishButtonBarUI;
import com.l2fprod.common.swing.plaf.misc.IconPackagerButtonBarUI;
import com.l2fprod.common.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class ButtonBarMain
extends JPanel {
    static ResourceManager RESOURCE = ResourceManager.get(ButtonBarMain.class);

    public ButtonBarMain() {
        this.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.add("Center", jTabbedPane);
        JButtonBar jButtonBar = new JButtonBar(1);
        jButtonBar.setUI(new BlueishButtonBarUI());
        jTabbedPane.addTab("Mozilla L&F", new ButtonBarPanel(jButtonBar));
        jButtonBar = new JButtonBar(1);
        jButtonBar.setUI(new IconPackagerButtonBarUI());
        jTabbedPane.addTab("Icon Packager L&F", new ButtonBarPanel(jButtonBar));
    }

    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JFrame jFrame = new JFrame("ButtonBar");
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add("Center", new ButtonBarMain());
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setLocation(100, 100);
        jFrame.setVisible(true);
    }

    static class ButtonBarPanel
    extends JPanel {
        private Component currentComponent;

        public ButtonBarPanel(JButtonBar jButtonBar) {
            this.setLayout(new BorderLayout());
            this.add("West", jButtonBar);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.addButton(RESOURCE.getString("Main.welcome"), "icons/welcome32x32.png", this.makePanel(RESOURCE.getString("Main.welcome")), jButtonBar, buttonGroup);
            this.addButton(RESOURCE.getString("Main.settings"), "icons/propertysheet32x32.png", this.makePanel(RESOURCE.getString("Main.settings")), jButtonBar, buttonGroup);
            this.addButton(RESOURCE.getString("Main.sounds"), "icons/fonts32x32.png", this.makePanel(RESOURCE.getString("Main.sounds")), jButtonBar, buttonGroup);
            this.addButton(RESOURCE.getString("Main.stats"), "icons/folder32x32.png", this.makePanel(RESOURCE.getString("Main.stats")), jButtonBar, buttonGroup);
        }

        private JPanel makePanel(String string) {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(string);
            jLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jLabel.setOpaque(true);
            jLabel.setBackground(jPanel.getBackground().brighter());
            jPanel.add("North", jLabel);
            jPanel.setPreferredSize(new Dimension(400, 300));
            jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            return jPanel;
        }

        private void show(Component component) {
            if (this.currentComponent != null) {
                this.remove(this.currentComponent);
            }
            this.currentComponent = component;
            this.add("Center", this.currentComponent);
            this.revalidate();
            this.repaint();
        }

        private void addButton(String string, String string2, final Component component, JButtonBar jButtonBar, ButtonGroup buttonGroup) {
            AbstractAction abstractAction = new AbstractAction(string, new ImageIcon(ButtonBarMain.class.getResource(string2))){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ButtonBarPanel.this.show(component);
                }
            };
            JToggleButton jToggleButton = new JToggleButton(abstractAction);
            jButtonBar.add(jToggleButton);
            buttonGroup.add(jToggleButton);
            if (buttonGroup.getSelection() == null) {
                jToggleButton.setSelected(true);
                this.show(component);
            }
        }
    }
}

