/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.demo;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;

public class FakeFileSystemView
extends FileSystemView {
    private Map files = new HashMap();

    public FakeFileSystemView() {
        this.files.put("desktop", new FakeFile("Desktop"));
        this.files.put("computer", new FakeFile("My Computer"));
        this.files.put("A", new FakeFile("A"));
        this.files.put("C", new FakeFile("C"));
        this.files.put("D", new FakeFile("D"));
        this.files.put("getFiles(My Computer)", new File[]{(File)this.files.get("A"), (File)this.files.get("C"), (File)this.files.get("D")});
        this.files.put("network", new FakeFile("My Network Places"));
        this.files.put("getRoots", new File[]{(File)this.files.get("desktop")});
        this.files.put("getFiles(Desktop)", new File[]{(File)this.files.get("computer"), (File)this.files.get("network")});
        FakeFile[] fakeFileArray = new FakeFile[]{new FakeFile("Folder 1"), new FakeFile("Folder 2"), new FakeFile("Folder 3")};
        this.files.put("getFiles(C)", fakeFileArray);
        this.files.put("getFiles(D)", fakeFileArray);
    }

    @Override
    public File createNewFolder(File file) {
        return null;
    }

    @Override
    public File createFileObject(File file, String string) {
        return super.createFileObject(file, string);
    }

    @Override
    public File createFileObject(String string) {
        return super.createFileObject(string);
    }

    @Override
    protected File createFileSystemRoot(File file) {
        return super.createFileSystemRoot(file);
    }

    @Override
    public File getChild(File file, String string) {
        return super.getChild(file, string);
    }

    @Override
    public File getDefaultDirectory() {
        return new FakeFile("Default");
    }

    @Override
    public File[] getFiles(File file, boolean bl) {
        if (file.getName().startsWith("Folder")) {
            return new FakeFile[]{new FakeFile(String.valueOf(file.getName()) + ".1"), new FakeFile(String.valueOf(file.getName()) + ".2"), new FakeFile(String.valueOf(file.getName()) + ".3")};
        }
        File[] fileArray = (File[])this.files.get("getFiles(" + file.getName() + ")");
        if (fileArray == null) {
            return new File[0];
        }
        return fileArray;
    }

    @Override
    public File getHomeDirectory() {
        return new FakeFile("Home");
    }

    @Override
    public File getParentDirectory(File file) {
        return null;
    }

    @Override
    public File[] getRoots() {
        return (File[])this.files.get("getRoots");
    }

    @Override
    public String getSystemDisplayName(File file) {
        return file.getName();
    }

    @Override
    public Icon getSystemIcon(File file) {
        return null;
    }

    @Override
    public String getSystemTypeDescription(File file) {
        return "Description";
    }

    @Override
    public boolean isComputerNode(File file) {
        return this.files.get("computer") == file;
    }

    @Override
    public boolean isDrive(File file) {
        return "C".equals(file.getName()) || "D".equals(file.getName());
    }

    @Override
    public boolean isFileSystem(File file) {
        return false;
    }

    @Override
    public boolean isFileSystemRoot(File file) {
        return false;
    }

    @Override
    public boolean isFloppyDrive(File file) {
        return "A".equals(file.getName());
    }

    @Override
    public boolean isHiddenFile(File file) {
        return false;
    }

    @Override
    public boolean isParent(File file, File file2) {
        return false;
    }

    @Override
    public boolean isRoot(File file) {
        return this.files.get("desktop") == file;
    }

    @Override
    public Boolean isTraversable(File file) {
        return Boolean.TRUE;
    }

    static class FakeFile
    extends File {
        public FakeFile(String string) {
            super(string);
        }

        @Override
        public boolean isDirectory() {
            return true;
        }
    }
}

