/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.demo;

import com.l2fprod.common.swing.JOutlookBar;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import com.l2fprod.common.swing.plaf.metal.MetalLookAndFeelAddons;
import com.l2fprod.common.swing.plaf.windows.WindowsLookAndFeelAddons;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class OutlookBarMain
extends JPanel {
    public OutlookBarMain() throws Exception {
        this.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        LookAndFeelAddons.setAddon(MetalLookAndFeelAddons.class);
        jTabbedPane.addTab("Metal L&F", this.makeOutlookPanel(0));
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        LookAndFeelAddons.setAddon(WindowsLookAndFeelAddons.class);
        jTabbedPane.addTab("Windows L&F", this.makeOutlookPanel(2));
        this.add("Center", jTabbedPane);
    }

    JPanel makeOutlookPanel(int n) {
        JOutlookBar jOutlookBar = new JOutlookBar();
        jOutlookBar.setTabPlacement(2);
        this.addTab(jOutlookBar, "Folders");
        this.addTab(jOutlookBar, "Backup");
        JTree jTree = new JTree();
        jOutlookBar.addTab("A JTree", jOutlookBar.makeScrollPane(jTree));
        jOutlookBar.addTab("Disabled", new JButton());
        jOutlookBar.setEnabledAt(3, false);
        jOutlookBar.setAllTabsAlignment(n);
        JPanel jPanel = new JPanel(new PercentLayout(0, 3));
        jPanel.add((Component)jOutlookBar, "100");
        return jPanel;
    }

    void addTab(JOutlookBar jOutlookBar, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new PercentLayout(1, 0));
        jPanel.setOpaque(false);
        String[] stringArray = new String[]{"Inbox", "icons/outlook-inbox.gif", "Outbox", "icons/outlook-outbox.gif", "Drafts", "icons/outlook-inbox.gif", "Templates", "icons/outlook-inbox.gif", "Deleted Items", "icons/outlook-trash.gif"};
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            JButton jButton = new JButton(stringArray[n]);
            try {
                jButton.setUI((ButtonUI)Class.forName((String)UIManager.get("OutlookButtonUI")).newInstance());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            jButton.setIcon(new ImageIcon(OutlookBarMain.class.getResource(stringArray[n + 1])));
            jPanel.add(jButton);
            n += 2;
        }
        JScrollPane jScrollPane = jOutlookBar.makeScrollPane(jPanel);
        jOutlookBar.addTab("", jScrollPane);
        n2 = jOutlookBar.indexOfComponent(jScrollPane);
        jOutlookBar.setTitleAt(n2, string);
        jOutlookBar.setToolTipTextAt(n2, String.valueOf(string) + " Tooltip");
    }

    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JFrame jFrame = new JFrame("JOutlookBar");
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add("Center", new OutlookBarMain());
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setLocation(100, 100);
        jFrame.setVisible(true);
    }
}

