/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.demo;

import com.l2fprod.common.demo.PropertySheetMain;
import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class PropertySheetPage3
extends JPanel {
    private static final Class THIS_CLASS = PropertySheetPage3.class;
    static ResourceManager RESOURCE = ResourceManager.get(THIS_CLASS);

    public PropertySheetPage3() {
        this.setLayout(LookAndFeelTweaks.createVerticalPercentLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(PropertySheetMain.RESOURCE.getString("Main.sheet1.message"));
        LookAndFeelTweaks.makeMultilineLabel(jTextArea);
        this.add(jTextArea);
        final Colorful colorful = new Colorful();
        colorful.setColor(new Color(255, 153, 102));
        NoReadWriteProperty noReadWriteProperty = new NoReadWriteProperty();
        noReadWriteProperty.setDisplayName("Level 0");
        noReadWriteProperty.setCategory("A category");
        NoReadWriteProperty noReadWriteProperty2 = new NoReadWriteProperty();
        noReadWriteProperty2.setDisplayName("Level 1");
        noReadWriteProperty2.setCategory("Another category");
        noReadWriteProperty.addSubProperty(noReadWriteProperty2);
        NoReadWriteProperty noReadWriteProperty3 = new NoReadWriteProperty();
        noReadWriteProperty3.setDisplayName("Level 2");
        noReadWriteProperty2.addSubProperty(noReadWriteProperty3);
        NoReadWriteProperty noReadWriteProperty4 = new NoReadWriteProperty();
        noReadWriteProperty4.setDisplayName("Level 3");
        noReadWriteProperty2.addSubProperty(noReadWriteProperty4);
        NoReadWriteProperty noReadWriteProperty5 = new NoReadWriteProperty();
        noReadWriteProperty5.setDisplayName("Level 3.1");
        noReadWriteProperty4.addSubProperty(noReadWriteProperty5);
        NoReadWriteProperty noReadWriteProperty6 = new NoReadWriteProperty();
        noReadWriteProperty6.setDisplayName("Root");
        final PropertySheetPanel propertySheetPanel = new PropertySheetPanel();
        propertySheetPanel.setMode(0);
        propertySheetPanel.setProperties(new Property[]{new ColorProperty(), noReadWriteProperty, noReadWriteProperty6});
        propertySheetPanel.readFromObject(colorful);
        propertySheetPanel.setDescriptionVisible(true);
        propertySheetPanel.setSortingCategories(true);
        propertySheetPanel.setSortingProperties(true);
        this.add((Component)propertySheetPanel, "*");
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Property property = (Property)propertyChangeEvent.getSource();
                property.writeToObject(colorful);
                System.out.println("Updated object to " + colorful);
            }
        };
        propertySheetPanel.addPropertySheetChangeListener(propertyChangeListener);
        JButton jButton = new JButton(new AbstractAction("Click to setWantsExtraIndent(true)"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                propertySheetPanel.getTable().setWantsExtraIndent(!propertySheetPanel.getTable().getWantsExtraIndent());
                this.putValue("Name", "Click to setWantsExtraIndent(" + !propertySheetPanel.getTable().getWantsExtraIndent() + ")");
            }
        });
        this.add(jButton);
    }

    public static class ColorComponentProperty
    extends DefaultProperty {
        public ColorComponentProperty(String string) {
            this.setName(string);
            this.setDisplayName(RESOURCE.getString(String.valueOf(string) + ".name"));
            this.setShortDescription(RESOURCE.getString(String.valueOf(string) + ".desc"));
            this.setType(Integer.TYPE);
        }
    }

    public static class ColorProperty
    extends DefaultProperty {
        public ColorProperty() {
            this.setName("color");
            this.setCategory(RESOURCE.getString("color.cat"));
            this.setDisplayName(RESOURCE.getString("color.name"));
            this.setShortDescription(RESOURCE.getString("color.desc"));
            this.setType(Color.class);
            this.addSubProperty(new ColorComponentProperty("red"));
            this.addSubProperty(new ColorComponentProperty("green"));
            this.addSubProperty(new ColorComponentProperty("blue"));
        }
    }

    public static class Colorful {
        private Color color;

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public int getRed() {
            return this.color.getRed();
        }

        public void setRed(int n) {
            this.color = new Color(n, this.getGreen(), this.getBlue());
        }

        public int getGreen() {
            return this.color.getGreen();
        }

        public void setGreen(int n) {
            this.color = new Color(this.getRed(), n, this.getBlue());
        }

        public int getBlue() {
            return this.color.getBlue();
        }

        public void setBlue(int n) {
            this.color = new Color(this.getRed(), this.getGreen(), n);
        }

        public String toString() {
            return this.color.toString();
        }
    }

    static class NoReadWriteProperty
    extends DefaultProperty {
        NoReadWriteProperty() {
        }

        @Override
        public void readFromObject(Object object) {
        }

        @Override
        public void writeToObject(Object object) {
        }
    }
}

