/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.propertysheet.Property;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;

public abstract class AbstractProperty
implements Property {
    private Object value;
    private transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public void setValue(Object object) {
        Object object2 = this.value;
        this.value = object;
        if (!(object == object2 || object != null && object.equals(object2))) {
            this.firePropertyChange(object2, this.getValue());
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addPropertyChangeListener(propertyChangeListener);
        Property[] propertyArray = this.getSubProperties();
        if (propertyArray != null) {
            int n = 0;
            while (n < propertyArray.length) {
                propertyArray[n].addPropertyChangeListener(propertyChangeListener);
                ++n;
            }
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
        Property[] propertyArray = this.getSubProperties();
        if (propertyArray != null) {
            int n = 0;
            while (n < propertyArray.length) {
                propertyArray[n].removePropertyChangeListener(propertyChangeListener);
                ++n;
            }
        }
    }

    protected void firePropertyChange(Object object, Object object2) {
        this.listeners.firePropertyChange("value", object, object2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listeners = new PropertyChangeSupport(this);
    }

    @Override
    public Property getParentProperty() {
        return null;
    }

    @Override
    public Property[] getSubProperties() {
        return null;
    }
}

