/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class CellEditorAdapter
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    protected PropertyEditor editor;
    protected int clickCountToStart = 1;

    public CellEditorAdapter(PropertyEditor propertyEditor) {
        this.editor = propertyEditor;
        Component component = propertyEditor.getCustomEditor();
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            jTextField.addFocusListener(new SelectOnFocus());
            jTextField.addActionListener(new CommitEditing());
            jTextField.registerKeyboardAction(new CancelEditing(), KeyStroke.getKeyStroke(27, 0), 0);
        }
        propertyEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CellEditorAdapter.this.stopCellEditing();
            }
        });
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        return this.getEditor(object);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        return this.getEditor(object);
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getValue();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    private Component getEditor(Object object) {
        this.editor.setValue(object);
        final Component component = this.editor.getCustomEditor();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                component.requestFocus();
            }
        });
        return component;
    }

    class CancelEditing
    implements ActionListener {
        CancelEditing() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CellEditorAdapter.this.cancelCellEditing();
        }
    }

    class CommitEditing
    implements ActionListener {
        CommitEditing() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CellEditorAdapter.this.stopCellEditing();
        }
    }

    class SelectOnFocus
    implements FocusListener {
        SelectOnFocus() {
        }

        @Override
        public void focusGained(final FocusEvent focusEvent) {
            if (!(focusEvent.getSource() instanceof JTextField)) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JTextField)focusEvent.getSource()).selectAll();
                }
            });
        }

        @Override
        public void focusLost(final FocusEvent focusEvent) {
            if (!(focusEvent.getSource() instanceof JTextField)) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JTextField)focusEvent.getSource()).select(0, 0);
                }
            });
        }
    }
}

