/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.beans.BeanUtils;
import com.l2fprod.common.propertysheet.AbstractProperty;
import com.l2fprod.common.propertysheet.Property;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class DefaultProperty
extends AbstractProperty
implements Cloneable {
    private String name;
    private String displayName;
    private String shortDescription;
    private Class type;
    private boolean editable = true;
    private String category;
    private Property parent;
    private List subProperties = new ArrayList();

    @Override
    public Object clone() {
        DefaultProperty defaultProperty = null;
        try {
            defaultProperty = (DefaultProperty)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        defaultProperty.name = this.name;
        defaultProperty.displayName = this.displayName;
        defaultProperty.shortDescription = this.shortDescription;
        defaultProperty.type = this.type;
        defaultProperty.editable = this.editable;
        defaultProperty.category = this.category;
        defaultProperty.setValue(this.getValue());
        return defaultProperty;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String string) {
        this.shortDescription = string;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    public void setType(Class clazz) {
        this.type = clazz;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    @Override
    public void readFromObject(Object object) {
        try {
            Method method = BeanUtils.getReadMethod(object.getClass(), this.getName());
            if (method != null) {
                this.setValue(method.invoke(object, null));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        for (Property property : this.subProperties) {
            property.readFromObject(object);
        }
    }

    @Override
    public void writeToObject(Object object) {
        try {
            Method method = BeanUtils.getWriteMethod(object.getClass(), this.getName(), this.getType());
            if (method != null) {
                method.invoke(object, this.getValue());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.parent != null) {
            this.parent.readFromObject(object);
        }
        for (Property property : this.subProperties) {
            property.readFromObject(object);
        }
    }

    public int hashCode() {
        return 28 + (this.name != null ? this.name.hashCode() : 3) + (this.displayName != null ? this.displayName.hashCode() : 94) + (this.shortDescription != null ? this.shortDescription.hashCode() : 394) + (this.category != null ? this.category.hashCode() : 34) + (this.type != null ? this.type.hashCode() : 39) + Boolean.valueOf(this.editable).hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        DefaultProperty defaultProperty = (DefaultProperty)object;
        return this.compare(this.name, defaultProperty.name) && this.compare(this.displayName, defaultProperty.displayName) && this.compare(this.shortDescription, defaultProperty.shortDescription) && this.compare(this.category, defaultProperty.category) && this.compare(this.type, defaultProperty.type) && this.editable == defaultProperty.editable;
    }

    private boolean compare(Object object, Object object2) {
        return object != null ? object.equals(object2) : object2 == null;
    }

    public String toString() {
        return "name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", type=" + this.getType() + ", category=" + this.getCategory() + ", editable=" + this.isEditable() + ", value=" + this.getValue();
    }

    @Override
    public Property getParentProperty() {
        return null;
    }

    public void setParentProperty(Property property) {
        this.parent = property;
    }

    @Override
    public Property[] getSubProperties() {
        return this.subProperties.toArray(new Property[this.subProperties.size()]);
    }

    public void clearSubProperties() {
        for (Property property : this.subProperties) {
            if (!(property instanceof DefaultProperty)) continue;
            ((DefaultProperty)property).setParentProperty(null);
        }
        this.subProperties.clear();
    }

    public void addSubProperties(Collection collection) {
        this.subProperties.addAll(collection);
        for (Property property : this.subProperties) {
            if (!(property instanceof DefaultProperty)) continue;
            ((DefaultProperty)property).setParentProperty(this);
        }
    }

    public void addSubProperties(Property[] propertyArray) {
        this.addSubProperties(Arrays.asList(propertyArray));
    }

    public void addSubProperty(Property property) {
        this.subProperties.add(property);
        if (property instanceof DefaultProperty) {
            ((DefaultProperty)property).setParentProperty(this);
        }
    }
}

