/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.propertysheet.AbstractProperty;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

class PropertyDescriptorAdapter
extends AbstractProperty {
    private PropertyDescriptor descriptor;

    public PropertyDescriptorAdapter() {
    }

    public PropertyDescriptorAdapter(PropertyDescriptor propertyDescriptor) {
        this();
        this.setDescriptor(propertyDescriptor);
    }

    public void setDescriptor(PropertyDescriptor propertyDescriptor) {
        this.descriptor = propertyDescriptor;
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public String getDisplayName() {
        return this.descriptor.getDisplayName();
    }

    @Override
    public String getShortDescription() {
        return this.descriptor.getShortDescription();
    }

    @Override
    public Class getType() {
        return this.descriptor.getPropertyType();
    }

    @Override
    public Object clone() {
        PropertyDescriptorAdapter propertyDescriptorAdapter = new PropertyDescriptorAdapter(this.descriptor);
        propertyDescriptorAdapter.setValue(this.getValue());
        return propertyDescriptorAdapter;
    }

    @Override
    public void readFromObject(Object object) {
        try {
            Method method = this.descriptor.getReadMethod();
            if (method != null) {
                this.setValue(method.invoke(object, null));
            }
        }
        catch (Exception exception) {
            String string = "Got exception when reading property " + this.getName();
            string = object == null ? String.valueOf(string) + ", object was 'null'" : String.valueOf(string) + ", object was " + String.valueOf(object);
            throw new RuntimeException(string, exception);
        }
    }

    @Override
    public void writeToObject(Object object) {
        try {
            Method method = this.descriptor.getWriteMethod();
            if (method != null) {
                method.invoke(object, this.getValue());
            }
        }
        catch (Exception exception) {
            String string = "Got exception when writing property " + this.getName();
            string = object == null ? String.valueOf(string) + ", object was 'null'" : String.valueOf(string) + ", object was " + String.valueOf(object);
            throw new RuntimeException(string, exception);
        }
    }

    @Override
    public boolean isEditable() {
        return this.descriptor.getWriteMethod() != null;
    }

    @Override
    public String getCategory() {
        if (this.descriptor instanceof ExtendedPropertyDescriptor) {
            return ((ExtendedPropertyDescriptor)this.descriptor).getCategory();
        }
        return null;
    }
}

