/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.beans.editor.BooleanAsCheckBoxPropertyEditor;
import com.l2fprod.common.beans.editor.ColorPropertyEditor;
import com.l2fprod.common.beans.editor.DimensionPropertyEditor;
import com.l2fprod.common.beans.editor.DoublePropertyEditor;
import com.l2fprod.common.beans.editor.FilePropertyEditor;
import com.l2fprod.common.beans.editor.FloatPropertyEditor;
import com.l2fprod.common.beans.editor.InsetsPropertyEditor;
import com.l2fprod.common.beans.editor.IntegerPropertyEditor;
import com.l2fprod.common.beans.editor.LongPropertyEditor;
import com.l2fprod.common.beans.editor.RectanglePropertyEditor;
import com.l2fprod.common.beans.editor.ShortPropertyEditor;
import com.l2fprod.common.beans.editor.StringPropertyEditor;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyDescriptorAdapter;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PropertyEditorRegistry
implements PropertyEditorFactory {
    private Map typeToEditor = new HashMap();
    private Map propertyToEditor = new HashMap();

    public PropertyEditorRegistry() {
        this.registerDefaults();
    }

    @Override
    public PropertyEditor createPropertyEditor(Property property) {
        return this.getEditor(property);
    }

    public synchronized PropertyEditor getEditor(Property property) {
        Class<?> clazz;
        PropertyDescriptor propertyDescriptor;
        PropertyEditor propertyEditor = null;
        if (property instanceof PropertyDescriptorAdapter && (propertyDescriptor = ((PropertyDescriptorAdapter)property).getDescriptor()) != null) {
            if (propertyDescriptor instanceof ExtendedPropertyDescriptor && (clazz = ((ExtendedPropertyDescriptor)propertyDescriptor).getPropertyEditor()) != null) {
                return clazz;
            }
            clazz = propertyDescriptor.getPropertyEditorClass();
            if (clazz != null) {
                propertyEditor = this.loadPropertyEditor(clazz);
            }
        }
        if (propertyEditor == null) {
            propertyDescriptor = this.propertyToEditor.get(property);
            propertyEditor = propertyDescriptor instanceof PropertyEditor ? (PropertyEditor)((Object)propertyDescriptor) : (propertyDescriptor instanceof Class ? this.loadPropertyEditor((Class)((Object)propertyDescriptor)) : this.getEditor(property.getType()));
        }
        if (propertyEditor == null && property instanceof PropertyDescriptorAdapter) {
            propertyDescriptor = ((PropertyDescriptorAdapter)property).getDescriptor();
            clazz = propertyDescriptor.getPropertyType();
            propertyEditor = PropertyEditorManager.findEditor(clazz);
        }
        return propertyEditor;
    }

    private PropertyEditor loadPropertyEditor(Class clazz) {
        PropertyEditor propertyEditor = null;
        try {
            propertyEditor = (PropertyEditor)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return propertyEditor;
    }

    public synchronized PropertyEditor getEditor(Class clazz) {
        PropertyEditor propertyEditor = null;
        Object v = this.typeToEditor.get(clazz);
        if (v instanceof PropertyEditor) {
            propertyEditor = (PropertyEditor)v;
        } else if (v instanceof Class) {
            try {
                propertyEditor = (PropertyEditor)((Class)v).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return propertyEditor;
    }

    public synchronized void registerEditor(Class clazz, Class clazz2) {
        this.typeToEditor.put(clazz, clazz2);
    }

    public synchronized void registerEditor(Class clazz, PropertyEditor propertyEditor) {
        this.typeToEditor.put(clazz, propertyEditor);
    }

    public synchronized void unregisterEditor(Class clazz) {
        this.typeToEditor.remove(clazz);
    }

    public synchronized void registerEditor(Property property, Class clazz) {
        this.propertyToEditor.put(property, clazz);
    }

    public synchronized void registerEditor(Property property, PropertyEditor propertyEditor) {
        this.propertyToEditor.put(property, propertyEditor);
    }

    public synchronized void unregisterEditor(Property property) {
        this.propertyToEditor.remove(property);
    }

    public void registerDefaults() {
        this.typeToEditor.clear();
        this.propertyToEditor.clear();
        this.registerEditor(String.class, StringPropertyEditor.class);
        this.registerEditor(Double.TYPE, DoublePropertyEditor.class);
        this.registerEditor(Double.class, DoublePropertyEditor.class);
        this.registerEditor(Float.TYPE, FloatPropertyEditor.class);
        this.registerEditor(Float.class, FloatPropertyEditor.class);
        this.registerEditor(Integer.TYPE, IntegerPropertyEditor.class);
        this.registerEditor(Integer.class, IntegerPropertyEditor.class);
        this.registerEditor(Long.TYPE, LongPropertyEditor.class);
        this.registerEditor(Long.class, LongPropertyEditor.class);
        this.registerEditor(Short.TYPE, ShortPropertyEditor.class);
        this.registerEditor(Short.class, ShortPropertyEditor.class);
        this.registerEditor(Boolean.TYPE, BooleanAsCheckBoxPropertyEditor.class);
        this.registerEditor(Boolean.class, BooleanAsCheckBoxPropertyEditor.class);
        this.registerEditor(File.class, FilePropertyEditor.class);
        this.registerEditor(Color.class, ColorPropertyEditor.class);
        this.registerEditor(Dimension.class, DimensionPropertyEditor.class);
        this.registerEditor(Insets.class, InsetsPropertyEditor.class);
        try {
            Class<?> clazz = Class.forName("com.l2fprod.common.beans.editor.FontPropertyEditor");
            this.registerEditor(Font.class, clazz);
        }
        catch (Exception exception) {}
        this.registerEditor(Rectangle.class, RectanglePropertyEditor.class);
        boolean bl = false;
        try {
            Class.forName("com.toedter.calendar.JDateChooser");
            this.registerEditor(Date.class, Class.forName("com.l2fprod.common.beans.editor.JCalendarDatePropertyEditor"));
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (!bl) {
            try {
                Class.forName("net.sf.nachocalendar.components.DateField");
                this.registerEditor(Date.class, Class.forName("com.l2fprod.common.beans.editor.NachoCalendarDatePropertyEditor"));
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }
}

