/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyDescriptorAdapter;
import com.l2fprod.common.propertysheet.PropertyRendererFactory;
import com.l2fprod.common.swing.renderer.BooleanCellRenderer;
import com.l2fprod.common.swing.renderer.ColorCellRenderer;
import com.l2fprod.common.swing.renderer.DateRenderer;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.awt.Color;
import java.beans.PropertyDescriptor;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class PropertyRendererRegistry
implements PropertyRendererFactory {
    private Map typeToRenderer = new HashMap();
    private Map propertyToRenderer = new HashMap();

    public PropertyRendererRegistry() {
        this.registerDefaults();
    }

    @Override
    public TableCellRenderer createTableCellRenderer(Property property) {
        return this.getRenderer(property);
    }

    @Override
    public TableCellRenderer createTableCellRenderer(Class clazz) {
        return this.getRenderer(clazz);
    }

    public synchronized TableCellRenderer getRenderer(Property property) {
        PropertyDescriptor propertyDescriptor;
        TableCellRenderer tableCellRenderer = null;
        if (property instanceof PropertyDescriptorAdapter && (propertyDescriptor = ((PropertyDescriptorAdapter)property).getDescriptor()) instanceof ExtendedPropertyDescriptor) {
            TableCellRenderer tableCellRenderer2 = ((ExtendedPropertyDescriptor)propertyDescriptor).getTableCellRenderer();
            if (tableCellRenderer2 != null) {
                return tableCellRenderer2;
            }
            if (((ExtendedPropertyDescriptor)propertyDescriptor).getPropertyTableRendererClass() != null) {
                try {
                    return (TableCellRenderer)((ExtendedPropertyDescriptor)propertyDescriptor).getPropertyTableRendererClass().newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if ((propertyDescriptor = this.propertyToRenderer.get(property)) instanceof TableCellRenderer) {
            tableCellRenderer = (TableCellRenderer)((Object)propertyDescriptor);
        } else if (propertyDescriptor instanceof Class) {
            try {
                tableCellRenderer = (TableCellRenderer)((Class)((Object)propertyDescriptor)).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            tableCellRenderer = this.getRenderer(property.getType());
        }
        return tableCellRenderer;
    }

    public synchronized TableCellRenderer getRenderer(Class clazz) {
        TableCellRenderer tableCellRenderer = null;
        Object v = this.typeToRenderer.get(clazz);
        if (v instanceof TableCellRenderer) {
            tableCellRenderer = (TableCellRenderer)v;
        } else if (v instanceof Class) {
            try {
                tableCellRenderer = (TableCellRenderer)((Class)v).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return tableCellRenderer;
    }

    public synchronized void registerRenderer(Class clazz, Class clazz2) {
        this.typeToRenderer.put(clazz, clazz2);
    }

    public synchronized void registerRenderer(Class clazz, TableCellRenderer tableCellRenderer) {
        this.typeToRenderer.put(clazz, tableCellRenderer);
    }

    public synchronized void unregisterRenderer(Class clazz) {
        this.typeToRenderer.remove(clazz);
    }

    public synchronized void registerRenderer(Property property, Class clazz) {
        this.propertyToRenderer.put(property, clazz);
    }

    public synchronized void registerRenderer(Property property, TableCellRenderer tableCellRenderer) {
        this.propertyToRenderer.put(property, tableCellRenderer);
    }

    public synchronized void unregisterRenderer(Property property) {
        this.propertyToRenderer.remove(property);
    }

    public void registerDefaults() {
        this.typeToRenderer.clear();
        this.propertyToRenderer.clear();
        DefaultCellRenderer defaultCellRenderer = new DefaultCellRenderer();
        defaultCellRenderer.setShowOddAndEvenRows(false);
        ColorCellRenderer colorCellRenderer = new ColorCellRenderer();
        colorCellRenderer.setShowOddAndEvenRows(false);
        BooleanCellRenderer booleanCellRenderer = new BooleanCellRenderer();
        DateRenderer dateRenderer = new DateRenderer();
        dateRenderer.setShowOddAndEvenRows(false);
        this.registerRenderer(Object.class, (TableCellRenderer)defaultCellRenderer);
        this.registerRenderer(Color.class, (TableCellRenderer)colorCellRenderer);
        this.registerRenderer(Boolean.TYPE, (TableCellRenderer)booleanCellRenderer);
        this.registerRenderer(Boolean.class, (TableCellRenderer)booleanCellRenderer);
        this.registerRenderer(Byte.TYPE, (TableCellRenderer)defaultCellRenderer);
        this.registerRenderer(Byte.class, (TableCellRenderer)defaultCellRenderer);
        this.registerRenderer(Character.TYPE, (TableCellRenderer)defaultCellRenderer);
        this.registerRenderer(Character.class, (TableCellRenderer)defaultCellRenderer);
        this.registerRenderer(Double.TYPE, (TableCellRenderer)defaultCellRenderer);
        this.registerRenderer(Double.class, (TableCellRenderer)defaultCellRenderer);
        this.registerRenderer(Float.TYPE, (TableCellRenderer)defaultCellRenderer);
        this.registerRenderer(Float.class, (TableCellRenderer)defaultCellRenderer);
        this.registerRenderer(Integer.TYPE, (TableCellRenderer)defaultCellRenderer);
        this.registerRenderer(Integer.class, (TableCellRenderer)defaultCellRenderer);
        this.registerRenderer(Long.TYPE, (TableCellRenderer)defaultCellRenderer);
        this.registerRenderer(Long.class, (TableCellRenderer)defaultCellRenderer);
        this.registerRenderer(Short.TYPE, (TableCellRenderer)defaultCellRenderer);
        this.registerRenderer(Short.class, (TableCellRenderer)defaultCellRenderer);
        this.registerRenderer(Date.class, (TableCellRenderer)dateRenderer);
    }
}

